/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.main.dialog;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.service.PatchService;
import com.huawei.ism.tool.devicepatch.ui.main.dialog.PatchDetailDialogLayout;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.ZipSizeUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JDialog;

public class PatchDetailDialog
extends PublicDialog {
    private static final long serialVersionUID = 1L;
    private PatchDetailDialogLayout layout = null;
    private DevPatch devPatch;
    private DevNode devNode;
    private boolean noPathChange;
    private String oldPath = "";
    private static final int DIALOG_WIDTH = 220;
    private static final long LONG2 = 2L;
    private static final long LONG1024 = 1024L;

    public PatchDetailDialog(DevPatch devPatch, DevNode devNode, boolean noPathChange, boolean starting, Window parent) {
        super(parent);
        this.devPatch = devPatch;
        this.devNode = devNode;
        this.noPathChange = noPathChange;
        this.setModal(true);
        this.init();
        this.initData(starting);
        this.addListener();
    }

    private void init() {
        this.layout = new PatchDetailDialogLayout(this.noPathChange);
        this.layout.setCompName();
        this.add(this.layout);
        this.setTitle(ResourceUtil.getString((String)"patch.card.step2.table.detail"));
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
    }

    private void initData(boolean starting) {
        this.layout.getPatchVersionLabel().setText(this.devPatch.getBatchInfo().getVersion());
        this.layout.getPatchPathInput().setText(this.devPatch.getBatchInfo().getPatchPath());
        if ("NON_AUTOMATIC".equals(this.devNode.getMatchType())) {
            this.layout.getPatchDetailLabel().setText(this.devPatch.getBatchInfo().getVersion());
        } else {
            this.layout.getPatchDetailLabel().setText(this.devPatch.getBatchInfo().getDescription());
        }
        this.oldPath = this.devPatch.getBatchInfo().getPatchPath();
        if (starting) {
            this.layout.getExplorePathButton().setEnabled(false);
            this.getOkBtn().setEnabled(false);
        }
    }

    private void addListener() {
        this.layout.getExplorePathButton().addActionListener(new ModifyPatchPathListener());
        JButton okButton = this.getOkBtn();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PatchDetailDialog.this.okClick();
            }
        });
    }

    private void okClick() {
        String pathTextString = null;
        if (null != this.layout && null != this.layout.getPatchPathInput()) {
            pathTextString = this.layout.getPatchPathInput().getText();
            pathTextString = FilePathUtils.getSafePath((String)pathTextString);
        }
        if (this.noPathChange) {
            ToolLoggerFactory.getLogger(this.getClass()).info("Patch path  change to " + pathTextString + " failed. no path change.");
            this.dispose();
            return;
        }
        if (!this.checkPath()) {
            ToolLoggerFactory.getLogger(this.getClass()).info("Patch path  change to " + pathTextString + " failed. check path");
            return;
        }
        if (null != pathTextString) {
            String confSize = UserOpDataSaveUtil.getToolIniProp((String)"tool.patchpkg.memory");
            if (StringUtils.isDigit((String)confSize) && new File(pathTextString).getFreeSpace() < (long)StringUtils.str2Int((String)confSize) * 1024L * 1024L) {
                DialogUtils.showInfoDialog((JDialog)this, (String)MessageFormat.format(ResourceUtil.getString((String)"patch.dialog.detail.batchpkg.insufficiency"), confSize));
                return;
            }
            long fileRealSize = ZipSizeUtils.getRealSize(pathTextString);
            if (fileRealSize > 0x80000000L) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"patch.dialog.detail.batchpkg.outsize"));
                return;
            }
        }
        String msg = ResourceUtil.getString((String)"patch.dialog.detail.showinfo.pathsucc");
        String resultMsg = "";
        List result = AsyncExcutor.execute((Window)this, (String)ResourceUtil.getString((String)"patch.card.setpatchinfo.pkg.cheaking"), (int)220, (Callable[])new Callable[]{new PatchPkgCheck()});
        resultMsg = (String)result.get(0);
        if (msg.equals(resultMsg)) {
            this.devPatch.getBatchInfo().setPatchPath(this.layout.getPatchPathInput().getText());
            this.layout.getPatchVersionLabel().setText(this.devPatch.getBatchInfo().getVersion());
            PatchDataContext.getInstance().getMainDialog().modifyPath(this.devPatch);
            DialogUtils.showInfoDialog((JDialog)this, (String)msg);
            ToolLoggerFactory.getLogger(this.getClass()).info("Patch path changed to " + pathTextString + " success");
            this.dispose();
        } else {
            ToolLoggerFactory.getLogger(this.getClass()).info("Patch path  change to " + pathTextString + " failed.  check patch pkg");
            DialogUtils.showInfoDialog((JDialog)this, (String)resultMsg);
        }
    }

    private boolean checkPath() {
        String path = this.layout.getPatchPathInput().getText();
        if (StringUtils.isNULLStr((String)path)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"patch.card.step2.showinfo.choose.patchpath"));
            return false;
        }
        if (path.equals(this.oldPath)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"patch.dialog.detail.showinfo.nochange"));
            return false;
        }
        return true;
    }

    private class ModifyPatchPathListener
    implements ActionListener {
        private ModifyPatchPathListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            HashMap<String, String> extParams = new HashMap<String, String>();
            extParams.put("title", ResourceUtil.getString((String)"patch.dialog.detail.selectpatch"));
            extParams.put("PathId", "DevicePatch_select_id_package");
            extParams.put("description", ".tgz");
            File selectFile = ToolFileChooser.selectFile((Window)PatchDetailDialog.this, new String[]{"tgz"}, 0, true, extParams);
            if (selectFile != null) {
                if (!selectFile.exists()) {
                    DialogUtils.showInfoDialog((JDialog)PatchDetailDialog.this, (String)ResourceUtil.getString((String)"patch.card.step2.showinfo.choose.patchpath"));
                    return;
                }
                try {
                    PatchDetailDialog.this.layout.getPatchPathInput().setText(selectFile.getCanonicalPath());
                }
                catch (IOException ioe) {
                    ToolLoggerFactory.getLogger(this.getClass()).error("get file path failed");
                }
            }
        }
    }

    private class PatchPkgCheck
    implements Callable<String> {
        private PatchPkgCheck() {
        }

        @Override
        public String call() {
            return PatchService.getInstance().checkBatchPath(PatchDetailDialog.this.layout.getPatchPathInput().getText(), PatchDetailDialog.this.devPatch.getBatchInfo(), PatchDetailDialog.this.devPatch, PatchDetailDialog.this);
        }
    }
}

