/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.main.dialog;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PatchDetailDialogLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Dimension DEFAULT_SIZE = new Dimension(400, 260);
    private JTextArea patchVersionLabel = null;
    private JTextArea patchDetailLabel = null;
    private JTextField patchPathInput = null;
    private JButton explorePathButton = null;

    public PatchDetailDialogLayout(boolean noPathChange) {
        this.initComponent();
        this.layoutComponent(noPathChange);
    }

    private void initComponent() {
        this.patchVersionLabel = UiMethod.createJTextArea("");
        this.patchDetailLabel = new JTextArea("--");
        this.patchDetailLabel.setEditable(false);
        this.patchDetailLabel.setLineWrap(true);
        this.patchDetailLabel.setMargin(new Insets(5, 5, 5, 5));
        this.patchPathInput = new JTextField();
        this.patchPathInput.setEditable(false);
        this.explorePathButton = UiMethod.createButton(ResourceUtil.getString((String)"patch.dialog.detail.button.modify"), 'M');
    }

    private void layoutComponent(boolean noPathChange) {
        Box box = Box.createVerticalBox();
        JComponent com = this.detailPanel();
        if (noPathChange) {
            box.add(com);
        } else {
            box.add(this.versionPanel());
            box.add(Box.createVerticalStrut(12));
            box.add(com);
            box.add(Box.createVerticalStrut(12));
            box.add(this.selectPanel());
        }
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace(box, 12));
    }

    private JComponent selectPanel() {
        return UiMethod.buildCompsLeft(this.patchPathInput, Box.createHorizontalGlue(), this.explorePathButton);
    }

    private JComponent detailPanel() {
        JScrollPane scorll = new JScrollPane();
        scorll.setVerticalScrollBarPolicy(20);
        scorll.setHorizontalScrollBarPolicy(30);
        scorll.getViewport().add((Component)this.patchDetailLabel, null);
        scorll.setPreferredSize(DEFAULT_SIZE);
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft(UiMethod.createLabel(ResourceUtil.getString((String)"patch.dialog.detail.msg"))), UiMethod.buildCompsLeft(scorll)});
    }

    private JComponent versionPanel() {
        JLabel label = UiMethod.createLabel(ResourceUtil.getString((String)"patch.dialog.detail.version"));
        return UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{label}), UCD.buildHBoxLeft((Component[])new Component[]{this.patchVersionLabel})});
    }

    public JTextArea getPatchVersionLabel() {
        return this.patchVersionLabel;
    }

    public JTextArea getPatchDetailLabel() {
        return this.patchDetailLabel;
    }

    public JTextField getPatchPathInput() {
        return this.patchPathInput;
    }

    public JButton getExplorePathButton() {
        return this.explorePathButton;
    }

    public void setCompName() {
        this.patchVersionLabel.setName("_Label_patchVersionLabel");
        this.patchDetailLabel.setName("_Label_patchDetailLabel");
        this.patchPathInput.setName("_TextField_patchPathInput");
        this.explorePathButton.setName("_Button_explorePathButton");
    }
}

