/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.ui.main.dialog;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.table.TableModel;

public class SupportDevDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Dimension DIALOG_SIZE = new Dimension(450, 530);
    private String[] titles = new String[]{ResourceUtil.getString((String)"patch.main.table.model"), ResourceUtil.getString((String)"patch.card.step1.table.version")};
    private DefaultTableModel tableModel = new DefaultTableModel(this.titles, new int[0]);
    private IsmTable verTable = null;
    private JButton okButton = UiMethod.createButton(ResourceUtil.getString((String)"patch.dialog.support.button.ok"), 'C');
    private static final String SEPARATOR = " ; ";

    public SupportDevDialog(Window parent) {
        super(parent);
        this.initUI();
        this.initData();
        this.addListener();
    }

    private void addListener() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SupportDevDialog.this.dispose();
            }
        });
    }

    private void initData() {
        List<BizPackage> pkgs = PatchDataContext.getInstance().getBizPackages();
        if (pkgs == null || pkgs.isEmpty()) {
            return;
        }
        this.createSupportModelAndVersTableRow(pkgs);
    }

    private void createSupportModelAndVersTableRow(List<BizPackage> pkgs) {
        Map<String, List<String>> supportModelAndVers = this.getSupportModelAndVer(pkgs);
        ArrayList<String> supportModelList = new ArrayList<String>(supportModelAndVers.keySet());
        boolean isA800Scene = SceneUtils.isA800SceneInTool();
        for (String model : supportModelList) {
            if (this.filterSupportByScene(model, isA800Scene)) continue;
            List<String> supportVersionList = supportModelAndVers.get(model);
            List<String> supportVersions = SupportDevDialog.delDuplicateVersions(supportVersionList);
            Collections.sort(supportVersions);
            String supportVersionStr = this.listToString(supportVersions, SEPARATOR);
            DefaultTableRow row = new DefaultTableRow(this.tableModel.getColumnCount(), (Object)model);
            row.setValueAt(0, (Object)model);
            row.setValueAt(1, (Object)supportVersionStr);
            this.tableModel.addRow(new TableRow[]{row});
        }
    }

    private boolean filterSupportByScene(String model, boolean isA800Scene) {
        return isA800Scene != ItDeviceType.A800_NODE.getName().equals(model);
    }

    private Map<String, List<String>> getSupportModelAndVer(List<BizPackage> pkgs) {
        TreeMap<String, List<String>> supportProductAndVers = new TreeMap<String, List<String>>();
        for (BizPackage pkg : pkgs) {
            for (PackProduct pro : pkg.getPackProducts()) {
                List<String> vers = new ArrayList();
                String model = pro.getProductName();
                if (supportProductAndVers.containsKey(model)) {
                    vers = (List)supportProductAndVers.get(model);
                }
                for (String ver : pro.getVersions()) {
                    vers.add(ver);
                }
                supportProductAndVers.put(model, vers);
            }
        }
        return supportProductAndVers;
    }

    private void initUI() {
        this.setTitle(ResourceUtil.getString((String)"patch.card.step1.desc5"));
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        this.setMinimumSize(DIALOG_SIZE);
        SwingUtil.putScreenCenter((Window)this);
        JLabel desc = UiMethod.createLabel(ResourceUtil.getString((String)"patch.dialog.support.desc"));
        JComponent mainCom = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft(desc), this.buildTablePanel(), this.bulidButtonPanel()});
        this.okButton.setName("_Button_okButton");
        this.verTable.setName("_Table_verTable");
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace(mainCom, 12));
    }

    public JComponent buildTablePanel() {
        this.verTable = new IsmTable((TableModel)this.tableModel);
        return new TableScrollPane(this.verTable);
    }

    public JComponent bulidButtonPanel() {
        return UCD.buildHBoxRight((Component[])new Component[]{this.okButton});
    }

    private String listToString(List<String> supportVersionList, String separator) {
        StringBuffer versionsBuffer = new StringBuffer();
        if (supportVersionList == null || supportVersionList.isEmpty()) {
            return "";
        }
        for (String version : supportVersionList) {
            versionsBuffer.append(separator);
            versionsBuffer.append(version);
        }
        versionsBuffer.delete(0, separator.length());
        return versionsBuffer.toString();
    }

    private static List<String> delDuplicateVersions(List<String> baseVersionList) {
        ArrayList<String> verList = new ArrayList<String>();
        HashSet<String> verSet = new HashSet<String>();
        verSet.addAll(baseVersionList);
        verList.addAll(verSet);
        return verList;
    }
}

