/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.utils;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.ExecuteResult;
import com.huawei.ism.tool.devicepatch.utils.ConfirmDetailDialog;
import com.huawei.ism.tool.devicepatch.utils.DevicePatchConstants;
import com.huawei.ism.tool.devicepatch.utils.PatchSceneUtil;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.pyengine.utils.PyJavaUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.io.File;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class DevicePatchUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevicePatchUtil.class);
    public static final Pattern SPH_VERSION_PATTERN = Pattern.compile("SPH\\d+");
    private static final int BUTTON_WIDTH = 80;
    private static final String IGNORE = "yes";

    private DevicePatchUtil() {
    }

    public static String getDisplayModel(DevNode devNode) {
        if (ApplicationContext.getInstance().isOEM()) {
            return devNode.getOemModel();
        }
        return devNode.getDeviceType().toString();
    }

    public static String getA800Name(String sn) {
        List devNodes = DefaultNodeProviderImpl.getInstance().getNodeList();
        return devNodes.stream().filter(devNode -> devNode instanceof AiDevNode).map(devNode -> (AiDevNode)devNode).flatMap(aiDevNode -> aiDevNode.getA800Nodes().stream()).filter(a800Node -> a800Node.getZones().stream().anyMatch(dmeNode -> Objects.equals(dmeNode.getDeviceSerialNumber(), sn))).findFirst().map(DevNode::getDeviceName).orElse("");
    }

    public static synchronized boolean showYesNoDialog(String waringMsg, String okInfo, String cancelInfo) {
        WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)PatchDataContext.getInstance().getMainDialog(), (String)waringMsg, (String)okInfo, (String)cancelInfo, (int)80, (int)80);
        int userChoice = warningDialog.getValue();
        return 0 == userChoice;
    }

    public static synchronized boolean showYesNoDialog(Window parent, String waringMsg, String okInfo, String cancelInfo) {
        WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)parent, (String)waringMsg, (String)okInfo, (String)cancelInfo, (int)80, (int)80);
        return 0 == warningDialog.getValue();
    }

    public static synchronized boolean showYesNoDialog(String waringMsg, String okInfo, String cancelInfo, int okWidth, int cancelWidth) {
        WarningDialog warningDialog = DialogUtils.showYesNoWarningDialog((Window)PatchDataContext.getInstance().getMainDialog(), (String)waringMsg, (String)okInfo, (String)cancelInfo, (int)okWidth, (int)cancelWidth);
        int userChoice = warningDialog.getValue();
        return 0 == userChoice;
    }

    public static synchronized boolean showWarnOptConfimDialog() {
        try {
            ConfirmDetailDialog cdd = new ConfirmDetailDialog(PatchDataContext.getInstance().getMainDialog());
            cdd.setVisible(true);
            int userChoice = cdd.getValue();
            if (0 == userChoice) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("showWarnOptConfimDialog ERR", (Throwable)e);
        }
        return false;
    }

    public static synchronized boolean showIgnoreWarningDialog() {
        String okInfo = ResourceUtil.getString((String)"patch.main.dialog.buttion.ignore");
        String cancelInfo = ResourceUtil.getString((String)"patch.main.dialog.buttion.cancel");
        String waringMsg = ResourceUtil.getString((String)"patch.main.dialog.ingore.precheck");
        WarningDialog warningDialog = DialogUtils.showYesNoWarningDialog((Window)PatchDataContext.getInstance().getMainDialog(), (String)waringMsg, (String)okInfo, (String)cancelInfo, (int)80, (int)80);
        int userChoice = warningDialog.getValue();
        return 0 == userChoice;
    }

    public static void addNewCheckItems(DevNode node, List<ExecuteResult> oldResults, List<Object> jsonMsg) {
        List mpItems = PyJavaUtils.convertPyList2Jlist(jsonMsg);
        for (Map newItem : mpItems) {
            boolean isExists = false;
            for (ExecuteResult oldItems : oldResults) {
                if (!oldItems.getDescription().equals(newItem.get("name"))) continue;
                isExists = true;
                DevicePatchUtil.updateOldCheckItem(oldItems, newItem);
            }
            if (isExists) continue;
            ExecuteResult newCheckItem = DevicePatchUtil.createNewCheckItem(node, newItem);
            newCheckItem.setProcess(70);
            oldResults.add(newCheckItem);
        }
    }

    private static void updateOldCheckItem(ExecuteResult oldItem, Map<String, Object> newItem) {
        int itermStatusIndex = Integer.valueOf(String.valueOf(newItem.get("status")));
        DevicePatchConstants.CheckItemStatus itemStatus = DevicePatchConstants.CheckItemStatus.valueOf(itermStatusIndex);
        DevicePatchUtil.setCheckItemStatus(oldItem, itemStatus);
        oldItem.setDeatail(String.valueOf(newItem.get("suggession")));
        oldItem.setOriginInfo(String.valueOf(newItem.get("originInfo")));
    }

    private static ExecuteResult createNewCheckItem(DevNode node, Map<String, Object> newItem) {
        ExecuteResult checkItem = new ExecuteResult(null);
        checkItem.setDevNode(node);
        checkItem.setItemType(String.valueOf(newItem.get("itemType")));
        checkItem.setItemId(String.valueOf(newItem.get("nameId")));
        checkItem.setDescription(String.valueOf(newItem.get("name")));
        String startTime = newItem.get("startTime").toString();
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = simpleDateFormat.parse(startTime);
            checkItem.setStartDate(date);
        }
        catch (ParseException e) {
            LOGGER.error("parse exception, startTime={}", (Object)startTime);
        }
        int itermStatusIndex = Integer.valueOf(String.valueOf(newItem.get("status")));
        DevicePatchConstants.CheckItemStatus itemStatus = DevicePatchConstants.CheckItemStatus.valueOf(itermStatusIndex);
        DevicePatchUtil.setCheckItemStatus(checkItem, itemStatus);
        return checkItem;
    }

    public static void setCheckItemStatus(ExecuteResult checkItem, DevicePatchConstants.CheckItemStatus itemStatus) {
        switch (itemStatus) {
            case CHECKING: {
                checkItem.setProcessing(true);
                break;
            }
            case FAILED: {
                checkItem.setProcessing(false);
                checkItem.setSuccess(false);
                break;
            }
            case SUCCEEDED: {
                checkItem.setProcessing(false);
                checkItem.setSuccess(true);
                break;
            }
        }
    }

    public static boolean isSameTypeAndVer(List<DevNode> devs) {
        if (devs.size() == 1) {
            return true;
        }
        DevNode firstDev = devs.get(0);
        for (int i = 1; i < devs.size(); ++i) {
            DevNode tempDev = devs.get(i);
            if (firstDev.getDeviceType().equals(tempDev.getDeviceType()) && Products.compareVersion(firstDev.getProductVersion(), tempDev.getProductVersion()) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isPatchMatchSysVer(List<DevPatch> devPatchList, String targetVer) {
        return DevicePatchUtil.isVRCVersionAllMatchToPatch(devPatchList, Products.getVRCVersion(targetVer)) && DevicePatchUtil.isSphAllMatchSpcVersionToPatch(devPatchList, targetVer);
    }

    private static boolean isSphAllMatchSpcVersionToPatch(List<DevPatch> devPatchList, String targetVer) {
        return devPatchList.stream().allMatch(devPatch -> DevicePatchUtil.checkSphMatchSpcVersionMultiDevs(targetVer, devPatch));
    }

    private static boolean isVRCVersionAllMatchToPatch(List<DevPatch> devPatchList, String targetVrcVer) {
        return devPatchList.stream().allMatch(devPatch -> DevicePatchUtil.checkVRCVersionMatched(targetVrcVer, devPatch));
    }

    private static boolean checkSphMatchSpcVersionMultiDevs(String targetVer, DevPatch devPatch) {
        return devPatch.getDevNode().stream().anyMatch(devNode -> DevicePatchUtil.isSphMatchSpcVersion(devNode.getProductVersion(), targetVer));
    }

    private static boolean checkVRCVersionMatched(String targetVrcVer, DevPatch devPatch) {
        return devPatch.getDevNode().stream().allMatch(devNode -> DevicePatchUtil.isVRCVersionMatched(targetVrcVer, devNode));
    }

    private static boolean isVRCVersionMatched(String targetVrcVer, DevNode devNode) {
        LOGGER.info("----checkVRCVersion,productVersion:{},targetPatchVer:{}", (Object)devNode.getProductVersion(), (Object)targetVrcVer);
        String devVersion = DevicePatchUtil.filterKunpeng(devNode.getProductVersion());
        return Products.compareVersion(Products.getVRCVersion(devVersion), targetVrcVer) == 0;
    }

    @NotNull
    private static String filterKunpeng(String devVersion) {
        if (devVersion.contains("Kunpeng")) {
            return devVersion.replace("Kunpeng", "").trim();
        }
        return devVersion;
    }

    public static boolean isPatchSysVersionMatched(String productVersion, String targetPatchVer) {
        return DevicePatchUtil.isVRCVersionMatched(productVersion, targetPatchVer) && DevicePatchUtil.isSphMatchSpcVersion(productVersion, targetPatchVer);
    }

    private static boolean isVRCVersionMatched(String productVersion, String targetPatchVer) {
        LOGGER.info("----isVRCVersionMatched,productVersion:{},targetPatchVer:{}", (Object)productVersion, (Object)targetPatchVer);
        String targetVrcVer = Products.getVRCVersion(targetPatchVer);
        if ("--".equals(targetVrcVer)) {
            return true;
        }
        String devVersion = DevicePatchUtil.filterKunpeng(productVersion);
        return Products.compareVersion(Products.getVRCVersion(devVersion), targetVrcVer) == 0;
    }

    public static boolean isSphMatchSpcVersion(String productVersion, String targetPatchVer) {
        LOGGER.info("----checkSphMatchSpcVersion,productVersion:{},targetPatchVer:{}", (Object)productVersion, (Object)targetPatchVer);
        Pattern pattern = Pattern.compile("V\\d{3}R\\d{3}C\\d{2}SPH\\d{3}");
        Matcher matcher = pattern.matcher(targetPatchVer);
        if (!matcher.find()) {
            return true;
        }
        return targetPatchVer.contains(DevicePatchUtil.getMatchRegex(DevicePatchUtil.filterKunpeng(productVersion)));
    }

    @NotNull
    private static String getMatchRegex(String productVersion) {
        if (productVersion.contains("SPC")) {
            return productVersion.substring(0, productVersion.indexOf("SPC") + 4).replace("SPC", "SPH");
        }
        return productVersion + "SPH0";
    }

    private static void cleanSubPatchPkgDir(String subPatchPkgPath) {
        File subPatchFile = new File(subPatchPkgPath);
        if (!subPatchFile.exists()) {
            return;
        }
        String subPatchPkgDir = Paths.get(subPatchPkgPath, new String[0]).getParent().toString();
        File subPatchPkgParent = new File(subPatchPkgDir);
        if (!subPatchPkgParent.exists() || !subPatchPkgParent.isDirectory()) {
            return;
        }
        String[] files = subPatchPkgParent.list();
        if (Arrays.asList(files).contains("version.conf")) {
            LOGGER.info("clear sub patch pkg dir:{}", (Object)subPatchPkgDir);
            FileUtils.clearDir((String)subPatchPkgDir);
        }
    }

    public static void cleanTempSubPatchPkg(DevNode devNode) {
        Map<String, Object> context = PatchDataContext.getInstance().getContextMap();
        String sn = devNode.getDeviceSerialNumber();
        String packagePathKey = sn + "_packagePath";
        String subPatchPkgPath = context.getOrDefault(packagePathKey, "").toString();
        LOGGER.info("clear sub patch pkg path:{}", (Object)subPatchPkgPath);
        DevicePatchUtil.cleanSubPatchPkgDir(subPatchPkgPath);
    }

    public static void cleanAllSubPatchPkg() {
        Map<String, Object> context = PatchDataContext.getInstance().getContextMap();
        for (String packagePathKey : context.keySet()) {
            if (!packagePathKey.contains("_packagePath")) continue;
            LOGGER.info("clear sub patch pkg path:{}", (Object)packagePathKey);
            String subPatchPkgPath = context.getOrDefault(packagePathKey, "").toString();
            DevicePatchUtil.cleanSubPatchPkgDir(subPatchPkgPath);
        }
    }

    public static boolean checkConsistentVersions(String productVersion, String curVersion, String targetPatchVer) {
        if (!DevicePatchUtil.isVRCVersionMatched(productVersion, targetPatchVer)) {
            return false;
        }
        if ("--".equals(curVersion)) {
            return false;
        }
        return DevicePatchUtil.getSPHVersion(curVersion).equals(DevicePatchUtil.getSPHVersion(targetPatchVer));
    }

    public static String getSPHVersion(String version) {
        Matcher matcher = SPH_VERSION_PATTERN.matcher(version);
        if (matcher.find()) {
            return matcher.group();
        }
        return "--";
    }

    public static boolean isIgnoreSpcSphMatch() {
        return IGNORE.equals(ResourceUtil.getString((String)"patch.card.strategy.check.spc.sph.match.ignore"));
    }

    @NotNull
    public static List<DevNode> getAllAddDevNodes() {
        if (SceneUtils.isA800SceneInTool() && PatchSceneUtil.isA800PatchEval()) {
            return DevicePatchUtil.getZoneNodes();
        }
        if (SceneUtils.isA800SceneInTool() && PatchSceneUtil.isA800HotPatch()) {
            return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).map(AiDevNode::getA800Nodes).flatMap(Collection::stream).filter(DmeNode::isSelect).collect(Collectors.toList());
        }
        return DevicePatchUtil.getAllDevNodes();
    }

    @NotNull
    private static List<DevNode> getZoneNodes() {
        return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).map(AiDevNode::getA800Nodes).flatMap(Collection::stream).filter(DmeNode::isSelect).map(A800Node::getZones).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @NotNull
    private static List<DevNode> getAllDevNodes() {
        List boxDevNodes = DefaultNodeProviderImpl.getInstance().getNodeList();
        ArrayList<DevNode> devNodeList = new ArrayList<DevNode>();
        boxDevNodes.forEach(devNode -> {
            if (EntityUtils.isComputeStorageDevLoginThroughFcv(devNode)) {
                devNodeList.addAll(EntityUtils.convertComputeStorageToOldDevNode(devNode));
            } else {
                devNodeList.add((DevNode)devNode);
            }
        });
        return devNodeList;
    }

    public static DevNode transToRequestNode(DevNode showNode) {
        if (showNode instanceof A800Node) {
            return ((A800Node)showNode).getZones().stream().min(Comparator.comparing(DevNode::getUuid)).orElse(((A800Node)showNode).getZones().get(0));
        }
        return showNode;
    }

    public static DevNode transToShowNode(DevNode requestZone) {
        Optional<A800Node> matchA800 = DevicePatchUtil.getAllAddDevNodes().stream().filter(node -> node instanceof A800Node).map(A800Node.class::cast).filter(a800Node -> DevicePatchUtil.isZoneMatch(requestZone, a800Node)).findFirst();
        if (matchA800.isPresent()) {
            return matchA800.get();
        }
        return requestZone;
    }

    private static boolean isZoneMatch(DevNode requestZone, A800Node a800Node) {
        return a800Node.getZones().stream().anyMatch(zoneNode -> Objects.equals(zoneNode.getDeviceSerialNumber(), requestZone.getDeviceSerialNumber()));
    }
}

