/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.utils;

import com.google.common.base.Objects;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.DeviceOptionUtil;
import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.service.PatchService;
import com.huawei.ism.tool.devicepatch.ui.main.DevicePatchMainDialog;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class PatchSceneUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PatchSceneUtil.class);
    private static final String TOOL_ID = "patch";
    private static final String SCENE_TOOL_ID = "toolId";
    private static final String SCENE_SN = "SN";
    private static final String SCENE_IP = "IP";
    private static final String SCENE_DEV_STATUS = "status";
    private static final String EMPTY_VALUE = "";
    private static final List<String> NEED_SAVE_SCENE = Arrays.asList("HotPatch", "PatchEvalu", "Upgrade");
    private static final String CURRENT_SCENE = PatchDataContext.getInstance().getCurrentSubScene();

    public static boolean isScene() {
        if (NEED_SAVE_SCENE.contains(CURRENT_SCENE)) {
            return false;
        }
        return SceneUtils.isScene();
    }

    public static boolean isA800PatchEval() {
        return Objects.equal((Object)CURRENT_SCENE, (Object)"IntelligentCompute_A800_patch_eval");
    }

    public static boolean isA800HotPatch() {
        return Objects.equal((Object)CURRENT_SCENE, (Object)"IntelligentCompute_A800_hot_patch");
    }

    public static boolean isStoragePatchEvalu() {
        return "PatchEvalu".equalsIgnoreCase(PatchDataContext.getInstance().getCurrentSubScene());
    }

    public static boolean isPatchEvalu() {
        return PatchSceneUtil.isA800PatchEval() || PatchSceneUtil.isStoragePatchEvalu();
    }

    public static boolean needSaveSceneTaskData() {
        return PatchSceneUtil.isScene() || NEED_SAVE_SCENE.contains(CURRENT_SCENE);
    }

    public static boolean sceneSelectDevNode(DevNode devNode) {
        LOGGER.info("Scenc Device Pach: call sceneSelectDevNode begin");
        String jsonQuery = PatchSceneUtil.getDevNodeJsonQuery(devNode);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Scenc Device Pach: call sceneSelectDevNode :" + jsonQuery);
        }
        String result = null;
        try {
            result = SceneEnvironmentImpl.getInstance().getDataVarByKey(jsonQuery);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Scenc Device Pach: call sceneSelectDevNode :" + result);
            }
        }
        catch (Exception e) {
            LOGGER.error("Scenc Device Pach: can't get device node map", (Throwable)e);
            return true;
        }
        return !result.equals(TaskResult.Result.SUCCESS.toString());
    }

    private static String getDevNodeJsonQuery(DevNode devNode) {
        HashMap<String, String> jsonQueryMap = new HashMap<String, String>();
        jsonQueryMap.put(SCENE_TOOL_ID, TOOL_ID);
        jsonQueryMap.put(SCENE_SN, devNode.getDeviceSerialNumber());
        JSONObject jsonObject = new JSONObject(jsonQueryMap);
        return jsonObject.toString();
    }

    public static void finishedSceneTask() {
        LOGGER.info("Scenc Device Pach: call finishedSceneTask begin");
        TaskResult result = null;
        try {
            List<Map<String, String>> callBackMap = PatchSceneUtil.createSceneDataMap();
            if (callBackMap.isEmpty()) {
                callBackMap.add(PatchSceneUtil.createEmptyDeviceMap());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Scenc Device Pach: call finishedSceneTask " + callBackMap);
            }
            ISceneEnvironment environmentImpl = SceneEnvironmentImpl.getInstance();
            result = environmentImpl.finishedSceneTask(callBackMap);
            LOGGER.info("Scenc Device Pach: call finishedSceneTask result");
        }
        catch (Exception e) {
            LOGGER.error("Scenc Device Pach: scene call back failed", (Throwable)e);
        }
        if (result != null && !result.getResult().equals((Object)TaskResult.Result.SUCCESS) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Scenc Device Pach: scene call back faild! " + result.toString());
        }
    }

    private static List<Map<String, String>> createSceneDataMap() {
        ArrayList<Map<String, String>> callBackMap = new ArrayList<Map<String, String>>();
        DevicePatchMainDialog mainDialog = PatchDataContext.getInstance().getMainDialog();
        List rows = mainDialog.getDevPatchs().getAllRows();
        if (SceneUtils.isA800SceneInTool() && PatchSceneUtil.isA800PatchEval()) {
            callBackMap.add(PatchSceneUtil.createDeviceMapInA800(rows));
            return callBackMap;
        }
        for (TableRow row : rows) {
            DevNode devNode = (DevNode)row.getUserObject();
            DevPatch.DevPatchStatus status = PatchService.getInstance().getStatus(devNode);
            HashMap<String, String> map = new HashMap<String, String>();
            if (DevPatch.DevPatchStatus.COMPLETED.equals((Object)status)) {
                map.put(SCENE_DEV_STATUS, TaskResult.Result.SUCCESS.toString());
            } else {
                if (!DevPatch.DevPatchStatus.FAILED.equals((Object)status)) continue;
                map.put(SCENE_DEV_STATUS, TaskResult.Result.FAILED.toString());
            }
            map.put(SCENE_TOOL_ID, TOOL_ID);
            map.put(SCENE_SN, devNode.getDeviceSerialNumber());
            map.put(SCENE_IP, devNode.getIp());
            callBackMap.add(map);
        }
        return callBackMap;
    }

    private static Map<String, String> createDeviceMapInA800(List<TableRow> rows) {
        HashMap<String, String> map = new HashMap<String, String>();
        List status = rows.stream().map(row -> PatchService.getInstance().getStatus((DevNode)row.getUserObject())).filter(devPatchStatus -> !DevPatch.DevPatchStatus.NOTEVALU.equals(devPatchStatus)).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(status)) {
            return map;
        }
        if (status.stream().allMatch(DevPatch.DevPatchStatus.COMPLETED::equals)) {
            map.put(SCENE_DEV_STATUS, TaskResult.Result.SUCCESS.toString());
        } else {
            map.put(SCENE_DEV_STATUS, TaskResult.Result.FAILED.toString());
        }
        DevNode devNode = (DevNode)rows.get(0).getUserObject();
        Optional a800Node = DeviceOptionUtil.findA800Node((com.huawei.ism.tool.framework.pubservice.entity.DevNode)EntityUtils.toNewDev(devNode));
        map.put(SCENE_TOOL_ID, TOOL_ID);
        map.put(SCENE_SN, ((A800Node)a800Node.get()).getDeviceSerialNumber());
        map.put(SCENE_IP, ((A800Node)a800Node.get()).getIp());
        return map;
    }

    private static Map<String, String> createEmptyDeviceMap() {
        HashMap<String, String> sceneDeviceMap = new HashMap<String, String>();
        sceneDeviceMap.put(SCENE_TOOL_ID, TOOL_ID);
        sceneDeviceMap.put(SCENE_SN, EMPTY_VALUE);
        sceneDeviceMap.put(SCENE_IP, EMPTY_VALUE);
        sceneDeviceMap.put(SCENE_DEV_STATUS, EMPTY_VALUE);
        return sceneDeviceMap;
    }
}

