/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicepatch.utils;

import com.huawei.ism.tool.devicepatch.PatchDataContext;
import com.huawei.ism.tool.devicepatch.entity.DevPatch;
import com.huawei.ism.tool.devicepatch.entity.PatchInfo;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneDataSerialize;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.framework.pubservice.scenedata.UpgradeSceneData;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class SceneDataParser {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneDataParser.class);

    public static void init() {
        List newNodes = SceneXmlData.getInstance().loadSceneFromFile();
        if (null == newNodes || newNodes.isEmpty()) {
            LOGGER.info("no device data.");
            return;
        }
        List<DevNode> devsXML = EntityUtils.toOldDevList(newNodes);
        SceneDataSerialize dataOperate = new SceneDataSerialize();
        Map upgradeSettings = (Map)dataOperate.deserialize();
        if (null == devsXML || devsXML.isEmpty() || null == upgradeSettings) {
            LOGGER.info("no upgrade setting data.");
            return;
        }
        for (DevNode devNode : devsXML) {
            String key = devNode.getIp() + "_" + devNode.getDeviceSerialNumber();
            UpgradeSceneData data = (UpgradeSceneData)upgradeSettings.get(key);
            if (null == data) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("no match upgrade setting data, key=" + key);
                continue;
            }
            if (!data.isNeedInstallPatch()) continue;
            DevPatch devPatch = SceneDataParser.toDevPatch(devNode, data);
            PatchDataContext.getInstance().setDevPatchs(devPatch);
        }
    }

    private static DevPatch toDevPatch(DevNode devNode, UpgradeSceneData data) {
        PatchInfo patchInfo = null;
        patchInfo = new PatchInfo("--");
        patchInfo.setCurrentVer("--");
        patchInfo.setPatchPath("");
        patchInfo.setDescription(data.getAdvisePatchVersion());
        DevPatch devPatch = new DevPatch();
        devPatch.setBatchInfo(patchInfo);
        ArrayList<DevNode> devNodes = new ArrayList<DevNode>();
        devNodes.add(devNode);
        devPatch.setDevNode(devNodes);
        return devPatch;
    }
}

