/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common;

import com.huawei.ism.FrameworkCommon;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.entity.State;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.message.IsmMsgManager;
import com.huawei.ism.ui.forms.lockui.LockUIThread;
import com.huawei.ism.ui.forms.lockui.RefreshUIThread;
import com.huawei.ism.ui.forms.mainframe.MainPane;
import com.huawei.ism.ui.forms.mainframe.MainPaneTree;
import com.huawei.ism.ui.swing.plaf.IsmLookAndFeel;
import com.huawei.ism.ui.swing.plaf.armor.ArmorLookAndFeel;
import com.huawei.ism.ui.swing.plaf.unify.UnifyLookAndFeel;
import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import com.huawei.ism.util.CommonUtil;
import java.awt.Container;
import java.awt.Frame;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Framework {
    private static final Logger LOGGER = LoggerFactory.getLogger(Framework.class);
    public static final String ISM_DEMO = "USE_DEMO";
    public static final String DEBUG = "DEBUG";
    public static final String APPLET = "APPLET";
    public static final String PROXY = "PROXY";
    public static final String JWS = "JWS";
    public static final String APPLICATION = "APP";
    public static final String AS_JAR = "AS_JAR";
    public static final String MAIN_ARG_IP = "-ip";
    public static final String NAS_IP = "-nasip";
    public static final String NAS_USER = "-nasuser";
    public static final String NAS_PWD = "-naspwd";
    public static final String SOCKET_SSL = "-useSSL";
    public static final String DEVICE_TYPE = "-devicetype";
    public static final String PROTOCAL_TYPE = "-protocaltype";
    public static final String AUTHMODE = "-authMode";
    public static final String MAIN_ARG_PASSWORD = "-password";
    public static final String MAIN_ARG_ACCOUNT = "-account";
    public static final String MAIN_ARG_LANGUAGE = "-language";
    public static final String ISM_VERSION = "ism_version";
    public static final String ISM_TR4A_SIGN = "-isTR4";
    public static final String PACKAGEE_PATH = "-path";
    public static final String MAIN_ARG_USE_SPECIAL_KEY = "-specialKey";
    public static final String MAIN_ARG_TMPPASSWORD = "-tmpPassword";
    public static final String MAIN_ARG_DEVICE_TYPE = "-deviceType";
    public static final String MAIN_ARG_SINGLE_INSTANCE_MODE = "-singleInstanceMode";
    public static final String MAIN_ARG_SINGLE_INSTANCE_PORT = "-singleInstancePort";
    public static final String LAF_STYLE = "-LAFStyle";
    public static final String ISM_ARGS = "ISM_ARGS";
    private static Framework singleton = null;
    private LockUIThread lockUIProcessor = null;
    private RefreshUIThread refreshUIThread = null;
    private Frame mainFrame = null;
    private MainPane mainPane;
    private final Object mainPaneLock = new Object();

    private Framework() {
    }

    public void init(String ismArg) throws UnsupportedLookAndFeelException {
        IsmMsgManager.getInstance();
        ResourceManager.init();
        CommonUtil.closeLogs();
        State.init();
    }

    public void loadLAF() {
        String lafStyle = FrameworkCommon.getInstance().getStrProperty(LAF_STYLE);
        try {
            if (null == lafStyle || lafStyle.trim().length() < 0 || lafStyle.equalsIgnoreCase("unify")) {
                UIManager.setLookAndFeel(new UnifyLookAndFeel());
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            } else if (lafStyle.equalsIgnoreCase("armor")) {
                UIManager.setLookAndFeel(new ArmorLookAndFeel());
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            } else {
                UIManager.setLookAndFeel(new IsmLookAndFeel());
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public IsmTreeNode getSelectionNode() {
        MainPane mainPaneTemp = this.getMainPane();
        if (null != mainPaneTemp) {
            MainPaneTree selectionTree = this.getMainPane().getLeftTree();
            IsmTreeNode selectionNode = selectionTree.getSelectionNode();
            return selectionNode;
        }
        return null;
    }

    public static synchronized Framework getInstance() {
        if (singleton == null) {
            singleton = new Framework();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MainPane getMainPane() {
        Object object = this.mainPaneLock;
        synchronized (object) {
            return this.mainPane;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MainPane createMainPane() {
        Object object = this.mainPaneLock;
        synchronized (object) {
            if (null == this.mainPane) {
                this.mainPane = new MainPane();
            }
            return this.mainPane;
        }
    }

    public Frame getMainFrame() {
        if (this.mainFrame == null) {
            MainPane pane = this.getMainPane();
            for (Container c = pane.getParent(); c != null; c = c.getParent()) {
                if (!(c instanceof Frame)) continue;
                this.mainFrame = (Frame)c;
                break;
            }
        }
        if (this.mainFrame == null) {
            this.mainFrame = new JFrame();
        }
        return this.mainFrame;
    }

    public void setMainFrame(Frame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public LockUIThread getLockUIThread() {
        return this.lockUIProcessor;
    }

    public void setLockUIProcessor(LockUIThread lockUIProcessor) {
        this.lockUIProcessor = lockUIProcessor;
    }

    public RefreshUIThread getRefreshUIThread() {
        return this.refreshUIThread;
    }

    public void setRefreshUIThread(RefreshUIThread refreshUIThread) {
        this.refreshUIThread = refreshUIThread;
    }

    public static HashMap<String, TimeZone> getTimeZones() {
        List<Launcher> launchers = LauncherManager.getInstance().getAllLauncher();
        HashMap<String, TimeZone> timeZones = new HashMap<String, TimeZone>(0);
        Collection<Launcher> sublaunchers = null;
        for (Launcher launcher : launchers) {
            timeZones.put(launcher.getDeviceID(), launcher.getDeviceTimeZone());
            sublaunchers = launcher.getSubLaunchers();
            if (null == sublaunchers) continue;
            for (Launcher sublauncher : sublaunchers) {
                timeZones.put(sublauncher.getDeviceID(), sublauncher.getDeviceTimeZone());
            }
        }
        return timeZones;
    }

    public static TimeZone getDeviceTimeZone(String deviceID) {
        HashMap<String, TimeZone> deviceTimeZone = Framework.getTimeZones();
        TimeZone zone = deviceTimeZone.get(deviceID);
        return zone;
    }

    public static DeviceType getCurrentDeviceType(boolean isRoot) {
        IsmTreeNode selTreeNode = Framework.getInstance().getSelectionNode();
        if (null == selTreeNode) {
            return null;
        }
        String deviceID = selTreeNode.getDeviceID();
        if (null == deviceID) {
            return null;
        }
        Launcher launcher = null;
        launcher = !isRoot ? LauncherManager.getInstance().getLauncher(deviceID) : LauncherManager.getInstance().findDeviceOwner(deviceID);
        if (null != launcher) {
            return launcher.getDeviceContext().getDeviceType();
        }
        return null;
    }

    public String getRunMode() {
        return FrameworkCommon.getInstance().getRunMode();
    }

    public synchronized String getStrProperty(String key) {
        return FrameworkCommon.getInstance().getStrProperty(key);
    }

    public synchronized String getStrProperty(String key, String defaultStr) {
        return FrameworkCommon.getInstance().getStrProperty(key, defaultStr);
    }

    public String getIsmVersion() {
        return FrameworkCommon.getInstance().getIsmVersion();
    }

    public Locale getAvailableLocale() {
        String strLocale = this.getStrProperty(MAIN_ARG_LANGUAGE);
        return CommonUtil.getAvailableLocale(strLocale);
    }

    public boolean isDemoMode() {
        return Boolean.valueOf(this.getStrProperty(ISM_DEMO));
    }

    public LockUIThread getLockUIProcessor() {
        return this.lockUIProcessor;
    }
}

