/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.IPackageActivator;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.message.IMsgHandler;
import com.huawei.ism.message.IsmMsg;
import com.huawei.ism.message.IsmMsgManager;
import com.huawei.ism.ui.module.task.BackgroundTask;
import com.huawei.ism.ui.module.task.TaskManager;
import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Debug;
import com.huawei.ism.util.ServicesUitl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LauncherManager
implements IMsgHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LauncherManager.class);
    public static final int MAX_DEVICE_AMOUNT = 32;
    private static LauncherManager manager = new LauncherManager();
    private Map<String, IPackageActivator> packageActivatorMap = new HashMap<String, IPackageActivator>(0);
    private final Map<String, Launcher> mapOfDeviceInfo = new Hashtable<String, Launcher>(0);
    private String currentDeviceID = null;

    protected LauncherManager() {
        Iterator ps = ServicesUitl.servicesproviders(IPackageActivator.class);
        IPackageActivator packageActivator = null;
        String[] supportedDeviceTypes = null;
        while (ps.hasNext()) {
            packageActivator = (IPackageActivator)ps.next();
            packageActivator.doInitTask();
            for (String type : supportedDeviceTypes = packageActivator.getSupportedDeviceTypes()) {
                this.packageActivatorMap.put(type, packageActivator);
            }
        }
        this.registerNewDeviceMsgHandler();
    }

    public Launcher createDeviceLauncher(DeviceContext context) throws IsmException {
        DeviceType realType;
        boolean debug = Boolean.valueOf(Framework.getInstance().getStrProperty("DEBUG_ISM"));
        IPackageActivator activator = null;
        DeviceType type = null;
        if (debug) {
            type = this.loadDeviceType(context, Debug.getActivators());
            activator = Debug.getPackageAcivator(type.name());
        } else {
            type = this.loadDeviceType(context, this.packageActivatorMap.values());
            activator = this.packageActivatorMap.get(type.name());
        }
        if (activator.try2getDeviceType(context) && null != (realType = context.getDeviceType()) && !realType.equals((Object)type)) {
            String errMsg = ResourceManager.getString("LOAD_DEVICE_TYPE_FAILED");
            throw new IsmException(errMsg);
        }
        return activator.createLauncher(type.name());
    }

    private DeviceType loadDeviceType(DeviceContext context, Collection<IPackageActivator> activators) throws IsmException {
        DeviceType type = context.getDeviceType();
        DeviceType selectType = context.getDeviceType();
        if (type == null || type == DeviceType.OCEAN_STOR) {
            int errorTimes = 0;
            ArrayList<IsmException> catchedTimeout = new ArrayList<IsmException>(0);
            boolean ok = false;
            String errMsg = null;
            for (IPackageActivator activator : activators) {
                block6: {
                    try {
                        ok = activator.try2getDeviceType(context);
                    }
                    catch (IsmException e) {
                        ++errorTimes;
                        if (1073949185L == e.getErrorId()) {
                            catchedTimeout.add(e);
                        }
                        if (0x1007001L != e.getErrorId()) break block6;
                        LOGGER.error("ConnectFailed :" + e);
                        errMsg = ResourceManager.getString("LOAD_DEVICE_FAILED_OUTOF_MAX_CONECTION");
                        throw new IsmException(errMsg, (Throwable)e);
                    }
                }
                if (!ok) continue;
                break;
            }
            if (!ok && 0 != errorTimes && errorTimes == catchedTimeout.size()) {
                LOGGER.error("loadDeviceType error: activators:" + activators.toString() + " \nactivatorsSize:" + activators.size() + " errorTimes:" + errorTimes + " catchedTimeout:" + catchedTimeout.size());
                throw new IsmException(1073949185L);
            }
        }
        type = context.getDeviceType();
        this.getDeviceTypeForDegrading(type, selectType);
        return type;
    }

    private void getDeviceTypeForDegrading(DeviceType type, DeviceType selectType) throws IsmException {
        if (type == null || type == DeviceType.OCEAN_STOR) {
            String errMsg = ResourceManager.getString("LOAD_DEVICE_TYPE_FAILED");
            throw new IsmException(errMsg);
        }
        if (DeviceType.N8000.equals((Object)type) && !DeviceType.N8000.equals((Object)selectType)) {
            String errMsg = ResourceManager.getString("LOAD_DEVICE_TYPE_FAILED");
            throw new IsmException(errMsg);
        }
    }

    private void deleteDevice(IsmMsg ismMsg) {
        Object property = ismMsg.getProperty("DEVICE_ID");
        String[] deviceIDs = (String[])property;
        Launcher launcher = null;
        for (String deviceID : deviceIDs) {
            launcher = this.getLauncher(deviceID);
            try {
                launcher.stop();
                Framework.getInstance().getMainPane().getLeftTree().deleteDeviceTreeNode(deviceID);
                this.deleteLauncher(launcher);
            }
            catch (Throwable e) {
                ismMsg.setProperty("PROPERTY_EXCEPTION", e);
            }
        }
    }

    public void deleteDeives() {
        List<Launcher> launchersList = this.getAllLauncher();
        for (Launcher launcher : launchersList) {
            try {
                launcher.stop();
            }
            catch (Throwable e) {
                LOGGER.error("", e);
            }
            this.deleteLauncher(launcher);
        }
    }

    public void stopAllLauncher() {
        List<Launcher> launchers = this.getAllLauncher();
        for (Launcher launcherInterface : launchers) {
            try {
                launcherInterface.stop();
            }
            catch (Throwable e) {
                LOGGER.error("stop launcher error:" + launcherInterface, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoveryDevice(IsmMsg ismMsg) {
        Object o1 = ismMsg.getProperty("PROPERTY_DEVICE_INFO");
        Object o2 = ismMsg.getProperty("PROPERTY_DISCOVERY_BG_TASK");
        if (!(o1 instanceof DeviceContext)) {
            return;
        }
        if (!(o2 instanceof BackgroundTask)) {
            return;
        }
        DeviceContext context = (DeviceContext)o1;
        BackgroundTask task = (BackgroundTask)o2;
        Launcher launcher = this.getLaunher(context, task);
        if (null == launcher) {
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("get Device OK:" + launcher);
        }
        launcher.start(context, task);
        if (!launcher.authenticate()) {
            return;
        }
        String deviceID = launcher.getDeviceID();
        if (BackgroundTask.State.FAILED.equals((Object)task.getState())) {
            return;
        }
        if (null == deviceID) {
            task.setState(BackgroundTask.State.FAILED);
            task.setResult(ResourceManager.getString("LOAD_DEVICE_ID_FAILED"));
            TaskManager.getInstance().updateTask(task);
            return;
        }
        Map<String, Launcher> map = this.mapOfDeviceInfo;
        synchronized (map) {
            Launcher owner = this.findDeviceOwner(deviceID);
            if (null != owner) {
                this.deviceTaskDiscovered(task, deviceID, owner.getDeviceContext().getDeviceName());
                return;
            }
            this.mapOfDeviceInfo.put(deviceID, launcher);
        }
        launcher.retrieveDevice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discovery(DeviceContext context, BackgroundTask task) {
        Assert.notNull(context);
        Launcher launcher = this.getLaunher(context, task);
        if (null == launcher) {
            throw new NullPointerException();
        }
        launcher.start(context, task);
        launcher.authenticate();
        launcher.retrievePowerOnStatue();
        String deviceID = launcher.getDeviceID();
        if (null == deviceID) {
            throw new IsmException(ResourceManager.getString("LOAD_DEVICE_ID_FAILED"));
        }
        Map<String, Launcher> map = this.mapOfDeviceInfo;
        synchronized (map) {
            Launcher owner = this.findDeviceOwner(deviceID);
            if (null != owner) {
                throw new IsmException(ResourceManager.getString("DEVICE_HAS_DISCOVERED"));
            }
            this.mapOfDeviceInfo.put(deviceID, launcher);
        }
        launcher.retrieveDevice();
    }

    public Launcher getLaunher(DeviceContext context, BackgroundTask task) {
        Launcher launcher = null;
        try {
            launcher = this.createDeviceLauncher(context);
        }
        catch (IsmException e) {
            LOGGER.error("", (Throwable)e);
            task.setState(BackgroundTask.State.FAILED);
            IsmException ismException = e;
            if (0x1007001L == ismException.getErrorId()) {
                task.setResult(ResourceManager.getString("LOAD_DEVICE_FAILED_OUTOF_MAX_CONECTION"));
            } else {
                task.setResult(CommonUtil.change2ErrMsg(e));
            }
            TaskManager.getInstance().updateTask(task);
        }
        catch (Throwable e) {
            LOGGER.error("", e);
            task.setState(BackgroundTask.State.FAILED);
            task.setResult(CommonUtil.change2ErrMsg(e));
            TaskManager.getInstance().updateTask(task);
        }
        return launcher;
    }

    public void deviceTaskDiscovered(BackgroundTask task, String deviceID, String deviceName) {
        task.setDeviceID(deviceID);
        task.setDeviceName(deviceName);
        task.setState(BackgroundTask.State.FAILED);
        task.setResult(ResourceManager.getString("DEVICE_HAS_DISCOVERED"));
        TaskManager.getInstance().updateTask(task);
    }

    @Override
    public void handleMsg(IsmMsg ismMsg) {
        if (ismMsg.getMsgType().equalsIgnoreCase("MSG_NEW_DEVICE_DISCOVERED")) {
            this.discoveryDevice(ismMsg);
        } else if (ismMsg.getMsgType().equalsIgnoreCase("MSG_DELETE_DEVICE")) {
            this.deleteDevice(ismMsg);
        }
    }

    private void registerNewDeviceMsgHandler() {
        IsmMsgManager managerTemp = IsmMsgManager.getInstance();
        managerTemp.registerIsmMsgHandle("MSG_NEW_DEVICE_DISCOVERED", this);
        managerTemp.registerIsmMsgHandle("MSG_DELETE_DEVICE", this);
    }

    public int getDeviceSize() {
        return this.getAllLauncher().size();
    }

    public void clearMapOfDeviceInfo() {
        this.mapOfDeviceInfo.clear();
    }

    public static LauncherManager getInstance() {
        return manager;
    }

    private void deleteLauncher(Launcher launcher) {
        this.mapOfDeviceInfo.remove(launcher.getDeviceID());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("deleteLauncher,deleteInfo:" + launcher.getDeviceContext());
        }
    }

    public List<Launcher> getAllLauncher() {
        ArrayList<Launcher> launcherList = new ArrayList<Launcher>(0);
        launcherList.addAll(this.mapOfDeviceInfo.values());
        return launcherList;
    }

    public int getAllLauncherSize() {
        return this.getAllLauncher().size();
    }

    public List<DeviceContext> getDeviceContexts() {
        ArrayList<DeviceContext> contexts = new ArrayList<DeviceContext>(0);
        for (Launcher launcher : this.mapOfDeviceInfo.values()) {
            contexts.add(launcher.getDeviceContext());
        }
        return contexts;
    }

    public DeviceContext getDeviceContext(String deviceID) {
        Launcher launcher = this.getLauncher(deviceID);
        if (null == launcher) {
            return null;
        }
        return launcher.getDeviceContext();
    }

    public Launcher getLauncher(String deviceID) {
        Launcher launcher = this.mapOfDeviceInfo.get(deviceID);
        if (null != launcher) {
            return launcher;
        }
        Launcher parentLauncher = this.findDeviceOwner(deviceID);
        if (null != parentLauncher) {
            Collection<Launcher> subLaunchers = parentLauncher.getSubLaunchers();
            for (Launcher subLauncher : subLaunchers) {
                if (!subLauncher.getDeviceID().equals(deviceID)) continue;
                launcher = subLauncher;
                break;
            }
        }
        return launcher;
    }

    public Launcher findDeviceOwner(String deviceID) {
        for (Launcher launcher : this.mapOfDeviceInfo.values()) {
            if (!launcher.containsPart(deviceID)) continue;
            return launcher;
        }
        return null;
    }

    public List<Launcher> getAllActiveLauncher() {
        ArrayList<Launcher> launcherList = new ArrayList<Launcher>(0);
        Launcher.State state = null;
        for (Launcher launcher : this.mapOfDeviceInfo.values()) {
            if (null == launcher || !Launcher.State.RUNNING.equals((Object)(state = launcher.getState()))) continue;
            launcherList.add(launcher);
        }
        return launcherList;
    }

    public Launcher getActivedLauncher() {
        IsmTreeNode treeNode = Framework.getInstance().getSelectionNode();
        if (null != treeNode) {
            return this.getLauncher(treeNode.getDeviceID());
        }
        Launcher activeLauncher = null;
        if (null != this.getCurrentDeviceID()) {
            activeLauncher = this.getLauncher(this.getCurrentDeviceID());
            return activeLauncher;
        }
        for (Launcher launcher : this.mapOfDeviceInfo.values()) {
            if (null == launcher) continue;
            activeLauncher = launcher;
            break;
        }
        return activeLauncher;
    }

    public void stopDiscoveryFailDevice(String deviceID) {
        try {
            Launcher launcher;
            if (null == Framework.getInstance().getMainPane().getLeftTree().findRootDeviceNode(deviceID) && null != (launcher = this.getLauncher(deviceID))) {
                launcher.stop();
                this.deleteLauncher(launcher);
            }
        }
        catch (Throwable e) {
            LOGGER.error("stopDiscoveryFailDevice  " + e);
        }
    }

    public List<DeviceContext> getAllDeviceContexts() {
        ArrayList<DeviceContext> contexts = new ArrayList<DeviceContext>(0);
        for (Launcher launcher : this.mapOfDeviceInfo.values()) {
            Collection<Launcher> allSubLaucherList = launcher.getSubLaunchers();
            for (Launcher subLaucher : allSubLaucherList) {
                DeviceContext deviceContext = subLaucher.getDevContext();
                contexts.add(deviceContext);
            }
            contexts.add(launcher.getDeviceContext());
        }
        return contexts;
    }

    public String getCurrentDeviceID() {
        return this.currentDeviceID;
    }

    public void setCurrentDeviceID(String currentDeviceID) {
        this.currentDeviceID = currentDeviceID;
    }
}

