/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.resourcemanager;

import com.huawei.ism.FrameworkCommon;
import com.huawei.ism.common.resourcemanager.LocalResourceManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.FileUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CustomResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomResourceManager.class);
    public static final String FILE_PATH = "config/framework/configuration/custom.properties";
    private static CustomResourceManager instance = null;
    private Properties mappings = new Properties();
    private InputStream inStream = null;
    private OutputStream outStream = null;

    private CustomResourceManager() {
        try {
            if (!FrameworkCommon.getInstance().getRunMode().equals("APPLET")) {
                File tmpFile = null;
                String location = LocalResourceManager.getInstance().getUserDataDir() + File.separator + FILE_PATH;
                tmpFile = new File(location);
                if (tmpFile.exists()) {
                    this.inStream = new FileInputStream(tmpFile);
                }
            }
            if (this.inStream == null) {
                this.inStream = FileUtils.getStreamWithObj(this.getClass(), FILE_PATH);
            }
            this.mappings = new Properties();
            this.mappings.load(this.inStream);
        }
        catch (RuntimeException e) {
            LOGGER.error("CustomResourceManager: losad property file fail,file=config/framework/configuration/custom.properties", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("CustomResourceManager: load property file fail,file=config/framework/configuration/custom.properties", (Throwable)e);
        }
        finally {
            try {
                if (this.inStream != null) {
                    this.inStream.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    public static synchronized CustomResourceManager getInstance() {
        if (instance == null) {
            instance = new CustomResourceManager();
        }
        return instance;
    }

    public String getString(String key) {
        String ret = null;
        ret = this.mappings.getProperty(key);
        return ret;
    }

    public String getString(String key, String defaultValue) {
        String ret = null;
        ret = this.mappings.getProperty(key);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public boolean getBoolProperty(String key, boolean defaultValue) {
        String ret = this.mappings.getProperty(key);
        if (ret == null) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(ret);
        }
        catch (Exception e) {
            LOGGER.error("getBoolProperty error", (Throwable)e);
            return defaultValue;
        }
    }

    public int getIntProperty(String mapKey, int defaultValue) {
        int value;
        String ret = this.mappings.getProperty(mapKey);
        try {
            value = Integer.valueOf(ret);
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("CustomResourceManager: get properties value fail, key = " + mapKey + ' ' + e);
            }
            return defaultValue;
        }
        return value;
    }

    public String getPassword() {
        String ret = this.mappings.getProperty("custom.LockPwd");
        return ret;
    }

    public void setPassword(String password) {
        String ret = AESEncrypt.encrypt(password);
        this.setString("custom.LockPwd", ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String mapKey, String value) {
        if (FrameworkCommon.getInstance().getRunMode().equals("APPLET")) {
            return;
        }
        try {
            File file = new File(this.getFilePath());
            this.outStream = new FileOutputStream(file);
            this.mappings.setProperty(mapKey, value);
            this.mappings.store(this.outStream, null);
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException: set properties value fail, key = " + mapKey, (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("CustomResourceManager: set properties value fail, key = " + mapKey, (Throwable)e);
        }
        finally {
            try {
                if (this.outStream != null) {
                    this.outStream.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    public void setBoolProperty(String key, boolean value) {
        this.setString(key, String.valueOf(value));
    }

    public void setIntProperty(String key, int value) {
        this.setString(key, String.valueOf(value));
    }

    public List<Locale> getLanguages() {
        ArrayList<Locale> languages = new ArrayList<Locale>(0);
        String languagesStr = this.getString("custom.language");
        if (null == languagesStr || "".equals(languagesStr)) {
            this.reloadDefaultConfig();
            languagesStr = this.getString("custom.language");
        }
        String[] strArray = languagesStr.split(";");
        String key = "";
        String[] arr = null;
        Locale[] locales = null;
        for (String string : strArray) {
            arr = string.split(",");
            locales = Locale.getAvailableLocales();
            key = arr.length > 1 ? arr[0] + '_' + arr[1] : arr[0];
            this.getTmpLocale(languages, key, locales);
        }
        return languages;
    }

    public void reloadDefaultConfig() {
        this.inStream = FileUtils.getStreamWithObj(this.getClass(), FILE_PATH);
        this.mappings = new Properties();
        try {
            this.mappings.load(this.inStream);
        }
        catch (Exception t) {
            LOGGER.error("CustomResourceManager: reload property file fail,file=config/framework/configuration/custom.properties", (Throwable)t);
        }
        finally {
            try {
                if (this.inStream != null) {
                    this.inStream.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    private void getTmpLocale(List<Locale> languages, String key, Locale[] locales) {
        String str = null;
        for (Locale tmpLocale : locales) {
            str = tmpLocale.toString();
            if (!str.equals(key)) continue;
            if ("en_US".equals(key)) {
                languages.add(Locale.ENGLISH);
                break;
            }
            languages.add(tmpLocale);
            break;
        }
    }

    private String getFilePath() {
        File tmpFile = null;
        String location = LocalResourceManager.getInstance().getUserDataDir() + File.separator + FILE_PATH;
        tmpFile = new File(location);
        File parent = tmpFile.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            LOGGER.info("create new dir fail.");
        }
        if (!tmpFile.exists()) {
            this.createPropertiesFile(tmpFile);
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPropertiesFile(File tmpFile) {
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            if (!tmpFile.createNewFile()) {
                LOGGER.info("create new file fail.");
            } else {
                this.inStream = FileUtils.getStreamWithObj(ResourceManager.class, FILE_PATH);
                this.mappings = new Properties();
                this.mappings.load(this.inStream);
                Enumeration<?> mappingKey = this.mappings.propertyNames();
                fw = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile, true), Charset.defaultCharset());
                bw = new BufferedWriter(fw);
                String infoLine = null;
                while (mappingKey.hasMoreElements()) {
                    infoLine = (String)mappingKey.nextElement();
                    infoLine = infoLine + '=' + this.mappings.getProperty(infoLine);
                    bw.write(infoLine);
                    bw.newLine();
                    bw.flush();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("CustomResourceManager: create new file fail. config/framework/configuration/custom.properties", (Throwable)e);
        }
        finally {
            this.closeStream(this.inStream);
            this.closeStream(fw);
            this.closeStream(bw);
        }
    }

    private void closeStream(Closeable writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

