/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.resourcemanager;

import com.huawei.ism.FrameworkCommon;
import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceManager.class);
    public static final ReadWriteLock RESOURCE_LOCK = new ReentrantReadWriteLock();
    public static final ClassLoader LOADER = ResourceManager.class.getClassLoader();
    public static final ImageIcon DEFAULT_ICON;
    private static Properties iniProperties;
    private static Locale locale;
    private static Map<String, ImageIcon> images;
    private static List<String> registerImagePaths;
    private static List<Locale> languages;
    private static Map<Locale, HashMap<String, String>> txtPool;

    private ResourceManager() {
    }

    public static synchronized void registerPropertyFile(String textFilePath, ClassLoader classLoader) {
        if (Utils.isNullStr(textFilePath)) {
            throw new IllegalArgumentException("Text file path is empty and is illegal. Cannot register.");
        }
        ResourceBundle bundle = null;
        for (Locale localeValue : languages) {
            bundle = null;
            try {
                bundle = ResourceBundle.getBundle(textFilePath, localeValue);
            }
            catch (Exception e) {
                continue;
            }
            HashMap<Object, Object> txtMap = null;
            if (!txtPool.containsKey(localeValue)) {
                txtMap = new HashMap(0);
                txtPool.put(localeValue, txtMap);
            } else {
                txtMap = txtPool.get(localeValue);
            }
            for (String key : bundle.keySet()) {
                if (txtMap.get(key) != null) continue;
                txtMap.put(key, bundle.getString(key));
            }
        }
    }

    public static synchronized void registerImages(String imageFilePath) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("register image file, productType=" + imageFilePath + ", imageFilePath=" + imageFilePath);
        }
        if (Utils.isNullStr(imageFilePath)) {
            throw new IllegalArgumentException("Image file path is empty and is illegal. Cannot register.");
        }
        if (registerImagePaths.contains(imageFilePath)) {
            return;
        }
        registerImagePaths.add(imageFilePath);
    }

    public static String getString(String key, String defaultStr) {
        String value = ResourceManager.getString(key);
        if (Utils.isNullStr(value) || value.equals("--")) {
            return defaultStr;
        }
        return value;
    }

    public static String getString(String key, String defaultStr, Locale localeValue) {
        String value = ResourceManager.getString(key, localeValue);
        if (Utils.isNullStr(value) || value.equals("--")) {
            return defaultStr;
        }
        return value;
    }

    public static String getString(String key) {
        Locale localeValue = ResourceManager.getLocale();
        return ResourceManager.getString(key, localeValue);
    }

    public static String getString(String key, Locale localeValue) {
        HashMap<String, String> hashMap = txtPool.get(localeValue);
        if (null == hashMap) {
            return "--";
        }
        String value = hashMap.get(key);
        if (null == value) {
            value = "--";
        }
        return value;
    }

    public static String getStringWithColon(String key) {
        String uiKey = ResourceManager.getString(key);
        if (!"--".equalsIgnoreCase(uiKey) && !uiKey.endsWith(":")) {
            uiKey = uiKey + ":";
        }
        return uiKey;
    }

    public static String getStringWithColon(String key, Locale localeValue) {
        String uiKey = ResourceManager.getString(key, localeValue);
        if (!"--".equalsIgnoreCase(uiKey) && !uiKey.endsWith(":")) {
            uiKey = uiKey + ":";
        }
        return uiKey;
    }

    public static String getStringByDeviceType(String key, String deviceType) {
        String value = ResourceManager.getString(key + '.' + deviceType);
        if (Utils.isNullStr(value) || value.equals("--")) {
            value = ResourceManager.getString(key);
        }
        return value;
    }

    public static String getStringWithParams(String key, Object ... params) {
        String value = ResourceManager.getString(key);
        if (null == params || params.length == 0) {
            return value;
        }
        return MessageFormat.format(value, params);
    }

    public static String getOEMString(String key) {
        return ResourceManager.getOEMString(key, Locale.getDefault());
    }

    public static String getOEMString(String key, Locale localeValue) {
        String vender = FrameworkCommon.getInstance().getStrProperty("VENDER", "");
        if (vender.length() <= 0) {
            vender = "Huawei";
        }
        return ResourceBundle.getBundle(vender + ".key", localeValue).getString(key);
    }

    public static ImageIcon getOEMImage(String key) {
        String vender = FrameworkCommon.getInstance().getStrProperty("VENDER", "");
        if (vender.length() <= 0) {
            vender = "Huawei";
        }
        return ResourceManager.getImage(key, vender);
    }

    public static synchronized ImageIcon getImage(String string) {
        String imagePath;
        ImageIcon imageIcon = ResourceManager.getImage(string, null);
        if (DEFAULT_ICON != imageIcon) {
            return imageIcon;
        }
        Iterator<String> iterator = registerImagePaths.iterator();
        while (iterator.hasNext() && DEFAULT_ICON == (imageIcon = ResourceManager.getImage(string, imagePath = iterator.next()))) {
        }
        if (DEFAULT_ICON == imageIcon && LOGGER.isInfoEnabled()) {
            LOGGER.info("getImage(): key = [" + string + "];value=null,will return none.png image.");
        }
        return imageIcon;
    }

    private static ImageIcon getImage(String key, String imagePath) {
        if (null == key) {
            return DEFAULT_ICON;
        }
        ImageIcon imageIcon = images.get(key);
        if (null != imageIcon && imageIcon.getIconHeight() != -1 && imageIcon.getIconWidth() != -1) {
            return imageIcon;
        }
        imageIcon = null;
        URL imageURL = null;
        try {
            String imgPath = null == imagePath ? key : imagePath + '/' + key;
            imageURL = LOADER.getResource(imgPath);
            if (imageURL != null) {
                imageIcon = new ImageIcon(imageURL);
            }
        }
        catch (Exception e) {
            LOGGER.error("load image file error,imageURL=" + imageURL, (Throwable)e);
        }
        if (null == imageIcon) {
            return DEFAULT_ICON;
        }
        images.put(key, imageIcon);
        return imageIcon;
    }

    public static synchronized Locale getLocale() {
        if (locale == null) {
            locale = Utils.getOSLocaleDefaultEn();
            return locale;
        }
        return locale;
    }

    public static synchronized void setLocale(Locale localeValue) {
        locale = localeValue;
    }

    public static int getResourceSize() {
        int size = 0;
        Iterator<Map.Entry<Locale, HashMap<String, String>>> iterator = txtPool.entrySet().iterator();
        Map.Entry<Locale, HashMap<String, String>> entry = null;
        HashMap<String, String> map = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            map = entry.getValue();
            size += map.size();
        }
        return size;
    }

    public static synchronized Properties getCfgProperties() {
        if (iniProperties == null) {
            iniProperties = new Properties();
            String path = "config/framework/configuration/configuration.properties";
            InputStream inStream = LOADER.getResourceAsStream(path);
            try {
                iniProperties.load(inStream);
            }
            catch (IOException e) {
                LOGGER.error("Get CfgProperties error.");
            }
            finally {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("close stream failed ." + e);
                }
            }
        }
        return iniProperties;
    }

    public static void init() {
        String commonFile = "config.framework.resource.languages.common";
        String imgFile = "config/framework/resource/images";
        String errInfoFile = "config.resource.languages.errorInfo";
        String femaFile = "config.framework.resource.languages.FMEA";
        String interfaceFile = "config.framework.resource.languages.interface";
        String tipFile = "config.framework.resource.languages.prompt";
        String newImgFile = "config/framework/resource/newImgs";
        try {
            languages = CustomResourceManager.getInstance().getLanguages();
        }
        catch (Exception ex) {
            languages = new ArrayList<Locale>(0);
            LOGGER.error("", (Throwable)ex);
        }
        try {
            ResourceManager.registerPropertyFile(commonFile, LOADER);
            ResourceManager.registerPropertyFile(errInfoFile, LOADER);
            ResourceManager.registerPropertyFile(femaFile, LOADER);
            ResourceManager.registerPropertyFile(interfaceFile, LOADER);
            ResourceManager.registerPropertyFile(tipFile, LOADER);
        }
        catch (Exception ex) {
            LOGGER.error("Register resource:" + commonFile, (Throwable)ex);
        }
        try {
            ResourceManager.registerImages(imgFile);
            ResourceManager.registerImages(newImgFile);
        }
        catch (Exception ex) {
            LOGGER.error("", (Throwable)ex);
        }
    }

    static {
        iniProperties = null;
        locale = null;
        images = new HashMap<String, ImageIcon>(0);
        registerImagePaths = new ArrayList<String>();
        txtPool = new HashMap<Locale, HashMap<String, String>>(0);
        URL path = LOADER == null ? null : LOADER.getResource("config/resource/none.png");
        DEFAULT_ICON = path != null ? new ImageIcon(path) : new ImageIcon("config/resource/none.png");
    }
}

