/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.service;

import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.message.IsmMsg;
import com.huawei.ism.message.IsmMsgManager;
import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.service.MOsCache;
import com.huawei.ism.util.Assert;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class Datacache {
    static final long REFRESH_INTERVAL = (long)CustomResourceManager.getInstance().getIntProperty("DATACACHE_REFFESH_INTERVAL", 15) * 1000L;
    private static Datacache instance = null;
    private Map<String, SoftReference<MOsCache>> nodeCacheMap = Collections.synchronizedMap(new WeakHashMap());
    private Map<String, MO> deviceMOMap = new Hashtable<String, MO>(0);

    public static synchronized Datacache getInstance() {
        if (null == instance) {
            instance = new Datacache();
        }
        return instance;
    }

    protected OperationResult getMO(UUID uuid) {
        MOsCache cache = this.findCache(uuid.getDeviceID());
        if (cache != null) {
            return cache.getMO(uuid);
        }
        return new OperationResult(ResultDescription.NEED_SYNC, Collections.EMPTY_LIST, null);
    }

    protected MO getDeviceMO(String deviceID) {
        return this.deviceMOMap.get(deviceID);
    }

    protected OperationResult getMOs(String deviceID, int moType) {
        MOsCache cache = this.findCache(deviceID);
        if (cache != null) {
            return cache.try2GetMOs(moType);
        }
        return new OperationResult(ResultDescription.NEED_SYNC, Collections.EMPTY_LIST, null);
    }

    protected List<MO> getAllDevices() {
        LinkedList<MO> mos = new LinkedList<MO>();
        for (Map.Entry<String, MO> entry : this.deviceMOMap.entrySet()) {
            mos.add(entry.getValue());
        }
        return mos;
    }

    protected void saveMO(MO mo) {
        Assert.notNull(mo);
        if (mo.getMOTypeValue() == MOType.SYSTEM.getValue()) {
            this.deviceMOMap.put(mo.getDeviceID(), mo);
        } else {
            MOsCache cache = this.findCache(mo);
            if (cache == null) {
                cache = new MOsCache(mo.getDeviceID());
                SoftReference<MOsCache> ref = new SoftReference<MOsCache>(cache);
                this.nodeCacheMap.put(mo.getDeviceID(), ref);
            }
            cache.saveMO(mo);
        }
        this.sendMsg(mo.getDeviceID());
    }

    private void sendMsg(String deviceID) {
        IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_COMPONENT_CHANGE");
        msg.setProperty("DEVICE_ID", deviceID);
        IsmMsgManager.getInstance().postSyncMsg(msg);
    }

    public void setDirtyTag(UUID uuid) {
        MOsCache cache = this.findCache(uuid);
        if (cache != null) {
            cache.setDirtyTag(uuid);
        }
    }

    public void setDirtyTag(String deviceID, int moType) {
        MOsCache cache = this.findCache(deviceID);
        if (cache != null) {
            cache.setDirtyTag(moType);
        }
    }

    public void setDirtyTag(String deviceID) {
        MOsCache cache = this.findCache(deviceID);
        if (cache != null) {
            cache.setDirtyTag();
        }
    }

    public void setLicenseDirtyTag(String deviceID) {
        IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_TYPE_LICENSE_RECEIVE");
        msg.setProperty("DEVICE_ID", deviceID);
        IsmMsgManager.getInstance().postSyncMsg(msg);
    }

    protected void saveMOs(String deviceID, int moType, List<MO> moList) {
        Assert.notNull(moList);
        for (MO mo : moList) {
            if (mo.getMOTypeValue() == moType && mo.getDeviceID().equals(deviceID)) continue;
            throw new IllegalArgumentException("all MO MUST be same Type and belong to same device: " + deviceID + " / " + moType + "\n" + mo);
        }
        MOsCache cache = this.findCache(deviceID);
        if (cache == null) {
            cache = new MOsCache(deviceID);
            SoftReference<MOsCache> ref = new SoftReference<MOsCache>(cache);
            this.nodeCacheMap.put(deviceID, ref);
        }
        cache.saveMOList(moType, moList);
    }

    private MOsCache findCache(MO component) {
        return this.findCache(component.getDeviceID());
    }

    private MOsCache findCache(UUID uuid) {
        return this.findCache(uuid.getDeviceID());
    }

    private MOsCache findCache(String deviceID) {
        SoftReference<MOsCache> ref = this.nodeCacheMap.get(deviceID);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    protected boolean deleteMO(UUID uuid) {
        Assert.notNull(uuid);
        MOsCache cache = this.findCache(uuid);
        boolean ok = false;
        if (cache != null) {
            ok = cache.deleteMO(uuid);
        }
        this.sendMsg(uuid.getDeviceID());
        return ok;
    }

    static class OperationResult {
        private ResultDescription result;
        private List<MO> mos;
        private List<MO> dirtyMOs;
        private MO datacacheMo;

        public OperationResult(ResultDescription result, List<MO> mos, MO mo) {
            this.result = result;
            this.mos = mos;
            this.datacacheMo = mo;
        }

        public List<MO> getDirtyMOs() {
            return this.dirtyMOs;
        }

        public void setDirtyMOs(List<MO> dirtyMOs) {
            this.dirtyMOs = dirtyMOs;
        }

        public List<MO> getMOs() {
            return this.mos;
        }

        public ResultDescription getResult() {
            return this.result;
        }

        public MO getDatacacheMo() {
            return this.datacacheMo;
        }
    }

    static enum ResultDescription {
        DATA_NULL,
        NEED_SYNC,
        NEED_PART_SYNC,
        NONEED_SYNC;

    }
}

