/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.thread;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.MyCustLatch;
import com.huawei.ism.thread.TaskListener;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.framework.platform.task.ITask;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.ui.module.command.Command;
import com.huawei.ism.ui.module.command.CommandExcutor;
import com.huawei.ism.ui.module.command.CommandExcutorMonitor;
import com.huawei.ism.ui.module.command.CommandExcutorObserver;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.MultiErrorDialog;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncExcutor {
    private static final int TIME_OUT = 90;
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncExcutor.class);

    public static List<?> execute(Callable<?> ... tasks) {
        return AsyncExcutor.execute(true, tasks);
    }

    public static synchronized <T> Future<T> submit(Callable<T> task) {
        return ThreadPoolManager.getInstance().getAsyncExcutor().submit(task);
    }

    @SafeVarargs
    public static synchronized <T> void submit(Callable<T> ... tasks) {
        for (Callable<T> t : tasks) {
            Future<T> f = ThreadPoolManager.getInstance().getAsyncExcutor().submit(t);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("tasks +" + t + " is submitted:" + f);
        }
    }

    public static void submit(Callable task, TaskListener listener) {
        TaskOperation o = new TaskOperation(task, listener);
        Future<?> f = ThreadPoolManager.getInstance().getAsyncExcutor().submit(o);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("tasks +" + task + " is submitted:" + f);
        }
    }

    public static Future submit(Runnable task) {
        return ThreadPoolManager.getInstance().getAsyncExcutor().submit(task);
    }

    public static void execute(Window parent, Command ... commands) {
        AsyncExcutor.execute(parent, null, commands);
    }

    public static void execute(Window parent, CommandExcutorObserver observer, Command ... commands) {
        AsyncExcutor.execute(parent, observer, CommandExcutor.EExecuteMode.FAILED_CONTINUE, commands);
    }

    public static void execute(Window parent, CommandExcutorObserver observer, CommandExcutor.EExecuteMode executeMode, Command ... commands) {
        CommandExcutorMonitor monitor = null;
        if (null != parent) {
            monitor = new CommandExcutorMonitor(parent);
        }
        AsyncExcutor.execute(monitor, observer, executeMode, commands);
    }

    public static void execute(CommandExcutorMonitor monitor, CommandExcutorObserver observer, final CommandExcutor.EExecuteMode executeMode, final Command ... commands) {
        if (null == commands || 0 == commands.length) {
            throw new IllegalArgumentException("Command List cannot be null");
        }
        final CommandExcutor excutor = new CommandExcutor();
        if (null != observer) {
            excutor.addObserver(observer);
        }
        if (null != monitor) {
            SwingUtil.putParentCenter(monitor, monitor.getOwner());
            excutor.addObserver(monitor);
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    excutor.execute(executeMode, commands);
                }
                catch (Throwable e) {
                    LOGGER.error("AsyncExcutor.execute", e);
                }
            }
        };
        AsyncExcutor.submit(run);
        if (null != monitor) {
            monitor.setVisible(true);
        }
    }

    public static List<?> execute(boolean showBusybox, Callable<?> ... tasks) {
        return AsyncExcutor.execute(showBusybox, 0L, tasks);
    }

    public static List<?> execute(Window parent, Callable<?> ... tasks) {
        return AsyncExcutor.execute(parent, true, 0L, tasks);
    }

    public static List<?> execute(Window parent, JProgressBar progressBar, Callable<?> ... tasks) {
        return AsyncExcutor.execute(parent, progressBar, true, 0L, tasks);
    }

    public static List<?> execute(Window parent, JProgressBar progressBar, String custMizeMsg, Callable<?> ... tasks) {
        return AsyncExcutor.execute(parent, progressBar, custMizeMsg, true, 0L, tasks);
    }

    public static List<?> execute(boolean showBusybox, long timeout, Callable<?> ... tasks) {
        Frame parent = Framework.getInstance().getMainFrame();
        return AsyncExcutor.execute(new ProgressDialog((Window)parent), showBusybox, timeout, tasks);
    }

    public static List<?> execute(Window parent, boolean showBusybox, long timeout, Callable<?> ... tasks) {
        return AsyncExcutor.execute(new ProgressDialog(parent), showBusybox, timeout, tasks);
    }

    public static List<?> execute(Window parent, JProgressBar progressBar, boolean showBusybox, long timeout, Callable<?> ... tasks) {
        return AsyncExcutor.execute(new ProgressDialog(parent, progressBar), showBusybox, timeout, tasks);
    }

    public static List<?> execute(Window parent, JProgressBar progressBar, String custMizeMsg, boolean showBusybox, long timeout, Callable<?> ... tasks) {
        return AsyncExcutor.execute(new ProgressDialog(parent, custMizeMsg, 220, progressBar), showBusybox, timeout, tasks);
    }

    public static List<?> execute(Frame parent, boolean showBusybox, long timeout, Callable<?> ... tasks) {
        return AsyncExcutor.execute(new ProgressDialog((Window)parent), showBusybox, timeout, tasks);
    }

    public static List<?> execute(ProgressDialog pd, boolean showBusybox, long timeout, final Callable<?> ... tasks) {
        ProgressDialog progressDialog;
        if (showBusybox) {
            progressDialog = pd;
        } else {
            progressDialog = null;
            pd.dispose();
        }
        ExecutorService executor = ThreadPoolManager.getInstance().getAsyncExcutor();
        Callable taskB = new Callable<List<?>>(){

            @Override
            public List<?> call() throws Exception {
                ArrayList<Object> result = new ArrayList<Object>(0);
                for (Callable task : tasks) {
                    try {
                        result.add(task.call());
                    }
                    catch (Throwable ex) {
                        result.add(ex);
                    }
                }
                if (null != progressDialog) {
                    AsyncExcutor.disposeProgressDialog(progressDialog);
                }
                return result;
            }
        };
        Future future = executor.submit(taskB);
        if (null != progressDialog) {
            progressDialog.setVisible(true);
            progressDialog.toFront();
        }
        List result = new ArrayList(0);
        try {
            result = timeout <= 0L ? (List)future.get() : (List)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            LOGGER.error("", e);
        }
        if (null != progressDialog) {
            AsyncExcutor.disposeProgressDialog(progressDialog);
        }
        return result;
    }

    public static void showProgressDialog(final ProgressDialog progressDialog) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(true);
            }
        });
    }

    public static void disposeProgressDialog(final ProgressDialog progressDialog) {
        SwingUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
            }
        });
    }

    public static void batchExecute(List<String> deviceIDs, List<Callable> calls) {
        List<?> result = AsyncExcutor.execute(true, calls.toArray(new Callable[calls.size()]));
        ArrayList<DefaultTableRow<Object, String>> tableRows = new ArrayList<DefaultTableRow<Object, String>>(0);
        IsmException be = null;
        Object o = null;
        for (int i = 0; i < deviceIDs.size(); ++i) {
            be = null;
            o = result.get(i);
            if (o instanceof IsmException) {
                be = o;
            } else if (o instanceof Throwable) {
                be = new IsmException(ResourceManager.getString("-1"), (Throwable)o);
            }
            if (be == null) continue;
            String deviceID = deviceIDs.get(i);
            DefaultTableRow<Object, String> tableRow = new DefaultTableRow<Object, String>(2, null, deviceID);
            tableRow.setValueAt(0, LauncherManager.getInstance().getLauncher(deviceID).getDeviceContext().getDeviceName());
            tableRow.setValueAt(1, be.getErrorMessage());
            tableRows.add(tableRow);
        }
        Frame parent = Framework.getInstance().getMainFrame();
        if (!tableRows.isEmpty()) {
            MultiErrorDialog meDialog = new MultiErrorDialog((Window)parent, ResourceManager.getString("ERROR.MSG.SOME_DEVICE_OPERATION_FAIL"), new String[]{ResourceManager.getString("ALL_ARRAYS_NAME"), ResourceManager.getString("REFRESH_ACTION_ERROR_DIALOG_TITLE_REASON")});
            meDialog.getTableModel().setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
            meDialog.setVisible(true);
        } else {
            DialogUtils.showInfoDialog(parent);
        }
    }

    public static List<?> execute(JFrame parent, String custMsg, int custWidth, Callable<?> ... tasks) {
        return AsyncExcutor.execute(new ProgressDialog((Window)parent, custMsg, custWidth), true, 0L, tasks);
    }

    public static List<?> execute(Window parent, String custMsg, int custWidth, Callable<?> ... tasks) {
        return AsyncExcutor.execute(new ProgressDialog(parent, custMsg, custWidth), true, 0L, tasks);
    }

    public static <T extends ITask.ITaskResult> T execReturnFirstSucc(List<ITask<T>> tasks) {
        MyCustLatch resultLatch = new MyCustLatch(1);
        CountDownLatch doOverLatch = new CountDownLatch(tasks.size());
        TaskResult mainTaskResult = new TaskResult();
        try {
            for (ITask<T> iTask : tasks) {
                AsyncExcutor.submit(new ExecAndCountTask<T>(iTask, resultLatch, doOverLatch, mainTaskResult));
            }
            if (resultLatch.await(90L, TimeUnit.SECONDS)) {
                return (T)((ITask.ITaskResult)resultLatch.getResult());
            }
        }
        catch (Exception e) {
            LOGGER.error("exec task error!", (Throwable)e);
        }
        return null;
    }

    public static List<?> execute(Window parent, String custMsg, int custWidth, JProgressBar progressBar, Callable<?> ... tasks) {
        return AsyncExcutor.execute(new ProgressDialog(parent, custMsg, custWidth, progressBar), true, 0L, tasks);
    }

    private static class ExecAndCountTask<T extends ITask.ITaskResult>
    implements Callable<T> {
        private ITask<T> task;
        private final MyCustLatch<T> resultLatch;
        private CountDownLatch doOverLatch;
        private TaskResult mainTaskResult;

        public ExecAndCountTask(ITask<T> task, MyCustLatch<T> resultLatch, CountDownLatch doOverLatch, TaskResult mainTaskResult) {
            this.task = task;
            this.resultLatch = resultLatch;
            this.doOverLatch = doOverLatch;
            this.mainTaskResult = mainTaskResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            ITask.ITaskResult result = null;
            MyCustLatch<T> myCustLatch = this.resultLatch;
            synchronized (myCustLatch) {
                try {
                    result = (ITask.ITaskResult)this.task.doTask(this.mainTaskResult);
                    if (result != null && result.isTaskSuccess()) {
                        this.resultLatch.setResult(result);
                        this.resultLatch.countDown();
                        this.mainTaskResult.setResult(TaskResult.Result.SUCCESS);
                    }
                }
                finally {
                    this.doOverLatch.countDown();
                    if (this.doOverLatch.getCount() == 0L) {
                        this.resultLatch.countDown();
                    }
                }
            }
            return (T)result;
        }
    }

    private static class TaskOperation
    implements Runnable {
        private TaskListener listeners = null;
        private Callable callableTask = null;

        public TaskOperation(Callable task, TaskListener listener) {
            this.callableTask = task;
            this.listeners = listener;
        }

        @Override
        public void run() {
            this.listeners.taskRunning(0);
            try {
                Object object = this.callableTask.call();
                this.listeners.taskCompleted(object);
            }
            catch (Exception e) {
                this.listeners.taskFailed(null, e);
            }
        }
    }
}

