/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv.lang;

import com.huawei.ism.tlv.lang.IsmUnsignedInteger;

public class UnsignedInt16
extends IsmUnsignedInteger {
    private static final long serialVersionUID = -335923604368968730L;
    private final int unsignedIntvalue;

    public UnsignedInt16(int value) {
        this.unsignedIntvalue = value;
    }

    public UnsignedInt16(short value) {
        this.unsignedIntvalue = value;
    }

    public UnsignedInt16(byte[] bytes) {
        this.unsignedIntvalue = this.fromByteArray(bytes, bytes.length);
    }

    public UnsignedInt16(byte[] bytes, int offset) {
        if (null == bytes) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (offset < 0 || bytes.length - offset < 2) {
            throw new IllegalArgumentException("Data size mismatch.");
        }
        byte[] tmp = new byte[2];
        System.arraycopy(bytes, offset, tmp, 0, 2);
        this.unsignedIntvalue = this.fromByteArray(tmp, tmp.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.unsignedIntvalue;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnsignedInt16 other = (UnsignedInt16)obj;
        return this.unsignedIntvalue == other.unsignedIntvalue;
    }

    private int fromByteArray(byte[] abyte0, int bytesToRead) {
        if (abyte0.length < bytesToRead || bytesToRead <= 0) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        int intVal = 0;
        int arrayLength = abyte0.length;
        int count = bytesToRead >= 2 ? 2 : bytesToRead;
        intVal = abyte0[arrayLength - 1] & 0xFF;
        for (int i = 2; i <= count; ++i) {
            intVal <<= 8;
            intVal |= abyte0[arrayLength - i] & 0xFF;
        }
        return intVal;
    }

    @Override
    public byte[] toByteArray() {
        byte[] returnArray = new byte[2];
        returnArray[1] = (byte)(this.unsignedIntvalue >>> 8 & 0xFF);
        returnArray[0] = (byte)this.unsignedIntvalue;
        return returnArray;
    }

    @Override
    public byte[] toByteArray(int bytesToWrite) {
        byte[] fillerBuff = this.toByteArray();
        byte[] buff = fillerBuff.length == bytesToWrite ? fillerBuff : this.toByteArrayDecade(bytesToWrite, fillerBuff);
        return buff;
    }

    private byte[] toByteArrayDecade(int bytesToWrite, byte[] fillersBuff) {
        byte[] buff = new byte[bytesToWrite];
        if (fillersBuff.length < bytesToWrite) {
            System.arraycopy(fillersBuff, 0, buff, bytesToWrite - fillersBuff.length, fillersBuff.length);
        } else {
            System.arraycopy(fillersBuff, fillersBuff.length - bytesToWrite, buff, 0, bytesToWrite);
        }
        return buff;
    }

    @Override
    public int intValue() {
        return this.unsignedIntvalue;
    }

    @Override
    public double doubleValue() {
        return this.unsignedIntvalue;
    }

    @Override
    public float floatValue() {
        return this.unsignedIntvalue;
    }

    @Override
    public long longValue() {
        return this.unsignedIntvalue;
    }

    @Override
    public boolean isFFFF() {
        return (this.unsignedIntvalue & 0xFFFF) == 65535;
    }
}

