/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareInfoAdapter;
import com.huawei.ism.tool.framework.pubservice.hardware.IPortInfo;

public class FcPortMO
extends HardwareInfoAdapter
implements IPortInfo {
    private final MO mo;

    public FcPortMO(MO mo) {
        this.mo = mo;
    }

    @Override
    public boolean isNormal() {
        return true;
    }

    public UUID getUUID() {
        return this.mo.getUUID();
    }

    @Override
    public MOType getType() {
        return MOType.getType(Integer.parseInt(this.mo.getProperty(TLV.FC_PORT.TYPE).toString()));
    }

    public int getSlotID() {
        return (int)(Long.valueOf(this.getID()) & 0xFFL);
    }

    @Override
    public String getID() {
        return this.mo.getStrProperty(TLV.FC_PORT.ID);
    }

    public String getName() {
        return this.mo.getStrProperty(TLV.FC_PORT.NAME);
    }

    @Override
    public int getParentType() {
        return Integer.parseInt(this.mo.getProperty(TLV.FC_PORT.PARENTTYPE).toString());
    }

    @Override
    public String getParentID() {
        return this.mo.getStrProperty(TLV.FC_PORT.PARENTID);
    }

    @Override
    public String getLocation() {
        return this.mo.getStrProperty(TLV.FC_PORT.LOCATION);
    }

    public void setLocation(String location) {
        this.mo.setProperty(TLV.FC_PORT.LOCATION, location);
    }

    public Param getLocationParam() {
        if (this.getLocation() == null) {
            return null;
        }
        return new Param(TLV.FC_PORT.LOCATION.getParamIndex(), TLV.FC_PORT.LOCATION.getParamType(), this.getLocation());
    }

    @Override
    public int getHealthStatus() {
        return Integer.parseInt(this.mo.getProperty(TLV.FC_PORT.HEALTHSTATUS).toString());
    }

    @Override
    public int getRunningStatus() {
        return Integer.parseInt(this.mo.getProperty(TLV.FC_PORT.RUNNINGSTATUS).toString());
    }

    public long getCount() {
        return this.mo.getLongProperty(TLV.FC_PORT.COUNT);
    }

    public EnumDefine.PORT_LOGIC_TYPE_E getLogicType() {
        return EnumDefine.PORT_LOGIC_TYPE_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.FC_PORT.LOGICTYPE).toString()));
    }

    public long getRunSpeed() {
        return this.mo.getLongProperty(TLV.FC_PORT.RUNSPEED);
    }

    public long getConfSpeed() {
        return this.mo.getLongProperty(TLV.FC_PORT.CONFSPEED);
    }

    public void setConfSpeed(long confSpeed) {
        this.mo.setProperty(TLV.FC_PORT.CONFSPEED, new UnsignedInt32(confSpeed));
    }

    public String getWwn() {
        return this.mo.getStrProperty(TLV.FC_PORT.WWN);
    }

    public EnumDefine.INI_OR_TGT_E getIniOrTgt() {
        return EnumDefine.INI_OR_TGT_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.FC_PORT.INIORTGT).toString()));
    }

    public EnumDefine.PORT_SFP_STATUS_E getSfpStatus() {
        return EnumDefine.PORT_SFP_STATUS_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.FC_PORT.SFPSTATUS).toString()));
    }

    public EnumDefine.FC_PORT_MODE_E getFcConfMode() {
        return EnumDefine.FC_PORT_MODE_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.FC_PORT.FCCONFMODE).toString()));
    }

    public void setFcConfMode(EnumDefine.FC_PORT_MODE_E fcConfMode) {
        this.mo.setProperty(TLV.FC_PORT.FCCONFMODE, fcConfMode.getValue());
    }

    public EnumDefine.FC_PORT_MODE_E getFcRunMode() {
        return EnumDefine.FC_PORT_MODE_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.FC_PORT.FCRUNMODE).toString()));
    }

    public long getLostSignals() {
        return this.mo.getLongProperty(TLV.FC_PORT.LOSTSIGNALS);
    }

    public long getBadCharNumber() {
        return this.mo.getLongProperty(TLV.FC_PORT.BADCHARNUMBER);
    }

    public long getLostSync() {
        return this.mo.getLongProperty(TLV.FC_PORT.LOSTSYNC);
    }

    public long getLinkFail() {
        return this.mo.getLongProperty(TLV.FC_PORT.LINKFAIL);
    }

    public long getStartTime() {
        return this.mo.getLongProperty(TLV.FC_PORT.STARTTIME);
    }

    public long getFloginDelayTimes() {
        return this.mo.getLongProperty(TLV.FC_PORT.FLOGINDELAYTIMES);
    }

    public long getMaxSupportSpeed() {
        return this.mo.getLongProperty(TLV.FC_PORT.MAXSUPPORTSPEED);
    }

    public String getControlID() {
        if (null == this.getParentID()) {
            return null;
        }
        String parentID = this.getParentID();
        String[] ids = parentID.split("\\.");
        return ids[0];
    }

    public MO getMO() {
        return this.mo;
    }

    @Override
    public String getCurrentPeerID() {
        return null;
    }

    @Override
    public String getSuggestPeerID() {
        return null;
    }
}

