/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.hardware.ControllerMO;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskMO;
import com.huawei.ism.tool.framework.pubservice.hardware.EthPortMO;
import com.huawei.ism.tool.framework.pubservice.hardware.IntfModuleMO;
import com.huawei.ism.tool.framework.pubservice.hardware.PCIePortMO;
import com.huawei.ism.tool.framework.pubservice.hardware.PowerMO;
import com.huawei.ism.tool.framework.pubservice.hardware.SasPortMO;
import java.util.ArrayList;
import java.util.List;

public final class RecordParser {
    private RecordParser() {
    }

    public static List<DiskMO> parse2DiskMO(List<Record> records, String deviceID) throws ToolException {
        ArrayList<DiskMO> list = new ArrayList<DiskMO>();
        return list;
    }

    public static List<ControllerMO> parse2ControllerMO(List<Record> records, String deviceID) throws ToolException {
        ArrayList<ControllerMO> list = new ArrayList<ControllerMO>();
        return list;
    }

    public static List<IntfModuleMO> parse2IntfModuleMO(List<Record> records, String deviceID) throws ToolException {
        ArrayList<IntfModuleMO> list = new ArrayList<IntfModuleMO>();
        return list;
    }

    public static List<EthPortMO> parse2EthPortMO(List<Record> records, String deviceID) throws ToolException {
        RecordParser.checkRecords(records);
        RecordParser.checkDevID(deviceID);
        ArrayList<EthPortMO> list = new ArrayList<EthPortMO>();
        for (Record record : records) {
            IsmInteger typeInt = record.getParamIntValue(TLV.ETH_PORT.TYPE.getParamIndex());
            String id = record.getParamStrValue(TLV.ETH_PORT.ID.getParamIndex());
            String name = record.getParamStrValue(TLV.ETH_PORT.NAME.getParamIndex());
            IsmInteger parentTypeInt = record.getParamIntValue(TLV.ETH_PORT.PARENTTYPE.getParamIndex());
            String parentID = record.getParamStrValue(TLV.ETH_PORT.PARENTID.getParamIndex());
            String location = record.getParamStrValue(TLV.ETH_PORT.LOCATION.getParamIndex());
            IsmInteger runStatusInt = record.getParamIntValue(TLV.ETH_PORT.RUNNINGSTATUS.getParamIndex());
            RecordParser.checkParams(typeInt, id, name, parentTypeInt, parentID, location, runStatusInt);
            MO mo = new MO(deviceID, MOType.getType(typeInt.intValue()), id);
            EthPortMO ethPortMo = new EthPortMO(mo);
            ethPortMo.setType(MOType.getType(typeInt.intValue()));
            ethPortMo.setID(id);
            ethPortMo.setName(name);
            ethPortMo.setParentType(MOType.getType(parentTypeInt.intValue()));
            ethPortMo.setParentID(parentID);
            ethPortMo.setLocation(location);
            ethPortMo.setRunningStatus(EnumDefine.RUNNING_STATUS_E.valueOf(runStatusInt.intValue()));
            list.add(ethPortMo);
        }
        return list;
    }

    public static List<PowerMO> parse2PowerMO(List<Record> records, String deviceID) throws ToolException {
        RecordParser.checkRecords(records);
        RecordParser.checkDevID(deviceID);
        ArrayList<PowerMO> list = new ArrayList<PowerMO>();
        for (Record record : records) {
            IsmInteger typeInt = record.getParamIntValue(TLV.POWER.TYPE.getParamIndex());
            String id = record.getParamStrValue(TLV.POWER.ID.getParamIndex());
            String name = record.getParamStrValue(TLV.POWER.NAME.getParamIndex());
            IsmInteger parentTypeInt = record.getParamIntValue(TLV.POWER.PARENTTYPE.getParamIndex());
            String parentID = record.getParamStrValue(TLV.POWER.PARENTID.getParamIndex());
            String location = record.getParamStrValue(TLV.POWER.LOCATION.getParamIndex());
            IsmInteger runStatusInt = record.getParamIntValue(TLV.POWER.RUNNINGSTATUS.getParamIndex());
            RecordParser.checkParams(typeInt, id, name, parentTypeInt, parentID, location, runStatusInt);
            MO mo = new MO(deviceID, MOType.getType(typeInt.intValue()), id);
            PowerMO powerMo = new PowerMO(mo);
            powerMo.setType(MOType.getType(typeInt.intValue()));
            powerMo.setID(id);
            powerMo.setName(name);
            powerMo.setParentType(MOType.getType(parentTypeInt.intValue()));
            powerMo.setParentID(parentID);
            powerMo.setLocation(location);
            powerMo.setRunningStatus(EnumDefine.RUNNING_STATUS_E.valueOf(runStatusInt.intValue()));
            list.add(powerMo);
        }
        return list;
    }

    public static List<SasPortMO> parse2SasPortMO(List<Record> records, String deviceID) throws ToolException {
        RecordParser.checkRecords(records);
        RecordParser.checkDevID(deviceID);
        ArrayList<SasPortMO> list = new ArrayList<SasPortMO>();
        for (Record record : records) {
            IsmInteger typeInt = record.getParamIntValue(TLV.SAS_PORT.TYPE.getParamIndex());
            String id = record.getParamStrValue(TLV.SAS_PORT.ID.getParamIndex());
            String name = record.getParamStrValue(TLV.SAS_PORT.NAME.getParamIndex());
            IsmInteger parentTypeInt = record.getParamIntValue(TLV.SAS_PORT.PARENTTYPE.getParamIndex());
            String parentID = record.getParamStrValue(TLV.SAS_PORT.PARENTID.getParamIndex());
            String location = record.getParamStrValue(TLV.SAS_PORT.LOCATION.getParamIndex());
            IsmInteger runStatusInt = record.getParamIntValue(TLV.SAS_PORT.RUNNINGSTATUS.getParamIndex());
            String currentPeerID = null;
            String suggestPeerID = record.getParamStrValue(TLV.SAS_PORT.SUGGEST_PEER_ID.getParamIndex());
            RecordParser.checkParams(typeInt, id, name, parentTypeInt, parentID, location, runStatusInt, suggestPeerID);
            MO mo = new MO(deviceID, MOType.getType(typeInt.intValue()), id);
            SasPortMO sasPortMo = new SasPortMO(mo);
            sasPortMo.setType(MOType.getType(typeInt.intValue()));
            sasPortMo.setID(id);
            sasPortMo.setName(name);
            sasPortMo.setParentType(MOType.getType(parentTypeInt.intValue()));
            sasPortMo.setParentID(parentID);
            sasPortMo.setLocation(location);
            sasPortMo.setRunningStatus(EnumDefine.RUNNING_STATUS_E.valueOf(runStatusInt.intValue()));
            sasPortMo.setSuggestPeerID(suggestPeerID);
            if (EnumDefine.RUNNING_STATUS_E.LINK_UP.getValue() == runStatusInt.intValue()) {
                currentPeerID = record.getParamStrValue(TLV.SAS_PORT.CURRENT_PEER_ID.getParamIndex());
                RecordParser.checkParams(currentPeerID);
                sasPortMo.setCurrentPeerID(currentPeerID);
            }
            list.add(sasPortMo);
        }
        return list;
    }

    public static List<PCIePortMO> parse2PCIePortMO(List<Record> records, String deviceID) throws ToolException {
        RecordParser.checkRecords(records);
        RecordParser.checkDevID(deviceID);
        ArrayList<PCIePortMO> list = new ArrayList<PCIePortMO>();
        for (Record record : records) {
            IsmInteger typeInt = record.getParamIntValue(TLV.PCIE_PORT.TYPE.getParamIndex());
            String id = record.getParamStrValue(TLV.PCIE_PORT.ID.getParamIndex());
            IsmInteger parentTypeInt = record.getParamIntValue(TLV.PCIE_PORT.PARENTTYPE.getParamIndex());
            String parentID = record.getParamStrValue(TLV.PCIE_PORT.PARENTID.getParamIndex());
            String location = record.getParamStrValue(TLV.PCIE_PORT.LOCATION.getParamIndex());
            IsmInteger runStatusInt = record.getParamIntValue(TLV.PCIE_PORT.RUNNINGSTATUS.getParamIndex());
            String currentPeerID = null;
            String suggestPeerID = record.getParamStrValue(TLV.PCIE_PORT.SUGGEST_PEER_ID.getParamIndex());
            RecordParser.checkParams(typeInt, id, parentTypeInt, parentID, location, runStatusInt, suggestPeerID);
            MO mo = new MO(deviceID, MOType.getType(typeInt.intValue()), id);
            PCIePortMO pciePortMO = new PCIePortMO(mo);
            pciePortMO.setType(MOType.getType(typeInt.intValue()));
            pciePortMO.setID(id);
            pciePortMO.setParentType(MOType.getType(parentTypeInt.intValue()));
            pciePortMO.setParentID(parentID);
            pciePortMO.setLocation(location);
            pciePortMO.setRunningStatus(EnumDefine.RUNNING_STATUS_E.valueOf(runStatusInt.intValue()));
            pciePortMO.setSuggestPeerID(suggestPeerID);
            if (EnumDefine.RUNNING_STATUS_E.LINK_UP.getValue() == runStatusInt.intValue()) {
                currentPeerID = record.getParamStrValue(TLV.PCIE_PORT.CURRENT_PEER_ID.getParamIndex());
                RecordParser.checkParams(currentPeerID);
                pciePortMO.setCurrentPeerID(currentPeerID);
            }
            list.add(pciePortMO);
        }
        return list;
    }

    private static void checkParams(Object ... objs) throws ToolException {
        ToolLoggerFactory.getLogger(RecordParser.class).info("checkParams:" + objs.length);
    }

    private static void checkDevID(String deviceID) throws ToolException {
        ToolLoggerFactory.getLogger(RecordParser.class).info("checkDevID:" + deviceID);
    }

    private static void checkRecords(List<Record> records) throws ToolException {
        if (records.isEmpty()) {
            throw new ToolException("operation.log.exception.records");
        }
    }
}

