/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.mainframe;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.forms.lockui.LockedDialog;
import com.huawei.ism.ui.forms.mainframe.MainPane;
import com.huawei.ism.ui.forms.mainframe.StatusPanel;
import com.huawei.ism.ui.forms.mainframe.ToolBarPanel;
import com.huawei.ism.ui.module.event.EventBuzzHandle;
import com.huawei.ism.ui.module.event.EventManager;
import com.huawei.ism.ui.module.event.EventStatTreeSelectionListener;
import com.huawei.ism.ui.swing.IsmMenuBar;
import com.huawei.ism.ui.widgets.action.ExitAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 3837556424968785008L;
    private StatusPanel statusPanel = new StatusPanel();
    private IsmMenuBar menuBar = new IsmMenuBar();
    private ToolBarPanel toolBarPanel = new ToolBarPanel();
    private boolean lockTag = false;

    public MainFrame() {
        this.initOutline();
        this.setDefaultCloseOperation(3);
        this.initContentPanel();
        this.setExtendedState(6);
        this.setName("ISM_KaimseFrame");
        this.setMinimumSize(new Dimension(960, 720));
        this.pack();
    }

    private void initContentPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setName("ISMV1R2_framework_MainFrame_contentPanel");
        BorderLayout layout = new BorderLayout();
        contentPanel.setLayout(layout);
        MainPane mainPanel = Framework.getInstance().createMainPane();
        contentPanel.add((Component)mainPanel, "Center");
        contentPanel.add((Component)this.toolBarPanel, "North");
        contentPanel.add((Component)this.statusPanel, "South");
        mainPanel.addTreeSelectionListener(new EventStatTreeSelectionListener(this.toolBarPanel.getEventStatPane()));
        EventManager.getInstance().addEventManagerListener(EventBuzzHandle.getInstance());
        this.setContentPane(contentPanel);
        this.setJMenuBar(this.menuBar);
        this.paintComponents(this.getGraphics());
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            ExitAction action = new ExitAction();
            action.actionPerformed(null);
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.menuBar.setEnabled(enabled);
    }

    public boolean isLock() {
        return this.lockTag;
    }

    public void setLock(final boolean lock) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (lock != MainFrame.this.lockTag) {
                    MainFrame.this.lockTag = lock;
                    if (lock) {
                        LockedDialog dialog = new LockedDialog(MainFrame.this);
                        dialog.setVisible(true);
                    }
                }
            }
        });
    }

    private void initOutline() {
        Dimension max = this.locateWindowBound();
        Dimension min = new Dimension((int)max.getWidth() / 4 * 3, (int)max.getHeight() / 4 * 3);
        Dimension prefer = new Dimension((int)max.getWidth() * 5 / 6, (int)max.getHeight() * 5 / 6);
        this.setPreferredSize(prefer);
        this.setMaximumSize(max);
        this.setMinimumSize(min);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension min = MainFrame.this.getMinimumSize();
                Component component = componentEvent.getComponent();
                if (null != component) {
                    if (component.getHeight() < min.height) {
                        component.setSize(component.getWidth(), min.height);
                    }
                    if (component.getWidth() < min.width) {
                        component.setSize(min.width, component.getHeight());
                    }
                }
            }
        });
        String title = ResourceManager.getOEMString("SOFTWARE_NAME");
        this.setTitle(title);
        ImageIcon imageIcon = null;
        try {
            imageIcon = ResourceManager.getImage("none.png");
        }
        catch (MissingResourceException e) {
            imageIcon = null;
        }
        Image image = null != imageIcon ? imageIcon.getImage() : null;
        this.setIconImage(image);
    }

    private Dimension locateWindowBound() {
        Dimension max = Toolkit.getDefaultToolkit().getScreenSize();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        if (null != gc) {
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            Rectangle screenBounds = gc.getBounds();
            max.width = screenBounds.width - (screenInsets.left + screenInsets.right);
            max.height = screenBounds.height - (screenInsets.top + screenInsets.bottom);
            screenBounds.setLocation(screenInsets.left, screenInsets.top);
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
            this.setMaximizedBounds(screenBounds);
        }
        return max;
    }

    public ToolBarPanel getToolBarPanel() {
        return this.toolBarPanel;
    }

    public StatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    public IsmMenuBar getIsmMenuBar() {
        return this.menuBar;
    }
}

