/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.layout;

import com.huawei.ism.ui.layout.HorizontalBox;
import com.huawei.ism.ui.layout.LayoutRow;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.util.CommonUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class KeyValueLayoutRow
implements LayoutRow {
    private int keyAlign = -1;
    private int valueAlign = -1;
    private HorizontalBox keyLayout = null;
    private HorizontalBox valueLayout = null;
    private Component keyComponent = null;
    private List<Component> valueComponents = new ArrayList<Component>(0);
    private int gap = 12;

    public KeyValueLayoutRow() {
    }

    public KeyValueLayoutRow(int gap) {
        this.gap = gap;
    }

    public void addKeyComponent(int keyAlignTemp, JComponent component) {
        this.keyAlign = keyAlignTemp;
        this.keyComponent = component;
    }

    public void addKeyComponent(JComponent component) {
        this.addKeyComponent(0, component);
    }

    public void addKeyComponent(JComponent component, boolean isLabelTextBold) {
        if (isLabelTextBold && component instanceof JLabel) {
            component.setFont(IsmFontFactory.getBold12Font());
        }
        this.addKeyComponent(component);
    }

    public void addValueComponent(int valueAlignTemp, Component ... components) {
        this.valueAlign = valueAlignTemp;
        for (Component component : components) {
            this.valueComponents.add(component);
        }
    }

    public void addValueComponent(int valueAlignTemp, boolean autoResize, Component ... components) {
        this.valueAlign = valueAlignTemp;
        for (Component component : components) {
            this.valueComponents.add(component);
        }
    }

    public void addValueComponent(boolean autoResize, Component ... components) {
        this.addValueComponent(0, components);
        if (!autoResize) {
            this.addValueComponent(0, Box.createHorizontalGlue());
        }
    }

    public void addValueComponent(Component ... components) {
        this.addValueComponent(true, components);
    }

    @Override
    public JComponent doLayout() {
        this.keyLayout = new HorizontalBox(this.keyAlign);
        this.keyLayout.addComponent(this.keyComponent);
        this.valueLayout = new HorizontalBox(this.valueAlign);
        this.valueLayout.addComponent(this.valueComponents);
        JComponent keyBox = this.keyLayout.doLayout();
        keyBox.setAlignmentX(0.0f);
        JComponent valueBox = this.valueLayout.doLayout();
        if (this.valueComponents.size() == 1 && this.valueComponents.get(0) instanceof JLabel) {
            valueBox.add(Box.createHorizontalGlue());
        }
        Box box = Box.createHorizontalBox();
        box.add(keyBox);
        box.add(Box.createHorizontalStrut(this.gap));
        box.add(valueBox);
        return box;
    }

    public int getMinWidth() {
        int keyMinWidth = this.getComponentMinWidth(this.keyComponent) + 12;
        int valueMinWidth = this.getMinWidth(this.valueComponents) + 12 * (this.valueComponents.size() - 1);
        return keyMinWidth + valueMinWidth + 12;
    }

    public void setSize(int width, int height) {
        if (this.valueComponents.size() == 1) {
            Component component = this.valueComponents.get(0);
            int keyWidth = this.getKeyComponentsMinWidth();
            if (width < keyWidth) {
                throw new IllegalArgumentException("");
            }
            if (component instanceof JTextField || component instanceof JComboBox) {
                this.setJComponentSize(component, new Dimension(width - keyWidth, height));
            }
        } else {
            throw new UnsupportedOperationException("");
        }
    }

    public void setJComponentSize(Component panel, Dimension dimension) {
        panel.setMaximumSize(dimension);
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
    }

    public void setKeyWidth(int width) {
        if (null != this.keyComponent) {
            Component component = this.keyComponent;
            int prefHeight = (int)component.getPreferredSize().getHeight();
            component.setPreferredSize(new Dimension(width, prefHeight));
            component.setMaximumSize(new Dimension(width, prefHeight));
            component.setMinimumSize(new Dimension(width, prefHeight));
        }
    }

    public int getKeyComponentsMinWidth() {
        int width = this.getComponentMinWidth(this.keyComponent);
        int preWidth = (int)this.keyComponent.getPreferredSize().getWidth();
        if (preWidth > width) {
            return preWidth;
        }
        return width;
    }

    public int getValueComponentsMaxWidth() {
        int width = 0;
        int compWidth = 0;
        for (Component comp : this.valueComponents) {
            compWidth = (int)comp.getPreferredSize().getWidth();
            width += compWidth;
            width += 10;
        }
        return width - 10;
    }

    private int getMinWidth(Collection<Component> components) {
        int result = 0;
        for (Component component : components) {
            result += this.getComponentMinWidth(component);
        }
        return result;
    }

    public int getComponentMinWidth(Component component) {
        int result = 0;
        FontMetrics fm = component.getFontMetrics(component.getFont());
        if (component instanceof JLabel) {
            int length;
            JLabel lable = CommonUtil.convertObject(component, JLabel.class);
            result = length = fm.stringWidth(lable.getText());
        } else if (component instanceof JRadioButton) {
            JRadioButton rb = CommonUtil.convertObject(component, JRadioButton.class);
            int length = fm.stringWidth(rb.getText());
            result = length + 24;
        } else if (component instanceof JCheckBox) {
            JCheckBox cb = CommonUtil.convertObject(component, JCheckBox.class);
            int length = fm.stringWidth(cb.getText());
            result = length + 26;
        } else {
            result = (int)component.getPreferredSize().getWidth();
        }
        return result;
    }
}

