/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.command;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.module.command.AbstractCommand;
import com.huawei.ism.ui.module.command.Command;
import com.huawei.ism.ui.module.command.CommandExcutorObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class CommandExcutor {
    private List<CommandExcutorObserver> observers = new ArrayList<CommandExcutorObserver>(0);

    public void addObserver(CommandExcutorObserver observer) {
        if (null == observer) {
            throw new IllegalArgumentException("CommandExcutorObserver cannot be null");
        }
        this.observers.add(observer);
    }

    public void execute(CommandPair ... cmdPairs) {
        ArrayList toBeUndoCommands = new ArrayList(0);
        ArrayList<Command> doCommands = new ArrayList<Command>(0);
        ArrayList<Command> undoCommands = new ArrayList<Command>(0);
        for (CommandPair pair : cmdPairs) {
            doCommands.add(pair.getExecuteCommand());
            undoCommands.add(pair.getUndoCommand());
        }
        this.executeCommand(EExecuteMode.FAILED_ABORT, doCommands.toArray(new Command[doCommands.size()]));
        CommandState commandState = null;
        int index = 0;
        for (Command doCommand : doCommands) {
            commandState = doCommand.getCommandState();
            if (commandState == CommandState.FAILED || commandState == CommandState.STOP) continue;
            index = doCommands.indexOf(doCommand);
            toBeUndoCommands.add(undoCommands.get(index));
        }
        if (toBeUndoCommands.size() != doCommands.size()) {
            Collections.reverse(toBeUndoCommands);
            this.executeCommand(EExecuteMode.FAILED_CONTINUE, toBeUndoCommands.toArray(new Command[toBeUndoCommands.size()]));
        }
        this.notifyExcutedFinished();
    }

    public void execute(EExecuteMode executeMode, Command ... commands) {
        if (null == executeMode || EExecuteMode.FAILED_ROLLBACK == executeMode) {
            throw new IllegalArgumentException("The method doesnot supported!");
        }
        this.executeCommand(executeMode, commands);
        this.notifyExcutedFinished();
    }

    private void executeCommand(EExecuteMode executeMode, Command ... commands) {
        if (null == commands || 0 == commands.length) {
            throw new IllegalArgumentException("Command array is not empty!");
        }
        this.fireAddCommand(commands);
        boolean succeeded = false;
        for (Command command : commands) {
            this.chgCmdState(command, CommandState.EXECUTING);
            this.notifyObserverUpdated(commands);
            succeeded = command.execute();
            if (!succeeded && EExecuteMode.FAILED_ABORT == executeMode) {
                this.abortWaitingCommands(commands);
                this.notifyObserverUpdated(commands);
                break;
            }
            this.notifyObserverUpdated(commands);
        }
    }

    protected void chgCmdState(Command command, CommandState commandState) {
        if (command instanceof AbstractCommand) {
            AbstractCommand cmd = (AbstractCommand)command;
            cmd.setCommandState(commandState);
        }
    }

    protected void abortWaitingCommands(Command ... commands) {
        AbstractCommand cmd = null;
        for (Command command : commands) {
            cmd = (AbstractCommand)command;
            if (cmd.getCommandState() != CommandState.WAIT_EXECUTE) continue;
            cmd.setCommandState(CommandState.STOP);
        }
    }

    private void fireAddCommand(Command ... commands) {
        for (CommandExcutorObserver observer : this.observers) {
            observer.fireAddCommand(commands);
        }
    }

    private void notifyObserverUpdated(Command ... commands) {
        for (CommandExcutorObserver observer : this.observers) {
            observer.fireStateChanged(commands);
        }
    }

    private void notifyExcutedFinished() {
        for (CommandExcutorObserver observer : this.observers) {
            observer.fireExcuteFinished();
        }
    }

    public static class CommandPair {
        private Command excuteCommand;
        private Command undoCommandPair;

        public CommandPair(Command doCommand, Command undoCommand) {
            if (null == doCommand || null == undoCommand) {
                throw new IllegalArgumentException("CommandExecutor.CommandPair construct error: doCommand or undoCommand is null.");
            }
            this.excuteCommand = doCommand;
            this.undoCommandPair = undoCommand;
        }

        public Command getExecuteCommand() {
            return this.excuteCommand;
        }

        public Command getUndoCommand() {
            return this.undoCommandPair;
        }
    }

    public static enum CommandState {
        WAIT_EXECUTE(""),
        EXECUTING("command_loading.gif"),
        SYN_CMD_FINISHED("command_success.png"),
        FAILED("command_failed.png"),
        ASYNC_CMD_COMPLETED("command_success.png"),
        STOP("command_failed.png");

        private Icon icon;

        private CommandState(String iconFile) {
            this.initIcon(iconFile);
        }

        public String toString() {
            return ResourceManager.getString("AbstractCommand.CommandState." + this.name());
        }

        public Icon getIcon() {
            return this.icon;
        }

        private void initIcon(String iconFile) {
            this.icon = null == iconFile || iconFile.isEmpty() ? null : ResourceManager.getImage(iconFile);
        }
    }

    public static enum EExecuteMode {
        FAILED_CONTINUE,
        FAILED_ABORT,
        FAILED_ROLLBACK;

    }
}

