/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.event;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.forms.help.HelpManager;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class EventDetailDialog
extends IsmDialog {
    private static final long serialVersionUID = -6874652137109782298L;
    private static final String COLON = ":";
    private static final String COLON_ZH = "\uff1a";
    private static final String SOURCE = ResourceManager.getString("ALARM_TABLE_MODEL_SOURCE");
    private static final String LEVEL = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_LEVEL");
    private static final String ALARMNO = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_NO");
    private static final String ALARMID = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_ID");
    private static final String DESC = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_DESC");
    private static final String START = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_START_TIME");
    private static final String END = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_RECOVER_TIME");
    private static final String TH_NAME_KEY = ResourceManager.getString("COMMON.TXT.KEY");
    private static final String TH_NAME_VAL = ResourceManager.getString("COMMON.TXT.VALUE");

    public EventDetailDialog(Window parentDialog, Event event) {
        super(parentDialog, ResourceManager.getString("COMMON.TXT.DETAIL"), IsmDialog.ECommonButton.Close, IsmDialog.ECommonButton.Help);
        this.initLayout(event);
        this.setSize(new Dimension(700, 600));
        this.setResizable(false);
        if (this.getGraphicsConfiguration() != null) {
            SwingUtil.putParentCenter(this, parentDialog);
        }
        this.getRootPane().setDefaultButton(this.getButtonBy(IsmDialog.ECommonButton.Close));
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
    }

    private void initLayout(Event event) {
        JSplitPane splitPane = new JSplitPane(0);
        this.getDialogContentPane().add(splitPane);
        this.getDialogContentPane().setBorder(UCD.createEmptyBorder());
        splitPane.setDividerLocation(140);
        TableScrollPane tableScrollPane = this.createTable(event);
        tableScrollPane.setMinimumSize(new Dimension(300, 204));
        splitPane.setLeftComponent(tableScrollPane);
        JPanel detailPane = new JPanel(new BorderLayout());
        detailPane.setOpaque(false);
        detailPane.setBorder(new EmptyBorder(5, 0, 0, 0));
        splitPane.setRightComponent(detailPane);
        splitPane.setDividerLocation(0.5);
        JLabel label = new JLabel(ResourceManager.getString("ALARM_MANAGE_REASON"));
        detailPane.add((Component)label, "North");
        JScrollPane textScrollPane = new JScrollPane(this.createTextArea(event));
        detailPane.add((Component)textScrollPane, "Center");
        this.doHelpTask(event);
        splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    private void doHelpTask(Event event) {
        if (null != event && event.getLevel().isFault()) {
            Launcher launcher = LauncherManager.getInstance().getLauncher(event.getIdentifier().getDeviceID());
            if (DeviceType.N8000.equals((Object)launcher.getDeviceContext().getDeviceType())) {
                this.setButtonState(IsmDialog.ECommonButton.Help, false);
            } else {
                String eventID = "0x" + Long.toHexString(event.getEventID()).toUpperCase(ResourceManager.getLocale());
                HelpManager.getInstance().linkEventHelp(this.getButtonBy(IsmDialog.ECommonButton.Help), eventID, event.getIdentifier().getDeviceID());
            }
        } else {
            this.setButtonState(IsmDialog.ECommonButton.Help, false);
        }
    }

    private TableScrollPane createTable(Event event) {
        DefaultTableModel model = new DefaultTableModel(new String[]{TH_NAME_KEY, TH_NAME_VAL}, new int[0]);
        IsmTable table = new IsmTable(model);
        TableScrollPane tableScrollPane = new TableScrollPane(table, false, false, false);
        table.setFocusable(false);
        List<TableRow> tableRows = this.convertToTableRow(event);
        model.setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
        table.getColumnModel().getColumn(0).setPreferredWidth(80);
        table.getColumnModel().getColumn(1).setPreferredWidth(400);
        return tableScrollPane;
    }

    private JTextArea createTextArea(Event event) {
        JTextArea textArea = new JTextArea();
        textArea.setEditable(false);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setText(this.getDetailInfo(event));
        textArea.setBorder(UCD.createEmptyBorder(4));
        textArea.setCaretPosition(0);
        return textArea;
    }

    private List<TableRow> convertToTableRow(Event event) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>(0);
        if (null != event) {
            boolean idxKey = false;
            boolean idxVal = true;
            Launcher launcher = LauncherManager.getInstance().getLauncher(event.getIdentifier().getDeviceID());
            if (null != launcher) {
                DefaultTableRow sourceRow = new DefaultTableRow(2, SOURCE);
                sourceRow.setValueAt(0, SOURCE);
                sourceRow.setValueAt(1, launcher.getDeviceName());
                rows.add(sourceRow);
            }
            DefaultTableRow snRow = new DefaultTableRow(2, ALARMNO);
            long sn = event.getIdentifier().getEventSN();
            String snNum = String.valueOf(sn);
            snRow.setValueAt(0, ALARMNO);
            snRow.setValueAt(1, snNum);
            rows.add(snRow);
            DefaultTableRow eventIDRow = new DefaultTableRow(2, ALARMID);
            String eventID = "0x" + Long.toHexString(event.getEventID()).toUpperCase(ResourceManager.getLocale());
            eventIDRow.setValueAt(0, ALARMID);
            eventIDRow.setValueAt(1, eventID);
            rows.add(eventIDRow);
            Event.Level level = event.getLevel();
            DefaultTableRow levelRow = new DefaultTableRow(2, LEVEL);
            levelRow.setValueAt(0, LEVEL);
            levelRow.setValueAt(1, level.toString());
            rows.add(levelRow);
            TimeZone zone = launcher != null ? launcher.getDeviceTimeZone() : TimeZone.getDefault();
            String startTime = TimeUtil.gmtToString(event.getStartTime(), zone);
            DefaultTableRow startTimeRow = new DefaultTableRow(2, START);
            startTimeRow.setValueAt(0, START);
            startTimeRow.setValueAt(1, startTime);
            rows.add(startTimeRow);
            if (event.isRecovered()) {
                String recoverTime = TimeUtil.gmtToString(event.getRecoverTime(), zone);
                DefaultTableRow recoverTimeRow = new DefaultTableRow(2, END);
                recoverTimeRow.setValueAt(0, END);
                recoverTimeRow.setValueAt(1, recoverTime);
                rows.add(recoverTimeRow);
            }
            DefaultTableRow descRow = new DefaultTableRow(2, DESC);
            descRow.setValueAt(0, DESC);
            descRow.setValueAt(1, event.getDescription());
            rows.add(descRow);
        }
        return rows;
    }

    private String getDetailInfo(Event event) {
        String suggestion;
        StringBuffer buffer = new StringBuffer();
        buffer.append(null == event ? "" : event.getDetail());
        String string = suggestion = null == event ? "" : event.getSuggestion();
        if (!"".equals(suggestion)) {
            buffer.append(System.lineSeparator());
            buffer.append(System.lineSeparator());
            buffer.append(ResourceManager.getString("ALARM_REPAIR_INFO"));
            if (ResourceManager.getLocale().equals(Locale.SIMPLIFIED_CHINESE)) {
                buffer.append(COLON_ZH);
            } else {
                buffer.append(COLON);
            }
            buffer.append('\n');
            buffer.append(suggestion);
        }
        return buffer.toString();
    }
}

