/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.task;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.forms.help.HelpManager;
import com.huawei.ism.ui.module.task.BackgroundTask;
import com.huawei.ism.ui.module.task.TaskManager;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.ui.templets.TableButtonLayout;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

public class TaskManagerFrame
extends IsmDialog {
    private static final long serialVersionUID = 7999362304622044014L;
    private final String[] columnName = new String[]{ResourceManager.getString("TASK_TYPE"), ResourceManager.getString("TASK_SOURCE"), ResourceManager.getString("TASK_OBJECT"), ResourceManager.getString("TASK_STATUS"), ResourceManager.getString("TASK_PROGRESS"), ResourceManager.getString("TASK_RESULT")};
    private TableButtonLayout tableButtonLayout;
    private Map<TaskManager.Operation, Action> actions = new HashMap<TaskManager.Operation, Action>(0);

    public TaskManagerFrame(List<BackgroundTask> taskList) {
        super((Window)Framework.getInstance().getMainFrame());
        this.setTitle(ResourceManager.getString("TASK_MANGER"));
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_statusPanel_TaskMangerDialog");
        this.initActions();
        this.initLayout();
        this.addEventHander();
        this.setIconImage(ResourceManager.getImage("taskmanger.gif").getImage());
        this.setSize(700, 500);
        this.addWindowListener(new MyWindowListner());
        SwingUtil.setName(this);
        this.fireTableRowsInserted(taskList.toArray(new BackgroundTask[taskList.size()]));
    }

    private void initLayout() {
        this.tableButtonLayout = new TableButtonLayout(this.columnName, true);
        this.tableButtonLayout.addButtonWith(this.actions.get((Object)TaskManager.Operation.RemoveSelected), this.actions.get((Object)TaskManager.Operation.RemoveCompleted), this.actions.get((Object)TaskManager.Operation.RemoveFailed));
        this.initTable();
        this.getDialogContentPane().add(this.tableButtonLayout);
        JButton closeBtn = UCD.createButton(ResourceManager.getString("COMMON.TXT.CLOSE"), 'L');
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskManager.getInstance().removeFrame();
                TaskManagerFrame.this.dispose();
            }
        });
        JButton helpBtn = UCD.createButton(ResourceManager.getString("COMMON.TXT.HELP"), 'H');
        HelpManager.getInstance().linkHelp((AbstractButton)helpBtn, "task_manage");
        this.getRootPane().setDefaultButton(closeBtn);
        this.getSouthBox().add(Box.createGlue());
        this.getSouthBox().add(closeBtn);
        this.getSouthBox().add(Box.createHorizontalStrut(10));
        this.getSouthBox().add(helpBtn);
    }

    private void initTable() {
        this.tableButtonLayout.getTableModel().setVisibleColumns(0, 1, 2, 3, 4, 5);
        TableColumnModel columnModel = this.tableButtonLayout.getTable().getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(70);
        columnModel.getColumn(1).setPreferredWidth(100);
        columnModel.getColumn(2).setPreferredWidth(100);
        columnModel.getColumn(3).setPreferredWidth(60);
        columnModel.getColumn(4).setPreferredWidth(130);
        columnModel.getColumn(5).setPreferredWidth(150);
    }

    private void initActions() {
        String strRemoveSelected = ResourceManager.getString("TASK_REMOVE_SELECTED");
        AbstractAction actRemoveSelected = new AbstractAction(strRemoveSelected){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List<TableRow> tableRows = TaskManagerFrame.this.tableButtonLayout.getTable().getMarkedRows();
                BackgroundTask task = null;
                for (TableRow tableRow : tableRows) {
                    task = (BackgroundTask)tableRow.getUserObject();
                    if (!task.canManualRemoved()) continue;
                    TaskManager.getInstance().removeTask(task);
                }
            }
        };
        actRemoveSelected.setEnabled(false);
        this.actions.put(TaskManager.Operation.RemoveSelected, actRemoveSelected);
        String strRemoveCompleted = ResourceManager.getString("TASK_REMOVE_COMPLETED");
        AbstractAction actRemoveCompleted = new AbstractAction(strRemoveCompleted){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BackgroundTask task = null;
                List<TableRow> tableRows = TaskManagerFrame.this.tableButtonLayout.getTableModel().getAllRows();
                for (TableRow tableRow : tableRows) {
                    task = (BackgroundTask)tableRow.getUserObject();
                    if (task.getState() != BackgroundTask.State.COMPLETED_NORMAL && task.getState() != BackgroundTask.State.COMPLETED_WARNING) continue;
                    TaskManager.getInstance().removeTask(task);
                }
            }
        };
        actRemoveCompleted.setEnabled(false);
        this.actions.put(TaskManager.Operation.RemoveCompleted, actRemoveCompleted);
        String strRemoveFailed = ResourceManager.getString("TASK_REMOVE_FAILED");
        AbstractAction actRemoveFailed = new AbstractAction(strRemoveFailed){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List<TableRow> tableRows = TaskManagerFrame.this.tableButtonLayout.getTableModel().getAllRows();
                BackgroundTask bTask = null;
                for (TableRow tableRow : tableRows) {
                    bTask = (BackgroundTask)tableRow.getUserObject();
                    if (bTask.getState() != BackgroundTask.State.FAILED) continue;
                    TaskManager.getInstance().removeTask(bTask);
                }
            }
        };
        actRemoveFailed.setEnabled(false);
        this.actions.put(TaskManager.Operation.RemoveFailed, actRemoveFailed);
    }

    private void addEventHander() {
        IsmTable table = this.tableButtonLayout.getTable();
        table.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TaskManagerFrame.this.updateRemoveSelectedAction();
            }
        });
    }

    protected void fireTableRowsInserted(BackgroundTask ... tasks) {
        if (null == tasks) {
            return;
        }
        ArrayList<TableRow> rows = new ArrayList<TableRow>(0);
        for (BackgroundTask task : tasks) {
            rows.add(this.convertToTableRow(task));
        }
        this.tableButtonLayout.getTableModel().addRow(rows.toArray(new TableRow[rows.size()]));
        this.updateRemoveCompletedAction();
        this.updateRemoveFailedAction();
        this.updateRemoveSelectedAction();
    }

    protected void fireTableRowsDeleted(BackgroundTask ... tasks) {
        if (null == tasks) {
            return;
        }
        ArrayList<TableRow> rows = new ArrayList<TableRow>(0);
        for (BackgroundTask task : tasks) {
            rows.add(this.convertToTableRow(task));
        }
        this.tableButtonLayout.getTableModel().removeRow(rows.toArray(new TableRow[rows.size()]));
        this.updateRemoveCompletedAction();
        this.updateRemoveFailedAction();
        this.updateRemoveSelectedAction();
    }

    protected void fireTableRowsUpdated(BackgroundTask ... tasks) {
        if (null == tasks) {
            return;
        }
        ArrayList<TableRow> rows = new ArrayList<TableRow>(0);
        for (BackgroundTask task : tasks) {
            rows.add(this.convertToTableRow(task));
        }
        this.tableButtonLayout.getTableModel().updateRow(rows.toArray(new TableRow[rows.size()]));
        this.updateRemoveCompletedAction();
        this.updateRemoveFailedAction();
        this.updateRemoveSelectedAction();
    }

    private void updateRemoveCompletedAction() {
        boolean canClear = false;
        List<TableRow> tableRows = this.tableButtonLayout.getTableModel().getAllRows();
        BackgroundTask brTask = null;
        for (TableRow tableRow : tableRows) {
            brTask = (BackgroundTask)tableRow.getUserObject();
            if (brTask.getState() != BackgroundTask.State.COMPLETED_NORMAL && brTask.getState() != BackgroundTask.State.COMPLETED_WARNING) continue;
            canClear = true;
            break;
        }
        this.actions.get((Object)TaskManager.Operation.RemoveCompleted).setEnabled(canClear);
    }

    private void updateRemoveSelectedAction() {
        boolean canClear = true;
        List<TableRow> tableRows = this.tableButtonLayout.getTable().getMarkedRows();
        if (tableRows.isEmpty()) {
            canClear = false;
        }
        BackgroundTask task = null;
        for (TableRow tableRow : tableRows) {
            task = (BackgroundTask)tableRow.getUserObject();
            if (task.canManualRemoved()) continue;
            canClear = false;
            break;
        }
        this.actions.get((Object)TaskManager.Operation.RemoveSelected).setEnabled(canClear);
    }

    private void updateRemoveFailedAction() {
        boolean canClear = false;
        List<TableRow> tableRows = this.tableButtonLayout.getTableModel().getAllRows();
        BackgroundTask task = null;
        for (TableRow tableRow : tableRows) {
            task = (BackgroundTask)tableRow.getUserObject();
            if (task.getState() != BackgroundTask.State.FAILED) continue;
            canClear = true;
            break;
        }
        this.actions.get((Object)TaskManager.Operation.RemoveFailed).setEnabled(canClear);
    }

    private TableRow convertToTableRow(BackgroundTask task) {
        DefaultTableRow<BackgroundTask, String> row = new DefaultTableRow<BackgroundTask, String>(this.columnName.length, task, task.getTaskSN());
        row.setValueAt(0, task.getName());
        Launcher launcher = LauncherManager.getInstance().getLauncher(task.getDviceId());
        String deviceName = "--";
        if (null != launcher && !"".equals(launcher.getDeviceName())) {
            deviceName = launcher.getDeviceName();
        }
        row.setValueAt(0, task.getName());
        row.setValueAt(1, deviceName);
        row.setValueAt(2, task.getTaskObject());
        row.setValueAt(3, (Object)task.getState());
        row.setValueAt(4, new IsmTableCell.ProgressCell(task.getProgress()));
        row.setValueAt(5, task.getResult());
        return row;
    }

    private static final class MyWindowListner
    extends WindowAdapter {
        private MyWindowListner() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            TaskManager.getInstance().removeFrame();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            TaskManager.getInstance().removeFrame();
        }
    }
}

