/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.plaf.IsmFileChooserUI;
import com.huawei.ism.ui.swing.plaf.unify.UnifyFileChooserUI;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsmFileChooser
extends JFileChooser {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsmFileChooser.class);
    private static final long serialVersionUID = 5142834665890723752L;
    private static final String INVALID_FILENAME_CHAR_REGEX_ON_WINDOWS = "[^|\\\\/*?<>\":]+";
    private static final String INVALID_FILENAME_CHAR_REGEX_ON_LINUX = "[^/]+";
    private static String defaultDir;
    private static int maxLenth;
    private JDialog parentDialog;
    private JButton approveButton;
    private JTextField filenametext;
    private boolean changefilename = false;
    private String filename = "";
    private String os = System.getProperty("os.name");
    private String networkPath = "network shortcuts";
    private boolean isNeedClean = false;

    public IsmFileChooser(String title) {
        super(defaultDir);
        this.setDialogTitle(title);
        this.approveButton = this.getApproveButton();
        if (null == this.approveButton) {
            throw new NullPointerException();
        }
        this.approveButton.setName("IsmFileChooser_Ok_Button");
        this.approveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IsmFileChooser.this.approveButtonPerformed();
            }
        });
        JButton cancel = this.getCancelButton(this.getComponents());
        if (null != cancel) {
            cancel.setText(ResourceManager.getString("COMMON.TXT.CANCEL"));
            if (!(this.getUI() instanceof UnifyFileChooserUI)) {
                cancel.setMnemonic('C');
            }
            cancel.setName("IsmFileChooser_Cancel_Button");
            UCD.formatMnemonicDisplay(cancel);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommonUtil.removeComponent(IsmFileChooser.this);
                }
            });
        }
        this.setFileNameText(this.getComponents());
    }

    private void approveButtonPerformed() {
        File file;
        this.filenametext.requestFocus();
        if (!this.isDirectorySelected() && this.filenametext.getText().trim().equals("")) {
            DialogUtils.showErrorDialog(this.parentDialog, ResourceManager.getString("FILE_NAEM_TOO_LONG"));
            return;
        }
        this.checkIfFolderValid();
        String name = this.filenametext.getText();
        if (1 == this.getDialogType() && 0 == this.getFileSelectionMode() && (file = new File(FilePathUtils.filterPath(name))).exists() && file.isDirectory()) {
            this.filenametext.setText(name + File.separator + "test.tmp");
            this.isNeedClean = true;
        }
    }

    private void checkIfFolderValid() {
        if (1 == this.getDialogType() && 1 == this.getFileSelectionMode() && new File(FilePathUtils.filterPath(this.filenametext.getText().trim())).isFile()) {
            DialogUtils.showErrorDialog(this.parentDialog, ResourceManager.getString("folder.chooser.invalid"));
            throw new EncapsulatedRuntimeException("Folder choose not valid!,hei hei.");
        }
    }

    public JButton getApproveButton() {
        if (this.getUI() instanceof UnifyFileChooserUI) {
            return ((UnifyFileChooserUI)this.getUI()).getApproveButton(this);
        }
        if (this.getUI() instanceof IsmFileChooserUI) {
            return ((IsmFileChooserUI)this.getUI()).getApproveButton(this);
        }
        return null;
    }

    public JButton getCancelButton(Component[] allComponents) {
        Component[] components = this.approveButton.getParent().getComponents();
        if (components.length > 1 && components[1] instanceof JButton) {
            return (JButton)components[1];
        }
        return null;
    }

    @Override
    protected JDialog createDialog(Component parent) {
        this.parentDialog = super.createDialog(parent);
        this.parentDialog.setName("IsmFileChooser_Dialog");
        this.parentDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                CommonUtil.removeComponent(IsmFileChooser.this);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                super.windowClosed(windowEvent);
                CommonUtil.removeComponent(IsmFileChooser.this);
            }
        });
        CommonUtil.addComponent(this, parent);
        return this.parentDialog;
    }

    public boolean isDirectorySelected() {
        if (this.getUI() instanceof IsmFileChooserUI) {
            return ((IsmFileChooserUI)this.getUI()).isDirectorySelected();
        }
        return false;
    }

    private void setFileNameText(Component[] allComponents) {
        block0: for (Component com : allComponents) {
            Component[] allcomp;
            if (!(com instanceof JPanel)) continue;
            for (Component c : allcomp = ((JComponent)com).getComponents()) {
                if (c instanceof JTextField) {
                    this.filenametext = (JTextField)c;
                    this.filenametext.setName("IsmFileChooser_FileName_Txt");
                    this.filenametext.addFocusListener(new FileNameTextFocusListener());
                    this.filenametext.setDocument(new FileChooserDocument());
                    this.filenametext.getDocument().addDocumentListener(new FileNameTextDocumentListener());
                    continue block0;
                }
                this.setFileNameText(allcomp);
            }
        }
    }

    private String changeFileNameText(DocumentEvent documentEvent) {
        if (!this.changefilename) {
            return this.filename;
        }
        String txt = "";
        try {
            this.filename = txt = documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength());
        }
        catch (BadLocationException e1) {
            LOGGER.error("", (Throwable)e1);
        }
        return this.filename;
    }

    public boolean checkFileNameLenth(String fileNames) {
        int lenth;
        String actualFileNames = fileNames;
        if (actualFileNames.contains(".")) {
            int lastPoint = actualFileNames.lastIndexOf(".");
            actualFileNames = actualFileNames.substring(0, lastPoint);
        }
        return StringUtils.isNotEmpty((CharSequence)actualFileNames) && maxLenth >= (lenth = actualFileNames.length());
    }

    public String getFileName(String fileName, String type) {
        if (StringUtils.isNotEmpty((CharSequence)fileName)) {
            if (StringUtils.isEmpty((CharSequence)type)) {
                return fileName;
            }
            Locale locale = ResourceManager.getLocale();
            if (fileName.toLowerCase(locale).endsWith('.' + type.toLowerCase(locale))) {
                return fileName;
            }
            return fileName + '.' + type.toLowerCase(locale);
        }
        return "";
    }

    public boolean existedFileName(String dir, String fileName) {
        return CommonUtil.isExistedFile(dir, fileName);
    }

    @Override
    public void approveSelection() {
        if (this.preCheck()) {
            return;
        }
        this.saveDefaultDir();
        File[] aFiles = null;
        aFiles = this.isMultiSelectionEnabled() ? this.getSelectedFiles() : new File[]{this.getSelectedFile()};
        for (File aFile : aFiles) {
            if (!this.dealOneFile(aFile)) continue;
            return;
        }
    }

    private boolean dealOneFile(File aFile) {
        String fileName = aFile.getName();
        String tmp = FilePathUtils.getCanonicalPath(aFile);
        String dir = tmp.substring(0, tmp.lastIndexOf(fileName));
        if (!this.checkFileNameLenth(aFile.getName())) {
            this.filenametext.setText(this.filename);
            DialogUtils.showErrorDialog(this.parentDialog, ResourceManager.getString("FILE_NAEM_TOO_LONG"));
            return true;
        }
        if (this.isWindows() && (fileName.endsWith(":") || fileName.endsWith(File.separator))) {
            super.approveSelection();
            if (null != this.parentDialog) {
                CommonUtil.removeComponent(this);
            }
            return true;
        }
        if (!this.isValidFileName(aFile.getName())) {
            return true;
        }
        if (this.degradeApproveSelection1(dir, aFile)) {
            return true;
        }
        return this.degradeApproveSelection2(dir, aFile);
    }

    private boolean preCheck() {
        if (this.isNeedClean) {
            this.filenametext.setText("");
            this.isNeedClean = false;
            return true;
        }
        if (1 == this.getFileSelectionMode()) {
            super.approveSelection();
            if (null != this.parentDialog) {
                CommonUtil.removeComponent(this);
            }
            return true;
        }
        if (this.filename.contains("\\\\")) {
            this.filenametext.setText(this.filename);
            DialogUtils.showErrorDialog(this.parentDialog, ResourceManager.getString("FILE_PATH_INVALID") + this.filename);
            return true;
        }
        if (this.filename.contains("..")) {
            this.filenametext.setText(this.filename);
            DialogUtils.showErrorDialog(this.parentDialog, ResourceManager.getString("FILE_PATH_INVALID") + this.filename);
            return true;
        }
        return false;
    }

    private boolean degradeApproveSelection1(String dir, File aFile) {
        String fullnoblank = aFile.getAbsolutePath().replace(" ", "");
        if (this.filename.trim().contains(File.separator + File.separator)) {
            this.filenametext.setText(this.filename);
            DialogUtils.showErrorDialog(this.parentDialog, ResourceManager.getString("FILE_PATH_INVALID") + this.filename);
            return true;
        }
        if (this.filename.contains(File.separator) && !this.filename.endsWith(File.separator)) {
            String currentdir = this.filename.substring(0, this.filename.lastIndexOf(File.separator));
            String fulldir = fullnoblank.substring(0, fullnoblank.lastIndexOf(File.separator));
            File file = new File(currentdir);
            File f1 = new File(fulldir);
            if (fullnoblank.contains("\\\\")) {
                this.filenametext.setText(this.filename);
                DialogUtils.showErrorDialog(this.parentDialog, ResourceManager.getString("FILE_PATH_INVALID") + this.filename);
                return true;
            }
            if (!file.isDirectory() && !f1.isDirectory()) {
                this.filenametext.setText(this.filename);
                DialogUtils.showErrorDialog(this.parentDialog, ResourceManager.getString("FILE_PATH_INVALID") + this.filename);
                return true;
            }
        }
        return false;
    }

    public boolean canCreateFile(String dir) throws Throwable {
        boolean success;
        File file = new File(dir + "/test.tmp");
        boolean flag = file.createNewFile();
        if (flag && !(success = file.delete())) {
            LOGGER.error("Create File test.tmp error.");
        }
        return flag;
    }

    private void saveDefaultDir() {
        File retFile = super.getSelectedFile();
        if (null == retFile) {
            return;
        }
        if (retFile.isDirectory()) {
            IsmFileChooser.updateStaticDftDir(retFile);
        } else if (retFile.isFile()) {
            defaultDir = retFile.getParent();
        } else {
            IsmFileChooser.updateStaticDftDir(retFile);
        }
    }

    private static void updateStaticDftDir(File retFile) {
        defaultDir = FilePathUtils.getCanonicalPath(retFile);
    }

    private boolean isValidFileName(String fileName) {
        boolean isValid = false;
        isValid = this.isWindows() ? fileName.matches(INVALID_FILENAME_CHAR_REGEX_ON_WINDOWS) : fileName.matches(INVALID_FILENAME_CHAR_REGEX_ON_LINUX);
        if (isValid) {
            return true;
        }
        this.filenametext.setText(this.filename);
        String massage = "";
        massage = this.isWindows() ? ResourceManager.getString("INVALID_WINDOWS_FILE_NAME") : ResourceManager.getString("INVALID_LINUX_FILE_NAME");
        DialogUtils.showErrorDialog(this.parentDialog, massage);
        return false;
    }

    public void setDefaultFileName(String defaultFileName) {
        this.filenametext.setText(defaultFileName);
    }

    public Boolean withFileType(String fileName) {
        String[] fileTypes = this.getSelectedFileType();
        if (fileTypes.length == 0) {
            return true;
        }
        for (String fileType : fileTypes) {
            if (fileType == null || "".equals(fileType)) {
                return true;
            }
            if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(fileType.toLowerCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    private boolean degradeApproveSelection2(String dir, File aFile) {
        WarningDialog warningDalog;
        String fileName = aFile.getName();
        boolean exist = this.existedFileName(dir, fileName);
        boolean withFileType = this.withFileType(fileName);
        if (!withFileType) {
            exist = this.existedFileName(dir, fileName + '.' + this.getSelectedFileType()[0]);
        }
        if (dir.toLowerCase(Locale.getDefault()).contains(this.networkPath)) {
            exist = false;
        }
        if (this.getDialogType() == 1 && exist && (warningDalog = DialogUtils.createWarningDialog(this.parentDialog, ResourceManager.getString("FILE_NAEM_EXISTED"))).getValue() != 0) {
            this.filenametext.setText(this.filename);
            return true;
        }
        if (!(this.getDialogType() != 0 || this.existedFileName(dir, fileName) && (withFileType || aFile.isDirectory()))) {
            this.filenametext.setText(this.filename);
            DialogUtils.showErrorDialog(this.parentDialog, ResourceManager.getString("FILE_PATH_INVALID") + this.filename);
            return true;
        }
        if (this.getDialogType() == 1) {
            boolean bCanCreateFile = false;
            try {
                bCanCreateFile = this.canCreateFile(dir);
            }
            catch (Throwable t) {
                this.filenametext.setText(this.filename);
                DialogUtils.showErrorDialog(this.parentDialog, ResourceManager.getString("FILE_PATH_ERROR"));
                return true;
            }
            if (!bCanCreateFile) {
                this.filenametext.setText(this.filename);
                DialogUtils.showErrorDialog(this.parentDialog, ResourceManager.getString("FILE_PATH_NOT_ACCESS") + this.filename);
                return true;
            }
        }
        super.approveSelection();
        if (null != this.parentDialog) {
            CommonUtil.removeComponent(this);
        }
        return false;
    }

    private boolean isWindows() {
        boolean isWin32 = File.separatorChar == '\\';
        return isWin32;
    }

    public void addFileFilter(String[] extentens, String desc) {
        this.addChoosableFileFilter(new IsmFileFilter(extentens, desc));
    }

    public void setFilenametext(String filenametext) {
        this.filenametext.setText(filenametext);
    }

    public String[] getSelectedFileType() {
        String[] filetype = new String[]{""};
        FileFilter filter = this.getFileFilter();
        if (null != filter && filter instanceof IsmFileFilter) {
            String[] type = ((IsmFileFilter)this.getFileFilter()).getType();
            if (null == type) {
                throw new NullPointerException();
            }
            if (type.length > 0) {
                filetype = type;
            }
        }
        return filetype;
    }

    public static int getMaxLength() {
        return maxLenth;
    }

    public String getDefaultFileName(String deviceID, FileType fileType) {
        StringBuffer defaultFileName = new StringBuffer();
        defaultFileName.append(deviceID);
        defaultFileName.append('_');
        if (fileType == FileType.CONF) {
            defaultFileName.append((Object)FileType.CONF);
        } else if (fileType == FileType.RUNNING) {
            defaultFileName.append((Object)FileType.RUNNING);
        } else if (fileType == FileType.LICENSE) {
            defaultFileName.append((Object)FileType.LICENSE);
        }
        return defaultFileName.toString();
    }

    public void addDirChangeListener(int fileSelectionMode) {
        if (fileSelectionMode != 0) {
            return;
        }
        this.addPropertyChangeListener(evt -> {
            if ("directoryChanged".equals(evt.getPropertyName())) {
                this.setFilenametext("");
            }
        });
    }

    static {
        maxLenth = 200;
    }

    public static enum FileType {
        CONF,
        RUNNING,
        LICENSE,
        COLLECTION_INFO;

    }

    private class FileChooserDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private FileChooserDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet attributeSet) throws BadLocationException {
            if (!this.checkStr(str)) {
                return;
            }
            super.insertString(offs, str, attributeSet);
        }

        private boolean checkStr(String str) {
            if (str.contains("*") || str.contains("?") || str.contains("<") || str.contains(">") || str.contains("|")) {
                return false;
            }
            Locale locale = ResourceManager.getLocale();
            return !(IsmFileChooser.this.os.toLowerCase(locale).contains("window") ? str.contains("/") : str.contains("\\"));
        }
    }

    static class IsmFileFilter
    extends FileFilter {
        private String[] extensions;
        private String description;

        public IsmFileFilter(String ext) {
            this(new String[]{ext}, null);
        }

        public IsmFileFilter(String[] exts, String descr) {
            this.extensions = new String[exts.length];
            for (int i = exts.length - 1; i >= 0; --i) {
                this.extensions[i] = exts[i].startsWith(".") ? exts[i].substring(1, exts[i].length()) : (exts[i].startsWith("*.") ? exts[i].substring(2, exts[i].length()) : exts[i]);
            }
            this.description = descr == null ? exts[0] + " files" : descr;
        }

        public String[] getType() {
            return null == this.extensions ? null : (String[])this.extensions.clone();
        }

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            if (this.extensions == null || this.extensions.length == 0) {
                return true;
            }
            if (FileUtils.isFileNameInvalid(file)) {
                return false;
            }
            String name = file.getName().toLowerCase(Locale.ENGLISH);
            for (int i = this.extensions.length - 1; i >= 0; --i) {
                if ("".equals(this.extensions[i]) || this.extensions[i] == null) {
                    return true;
                }
                String exts = this.extensions[i].toLowerCase(Locale.ENGLISH);
                if (!name.endsWith("." + exts)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private class FileNameTextDocumentListener
    implements DocumentListener {
        private FileNameTextDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            IsmFileChooser.this.changeFileNameText(documentEvent);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            IsmFileChooser.this.changefilename = true;
            IsmFileChooser.this.changeFileNameText(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            IsmFileChooser.this.changeFileNameText(documentEvent);
        }
    }

    private class FileNameTextFocusListener
    implements FocusListener {
        private FileNameTextFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            IsmFileChooser.this.changefilename = true;
        }

        @Override
        public void focusLost(FocusEvent e) {
            IsmFileChooser.this.changefilename = false;
        }
    }
}

