/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IsmScrollPanel
extends JPanel {
    private static final long serialVersionUID = -8884321810383295762L;
    private JComponent selectionComponent = null;
    private JButton leftButton;
    private JButton rightButton;
    private JScrollPane scrollPanel = new JScrollPane();
    private JPanel contentPanel = new JPanel();
    private Map<Object, ListSelectionListener> componentListeners = new HashMap<Object, ListSelectionListener>(0);
    private List<ListSelectionListener> ls = new ArrayList<ListSelectionListener>(0);
    private List<JComponent> components = new ArrayList<JComponent>(0);

    public IsmScrollPanel() {
        this.initComponent();
        this.doUILayout();
        this.initListener();
        this.updateButtonStatus();
    }

    public void addCompoenntToViewPort(JComponent compoent, ListSelectionListener selectionListener) {
        if (this.components.contains(compoent)) {
            return;
        }
        this.componentListeners.put(compoent, selectionListener);
        this.components.add(compoent);
        this.contentPanel.add(compoent);
        compoent.addMouseListener(new MouseListener());
        this.updateButtonStatus();
    }

    public void addSelectionListener(ListSelectionListener selectionListener) {
        this.ls.add(selectionListener);
    }

    public void removeCompoenntFromViewPort(JComponent compoent) {
        this.contentPanel.remove(compoent);
        this.components.remove(compoent);
        this.componentListeners.remove(compoent);
        if (compoent.equals(this.selectionComponent)) {
            this.selectionComponent = null;
        }
    }

    public void removeAllFromViewPort() {
        for (JComponent compoent : this.components) {
            this.contentPanel.remove(compoent);
        }
        this.components.clear();
        this.componentListeners.clear();
        this.selectionComponent = null;
    }

    public JComponent getSelectionComponent() {
        if (null == this.selectionComponent && !this.components.isEmpty()) {
            JComponent component = this.components.get(0);
            this.setSelectionComponent(component);
        }
        return this.selectionComponent;
    }

    private void doUILayout() {
        Box box = Box.createHorizontalBox();
        box.add(this.leftButton);
        box.add(this.scrollPanel);
        box.add(this.rightButton);
        this.setLayout(new BorderLayout());
        this.add((Component)box, "Center");
    }

    private void initComponent() {
        ImageIcon leftIcon = ResourceManager.getImage("left.gif");
        Dimension size = new Dimension(leftIcon.getIconWidth(), leftIcon.getIconHeight() * 5);
        this.leftButton = new JButton(leftIcon);
        UCD.setJComponentSize(this.leftButton, size);
        ImageIcon rightIcon = ResourceManager.getImage("right.gif");
        this.rightButton = new JButton(rightIcon);
        UCD.setJComponentSize(this.rightButton, size);
        this.scrollPanel.setViewportView(this.contentPanel);
        this.scrollPanel.setVerticalScrollBarPolicy(21);
        this.scrollPanel.setHorizontalScrollBarPolicy(31);
        this.contentPanel.setLayout(new FlowLayout(0));
    }

    private void initListener() {
        this.leftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar skrBar = IsmScrollPanel.this.scrollPanel.getHorizontalScrollBar();
                int currentValue = skrBar.getValue();
                int value = currentValue - IsmScrollPanel.this.getOnceScrollWidth();
                if (value <= skrBar.getMinimum()) {
                    value = skrBar.getMinimum();
                }
                skrBar.setValue(value);
                IsmScrollPanel.this.updateButtonStatus();
            }
        });
        this.rightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JScrollBar scrBar = IsmScrollPanel.this.scrollPanel.getHorizontalScrollBar();
                int currentValue = scrBar.getValue();
                int value = currentValue + IsmScrollPanel.this.getOnceScrollWidth();
                if (value >= scrBar.getMaximum() - scrBar.getVisibleAmount()) {
                    value = scrBar.getMaximum() - scrBar.getVisibleAmount();
                }
                scrBar.setValue(value);
                IsmScrollPanel.this.updateButtonStatus();
            }
        });
    }

    private void updateButtonStatus() {
        this.leftButton.setEnabled(true);
        this.rightButton.setEnabled(true);
        JScrollBar scrollBar = this.scrollPanel.getHorizontalScrollBar();
        if (scrollBar.getValue() == scrollBar.getMinimum()) {
            this.leftButton.setEnabled(false);
        }
        if (scrollBar.getValue() >= scrollBar.getMaximum() - scrollBar.getVisibleAmount()) {
            this.rightButton.setEnabled(false);
        }
    }

    private int getOnceScrollWidth() {
        JScrollBar horizontalScrollBar = this.scrollPanel.getHorizontalScrollBar();
        int maxValue = horizontalScrollBar.getMaximum();
        int minValue = horizontalScrollBar.getMinimum();
        if (!this.components.isEmpty()) {
            return (maxValue - minValue) / this.components.size();
        }
        return 0;
    }

    public void setSelectionComponent(JComponent component) {
        if (!this.components.contains(component)) {
            return;
        }
        if (!component.equals(this.selectionComponent)) {
            this.selectionComponent = component;
            ArrayList<ListSelectionListener> listeners = new ArrayList<ListSelectionListener>(0);
            listeners.addAll(this.componentListeners.values());
            listeners.addAll(this.ls);
            ListSelectionEvent event = null;
            for (ListSelectionListener listener : listeners) {
                event = new ListSelectionEvent(this.selectionComponent, 0, this.components.size(), false);
                listener.valueChanged(event);
            }
        }
    }

    public List<JComponent> getAllComponent() {
        ArrayList<JComponent> result = new ArrayList<JComponent>(0);
        result.addAll(this.components);
        return result;
    }

    public class MouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JComponent component = (JComponent)mouseEvent.getSource();
            IsmScrollPanel.this.setSelectionComponent(component);
            IsmScrollPanel.this.paintAll(IsmScrollPanel.this.getGraphics());
        }
    }
}

