/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.calendarpicker;

import com.huawei.ism.ui.swing.calendarpicker.LabelButton;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.text.IsmTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Calendar;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

class TimePickerPane
extends JPanel {
    private static final String HOUR_NUM_REGEX = "[0-9][0-9]*";
    private static final int BOTTOM = 0;
    private static final int HOUR_TOP = 23;
    private static final int MINUTE_TOP = 59;
    private static final int LENGTHLIMIT = 2;
    private static final int COLUMNS = 2;
    private static final long serialVersionUID = 1855874500524007742L;
    private IsmTextField hourTextfield = null;
    private IsmTextField minuteTextField = null;
    private IsmTextField secondTextField = null;
    private LabelButton okButton = null;
    private boolean showTimeField = false;
    private JPanel jp;

    public TimePickerPane(Calendar cal) {
        this.doLayoutUI(cal);
    }

    private void doLayoutUI(Calendar cal) {
        this.createComponents();
        this.layoutComponents(cal);
    }

    private void createComponents() {
        this.hourTextfield = IsmTextField.getNumberTextField(HOUR_NUM_REGEX, 0L, 23L, 2, 2, true);
        this.minuteTextField = IsmTextField.getNumberTextField(HOUR_NUM_REGEX, 0L, 59L, 2, 2, true);
        this.secondTextField = IsmTextField.getNumberTextField(HOUR_NUM_REGEX, 0L, 59L, 2, 2, true);
        this.secondTextField = IsmTextField.getNumberTextField(HOUR_NUM_REGEX, 0L, 59L, 2, 2, true);
        this.okButton = new LabelButton("OK  ", 2);
        this.okButton.setDefualtBackground(Color.WHITE);
        this.okButton.setOverBackground(Color.WHITE);
        this.okButton.setOverForeground(UIManager.getColor("IsmButton.defaultBorderColor"));
    }

    private void layoutComponents(Calendar cal) {
        this.resetLayout(cal, false);
        this.setLayout(new BorderLayout());
        this.jp = new JPanel();
        this.jp.add(this.hourTextfield);
        JLabel jLabel = new JLabel(":");
        jLabel.setFont(IsmFontFactory.getDialogBold());
        this.jp.add(jLabel);
        this.jp.add(this.minuteTextField);
        jLabel = new JLabel(":");
        jLabel.setFont(IsmFontFactory.getDialogBold());
        this.jp.add(jLabel);
        this.jp.add(this.secondTextField);
        if (this.showTimeField) {
            this.add((Component)this.jp, "Center");
        }
        this.add((Component)this.okButton, "East");
        this.setPreferredSize(new Dimension(200, 32));
    }

    public void resetLayout(Calendar cal, boolean isShowTimeField) {
        if (this.showTimeField) {
            this.remove(this.jp);
        }
        this.showTimeField = isShowTimeField;
        int hour = cal.get(11);
        this.hourTextfield.setText(this.valueOf(hour));
        int minute = cal.get(12);
        this.minuteTextField.setText(this.valueOf(minute));
        int second = cal.get(13);
        this.secondTextField.setText(this.valueOf(second));
        if (this.showTimeField) {
            this.add((Component)this.jp, "Center");
        }
    }

    private String valueOf(int number) {
        if (number < 10) {
            return "0" + number;
        }
        return String.valueOf(number);
    }

    public LabelButton getOkButton() {
        return this.okButton;
    }

    public int getHour() {
        String hourString = this.hourTextfield.getText();
        if (null == hourString || "".equals(hourString)) {
            return 0;
        }
        return Integer.parseInt(hourString);
    }

    public int getMinute() {
        String minuteString = this.minuteTextField.getText();
        if (null == minuteString || "".equals(minuteString)) {
            return 0;
        }
        return Integer.parseInt(minuteString);
    }

    public int getSecond() {
        String secondString = this.secondTextField.getText();
        if (null == secondString || "".equals(secondString)) {
            return 0;
        }
        return Integer.parseInt(secondString);
    }
}

