/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.dialog.DateChooserPanel;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class DateChooserDialog
extends JDialog {
    private static final int BUTTON_LEFT_MARGIN = 252;
    private static final int BUTTON_GAP = 4;
    private static final long serialVersionUID = 1L;
    private static final String SET_NAME_PREFIX = "ISMV1R2_framework_uiComponent";
    private Date retDate;
    private boolean isOkClicked = false;
    private DateChooserPanel calendarChooserPanel;
    private Date initDate;
    private String deviceId = null;
    private JButton okButton;
    private JButton cancelButton;
    private int model = 4;

    public DateChooserDialog(JDialog owner, String title) {
        this(owner, title, null, null);
        this.setTitle(ResourceManager.getString("DATECHOOSER_TITLE"));
    }

    public DateChooserDialog(JDialog owner, String title, String deviceId, Date date) {
        super(owner, title, true);
        this.deviceId = deviceId;
        this.setName("ISMV1R2_framework_uiComponent_DateChooserDialog");
        this.retDate = date == null ? null : new Date(date.getTime());
        this.initDate = this.getDeviceDate();
        this.initComponents();
        this.setResizable(false);
        this.pack();
        SwingUtil.putScreenCenter(this);
        this.setDefaultCloseOperation(2);
        this.setTitle(ResourceManager.getString("DATECHOOSER_TITLE"));
    }

    public DateChooserDialog(JDialog owner, String title, String deviceId, Date date, int model) {
        super(owner, title, true);
        this.deviceId = deviceId;
        this.model = model;
        this.setName("ISMV1R2_framework_uiComponent_DateChooserDialog");
        this.retDate = date == null ? null : new Date(date.getTime());
        this.initDate = this.getDeviceDate();
        this.initComponents();
        this.setResizable(false);
        this.pack();
        SwingUtil.putScreenCenter(this);
        this.setDefaultCloseOperation(2);
        this.setTitle(ResourceManager.getString("DATECHOOSER_TITLE"));
    }

    public Date getDeviceDate() {
        if (null == this.retDate) {
            return null;
        }
        return new Date(this.retDate.getTime());
    }

    public void setDate(Date date) {
        this.initDate = null == date ? null : (Date)date.clone();
        this.initComponents();
    }

    public Date getDate() {
        if (this.isOkClicked) {
            return this.calendarChooserPanel.getCalendar().getTime();
        }
        if (null == this.initDate) {
            return null;
        }
        return (Date)this.initDate.clone();
    }

    public Date getDate2() {
        if (this.isOkClicked) {
            return this.calendarChooserPanel.getCalendar().getTime();
        }
        return null;
    }

    private void initComponents() {
        JPanel contentPanel = new JPanel();
        this.initBasicLayout(contentPanel);
        this.initBtnsAndListener();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setName("ISMV1R2_framework_uiComponent_buttonPanel");
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(Box.createHorizontalStrut(242));
        buttonPanel.add(this.okButton);
        buttonPanel.add(Box.createHorizontalStrut(4));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(Box.createHorizontalStrut(12));
        contentPanel.add(Box.createVerticalStrut(4));
        contentPanel.add(buttonPanel);
        contentPanel.add(Box.createVerticalStrut(8));
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void initBtnsAndListener() {
        String ok = ResourceManager.getString("DATECHOOSER_OK");
        this.okButton = new JButton(ok);
        this.okButton.setName("ISMV1R2_framework_uiComponent_okButton");
        this.okButton.setPreferredSize(new Dimension(80, UCD.BUTTON_HEIGHT));
        this.okButton.setMaximumSize(new Dimension(80, UCD.BUTTON_HEIGHT));
        this.okButton.setMinimumSize(new Dimension(80, UCD.BUTTON_HEIGHT));
        this.okButton.setMnemonic(79);
        UCD.formatMnemonicDisplay(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooserDialog.this.isOkClicked = true;
                DateChooserDialog.this.dispose();
            }
        });
        this.cancelButton = new JButton(ResourceManager.getString("DATECHOOSER_CANCEL"));
        this.cancelButton.setName("ISMV1R2_framework_uiComponent_cancelButton");
        this.cancelButton.setPreferredSize(new Dimension(80, UCD.BUTTON_HEIGHT));
        this.cancelButton.setMaximumSize(new Dimension(80, UCD.BUTTON_HEIGHT));
        this.cancelButton.setMinimumSize(new Dimension(80, UCD.BUTTON_HEIGHT));
        this.cancelButton.setMnemonic(67);
        UCD.formatMnemonicDisplay(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateChooserDialog.this.isOkClicked = false;
                DateChooserDialog.this.dispose();
            }
        });
    }

    private void initBasicLayout(JPanel contentPanel) {
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.setName("ISMV1R2_framework_uiComponent_contentPanel");
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(contentPanel);
        Calendar calendar = Calendar.getInstance();
        if (null != this.deviceId) {
            calendar.setTimeZone(CommonUtil.getLauncher(this.deviceId).getDeviceTimeZone());
        }
        if (null != this.initDate) {
            calendar.setTime(this.initDate);
        }
        this.calendarChooserPanel = null != this.deviceId ? new DateChooserPanel(calendar, this.deviceId, CommonUtil.getLauncher(this.deviceId).getDeviceTimeZone()) : new DateChooserPanel(calendar, null, null, this.model);
        this.calendarChooserPanel.setName("ISMV1R2_framework_uiComponent_calendarChooserPanel");
        Box chooserBox = Box.createHorizontalBox();
        chooserBox.add(Box.createHorizontalStrut(8));
        chooserBox.add(this.calendarChooserPanel);
        chooserBox.add(Box.createHorizontalStrut(8));
        contentPanel.add(chooserBox);
    }

    public DateChooserPanel getDataChooserPanel() {
        return this.calendarChooserPanel;
    }

    @Override
    public final void dispose() {
        Window window = this.getOwner();
        super.dispose();
        SwingUtil.postEvent(window);
    }
}

