/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.autotest.AutoProcessListener;
import com.huawei.ism.autotest.AutoProcessObserver;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.autotest.IAutoProcess;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class InformationDialog
extends JDialog
implements DialogsConstants,
IAutoProcess {
    private static final int GRIDX_0 = 0;
    private static final long serialVersionUID = 6988801402500983775L;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton confirmButton;
    private JLabel imageLabel;
    private int value = -1;
    private JPanel displayPrompt;
    private List<AutoProcessObserver> observers = new ArrayList<AutoProcessObserver>();

    protected InformationDialog(Frame parent, String title, String newMessage, String newImageIcon) {
        super(parent);
        this.setName("ISMV1R2_framework_uiComponent_InformationDialog");
        this.toFront();
        this.init(title, newMessage, newImageIcon, null);
        SwingUtil.setCloseWhenEscKeyPressed(this);
    }

    public InformationDialog(Frame parent, String title, String newMessage) {
        this(parent, title, newMessage, "Information.png");
    }

    protected InformationDialog(JDialog parent, String title, String newMessage, String newImageIcon) {
        super(parent);
        this.setName("ISMV1R2_framework_uiComponent_InformationDialog");
        this.toFront();
        this.init(title, newMessage, newImageIcon, null);
        SwingUtil.setCloseWhenEscKeyPressed(this);
    }

    protected InformationDialog(JDialog parent, String title, String newMessage) {
        this(parent, title, newMessage, "Information.png");
    }

    public InformationDialog(JDialog parent, String newMessage) {
        super(parent);
        this.setName("ISMV1R2_framework_uiComponent_InformationDialog");
        this.toFront();
        this.setDialogTitle(newMessage, null);
        SwingUtil.setCloseWhenEscKeyPressed(this);
        SwingUtil.putParentCenter(this, parent);
    }

    public InformationDialog(JDialog parent, String newMessage, Dimension areaSize) {
        super(parent);
        this.setName("ISMV1R2_framework_uiComponent_InformationDialog");
        this.toFront();
        this.setDialogTitle(newMessage, areaSize);
        SwingUtil.setCloseWhenEscKeyPressed(this);
        SwingUtil.putParentCenter(this, parent);
    }

    public InformationDialog(JDialog parent, String newMessage, boolean isSuccess) {
        super(parent);
        this.setName("ISMV1R2_framework_uiComponent_InformationDialog");
        this.toFront();
        String strIcon = isSuccess ? "success.png" : "error.png";
        String strTitle = isSuccess ? ResourceManager.getString("SUCCESS_DIALOG_TITLE") : ResourceManager.getString("ERROR_DIALOG_TITLE");
        this.init(strTitle, newMessage, strIcon, null);
        SwingUtil.setCloseWhenEscKeyPressed(this);
    }

    public InformationDialog(Frame parent, String newMessage) {
        super(parent);
        this.setName("ISMV1R2_framework_uiComponent_InformationDialog");
        this.toFront();
        this.setDialogTitle(newMessage, null);
        SwingUtil.setCloseWhenEscKeyPressed(this);
    }

    public InformationDialog(Frame parent, String newMessage, JComponent hyperLink) {
        super(parent);
        this.setName("ISMV1R2_framework_uiComponent_InformationDialog");
        this.toFront();
        this.setDialogTitle(newMessage, null);
        IsmTextArea textArea = Arrays.stream(this.displayPrompt.getComponents()).filter(component -> component instanceof IsmTextArea).map(component -> (IsmTextArea)component).findFirst().orElse(null);
        if (Objects.isNull(textArea)) {
            SwingUtil.setCloseWhenEscKeyPressed(this);
            return;
        }
        this.displayPrompt.remove(textArea);
        this.displayPrompt.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 3, 10, 0);
        constraints.anchor = 17;
        constraints.gridy = 0;
        this.displayPrompt.add((Component)textArea, constraints);
        constraints.gridy = 1;
        this.displayPrompt.add((Component)hyperLink, constraints);
        SwingUtil.setCloseWhenEscKeyPressed(this);
    }

    public InformationDialog(Frame parent) {
        super(parent);
        this.setName("ISMV1R2_framework_uiComponent_InformationDialog");
        this.init(ResourceManager.getString("SUCCESS_DIALOG_TITLE"), ResourceManager.getString("INFORMATION_SUCCESS_MSG"), "success.png", null);
        this.toFront();
    }

    public InformationDialog(JDialog dialog) {
        super(dialog);
        this.setName("ISMV1R2_framework_uiComponent_InformationDialog");
        this.init(ResourceManager.getString("SUCCESS_DIALOG_TITLE"), ResourceManager.getString("INFORMATION_SUCCESS_MSG"), "success.png", null);
        this.toFront();
    }

    private void setDialogTitle(String newMessage, Dimension areaSize) {
        if (newMessage.equals(ResourceManager.getString("INFORMATION_SUCCESS_MSG"))) {
            this.init(ResourceManager.getString("SUCCESS_DIALOG_TITLE"), newMessage, "success.png", areaSize);
        } else {
            this.init(ResourceManager.getString("INFORMATION_DIALOG_TITLE"), newMessage, "Information.png", areaSize);
        }
    }

    protected void setErrorMessageContent(String error, List<String> suggestions) {
        if (this.isNullSuggestion(suggestions)) {
            return;
        }
        IsmTextArea reasonValue = this.createTextArea(error, null);
        reasonValue.setBorder(new EmptyBorder(1, 8, 0, 0));
        StringBuilder sb = new StringBuilder();
        sb.append(ResourceManager.getString("prop.error.suggestion") + (IsmPlafUtils.isChineseLocal() ? "\uff1a" : ": "));
        String sug = null;
        for (int i = 0; i < suggestions.size(); ++i) {
            sug = suggestions.get(i);
            if (suggestions.size() > 1) {
                sb.append(i + 1);
                sb.append('.');
            }
            sb.append(sug);
            sb.append("");
        }
        IsmTextArea suggestionValue = this.createTextArea(sb.toString(), null);
        suggestionValue.setBorder(new EmptyBorder(1, 8, 0, 0));
        Box componet = UCD.buildVBoxTop(5, UCD.buildHBoxLeft(0, reasonValue), UCD.buildHBoxLeft(0, suggestionValue));
        this.displayPrompt.removeAll();
        this.displayPrompt.add(componet);
        this.displayPrompt.validate();
        this.pack();
    }

    private boolean isNullSuggestion(List<String> suggestions) {
        if (null == suggestions || suggestions.isEmpty()) {
            return true;
        }
        String suggestion = suggestions.get(0);
        return ResourceManager.getString("prop.error.none").equals(suggestion) || CommonUtil.addFullStop(ResourceManager.getString("prop.error.none")).equals(suggestion);
    }

    protected void setDefaultButton() {
        boolean confirmButtonVisible = this.confirmButton.isVisible();
        boolean cancelButtonVisible = this.cancelButton.isVisible();
        if (!confirmButtonVisible && cancelButtonVisible) {
            this.getRootPane().setDefaultButton(this.cancelButton);
            this.cancelButton.requestFocus();
        } else {
            this.getRootPane().setDefaultButton(this.confirmButton);
            this.confirmButton.requestFocus();
        }
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public void processWindowEvent(WindowEvent ev) {
        switch (ev.getID()) {
            case 200: {
                this.cancelButton.requestFocus();
                break;
            }
            case 201: {
                this.dispose();
                break;
            }
        }
    }

    protected void initComponent() {
        this.setDefaultCloseOperation(2);
        JSeparator separator = new JSeparator();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            separator = new InfoSeparator();
        }
        JPanel displayPanel = UCD.createTransparentPane(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        displayPanel.add((Component)this.imageLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        displayPanel.add((Component)this.displayPrompt, gridBagConstraints);
        displayPanel.setBorder(new EmptyBorder(22, 20, 16, 12));
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.confirmButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.setBorder(UCD.createEmptyBorder());
        this.add((Component)displayPanel, "Center");
        this.add((Component)UCD.buildVerticalBox(null, 0, separator, this.buttonPanel), "South");
    }

    private void init(String title, String newMessage, String newImageIcon, Dimension areaSize) {
        super.setTitle(title == null ? ResourceManager.getString("WARNING_DIALOG_TITLE") : title);
        String actualNewImageIcon = newImageIcon == null ? "Information.png" : newImageIcon;
        this.buttonPanel = new JPanel();
        this.cancelButton = UCD.createButton(ResourceManager.getString("COMMON.TXT.CANCEL"), 'C');
        this.confirmButton = UCD.createButton(ResourceManager.getString("COMMON.TXT.CONFIRM"), 'O');
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.buttonPanel.setBackground(UIManager.getColor("IsmDialog.buttonBarBackground"));
        }
        this.imageLabel = new JLabel();
        this.displayPrompt = new JPanel();
        IsmTextArea area = this.createTextArea(newMessage, areaSize);
        this.displayPrompt.add(area);
        this.initComponent();
        this.initButtonEvent();
        ImageIcon imageIcon = ResourceManager.getImage(actualNewImageIcon);
        this.imageLabel.setIcon(imageIcon);
        this.setCompName();
        this.setBackground(LayoutConstants.BACKGROUND_COLOR);
        this.setResizable(false);
        this.setDefaultButton();
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.pack();
        SwingUtil.putParentCenter(this, this.getOwner());
        SwingUtil.setName(this);
    }

    private IsmTextArea createTextArea(String newMessage, Dimension areaSize) {
        IsmTextArea area = UCD.createTextArea(newMessage);
        if (null != areaSize) {
            area.setSize(areaSize);
            return area;
        }
        FontMetrics fontMetrics = area.getFontMetrics(area.getFont());
        int totalWidth = fontMetrics.stringWidth(newMessage);
        int columns = 25;
        int width = columns * area.getColumnWidth();
        area.setColumns(columns);
        int row = totalWidth / width;
        String[] splitStr = newMessage.split("\n");
        area.setRows(row + splitStr.length);
        return area;
    }

    private void cannelButtonAction(ActionEvent e) {
        this.value = 1;
        this.dispose();
    }

    private void confimButtonAction(ActionEvent e) {
        this.value = 0;
        this.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        if (Utils.isJunitTest()) {
            super.setVisible(false);
            this.value = 0;
        } else {
            super.setVisible(visible);
        }
    }

    private void initButtonEvent() {
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InformationDialog.this.confimButtonAction(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InformationDialog.this.cannelButtonAction(actionEvent);
            }
        });
        new AutoProcessObserver(this);
        this.addComponentListener(new AutoProcessListener(this));
    }

    public void addCancelButton() {
        this.buttonPanel.removeAll();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.confirmButton);
        this.buttonPanel.add(Box.createHorizontalStrut(10));
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(Box.createHorizontalGlue());
    }

    @Override
    public final void dispose() {
        Window window = this.getOwner();
        super.dispose();
        SwingUtil.postEvent(window);
    }

    @Override
    public void setLocationRelativeTo(Component comp) {
        if (comp != null && !comp.isShowing()) {
            this.setLocationRelativeTo(comp.getParent());
        } else {
            super.setLocationRelativeTo(comp);
        }
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setButtonPanel(JPanel buttonPanel) {
        this.buttonPanel = buttonPanel;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    public JButton getConfirmButton() {
        return this.confirmButton;
    }

    public void setConfirmButton(JButton confirmButton) {
        this.confirmButton = confirmButton;
    }

    private void setCompName() {
        this.cancelButton.setName("_Button_cancelButton");
        this.confirmButton.setName("_Button_confirmButton");
    }

    @Override
    public void onStepDialogDisplayed() {
        this.notifyObserver(AutoProcessStatus.SUCCESS);
    }

    @Override
    public void onStepFinished(AutoProcessStatus status) {
        this.confirmButton.doClick();
    }

    @Override
    public void addObserver(AutoProcessObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void notifyObserver(AutoProcessStatus status) {
        for (AutoProcessObserver observer : this.observers) {
            observer.processStatus(status);
        }
    }

    private static final class InfoSeparator
    extends JSeparator {
        private static final long serialVersionUID = -6149201948604054011L;

        private InfoSeparator() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(new Color(0xCECECE));
            graphics.drawLine(0, 0, this.getWidth(), 0);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(0, 1, this.getWidth(), 1);
        }
    }
}

