/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.URLLinkLabel;
import com.huawei.ism.ui.swing.dialog.LinkAction;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class LinkDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Dimension SIZE = new Dimension(350, 230);
    private static final int MSG_LENGHT = 30;
    private String url = "";
    private String desc = "";
    private JButton okBtn = UCD.createButton(ResourceManager.getString("COMMON.TXT.CONFIRM"), 'O');
    private URLLinkLabel urlLink;

    public LinkDialog(Window parent, String desc, String url) {
        super(parent);
        this.url = url;
        this.desc = desc;
        this.initUI();
        this.addListener();
    }

    private void addListener() {
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkDialog.this.dispose();
            }
        });
    }

    private void initUI() {
        this.setTitle(ResourceManager.getString("INFORMATION_DIALOG_TITLE"));
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.buildJComponent(), "North");
        panel.add((Component)UCD.buildHorizotalBox(null, Box.createHorizontalGlue(), this.okBtn, Box.createHorizontalGlue()), "South");
        JComponent com = UCD.buildHorizotalBox(UCD.createEmptyBorder(12), panel);
        this.add(com);
        this.setPreferredSize(SIZE);
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        this.setCompName();
        SwingUtil.putScreenCenter(this);
    }

    private JComponent buildJComponent() {
        JLabel iconLabel = new JLabel(ResourceManager.getImage("Information.png"));
        String urlStr = this.url;
        if (urlStr.length() > 30) {
            urlStr = urlStr.substring(0, 30) + "...";
        }
        this.urlLink = new URLLinkLabel(urlStr, this.url, new LinkAction(this.url));
        this.urlLink.setToolTipText(this.url);
        JComponent comp = UCD.buildVerticalBox(null, Box.createVerticalStrut(12), UCD.buildHBoxLeft(this.createTextArea()), UCD.buildHBoxLeft(this.urlLink), Box.createVerticalGlue());
        return UCD.buildVerticalBox(null, UCD.buildHBoxLeft(iconLabel, comp));
    }

    private JTextArea createTextArea() {
        JTextArea area = new JTextArea();
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setFocusable(false);
        area.setEditable(false);
        area.setOpaque(false);
        area.setBackground(UIManager.getColor("Panel.background"));
        area.setText(this.desc);
        return area;
    }

    private void setCompName() {
        this.okBtn.setName("_Button_okBtn");
        this.urlLink.setName("_Label_urlLink");
    }
}

