/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class MultiErrorYesOrNoDialog
extends IsmDialog
implements DialogsConstants {
    private int dialogValue = -1;
    private DefaultTableModel errorTableModel = null;
    private JButton cancelBtn;
    private JButton continueBtn;

    public MultiErrorYesOrNoDialog(Window parent, String dlgTitle, String infoMsg, String[] titles, String img) {
        super(parent);
        this.setTitle(dlgTitle);
        this.doLayoutPane(infoMsg, titles, img, 0, 0);
        this.initListenter();
        this.toFront();
        this.setCompName();
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setResizable(true);
        SwingUtil.setCloseWhenEscKeyPressed(this);
        this.setIconImage(ResourceManager.DEFAULT_ICON.getImage());
        this.getRootPane().setDefaultButton(this.cancelBtn);
        this.cancelBtn.requestFocus();
        this.pack();
        SwingUtil.putParentCenter(this, parent);
    }

    public MultiErrorYesOrNoDialog(Window parent, List<String> params, String[] titles, List<Integer> size) {
        super(parent);
        String dlgTitle = params.get(0);
        String infoMsg = params.get(1);
        String img = params.get(2);
        int width = size.get(0);
        int height = size.get(1);
        this.setTitle(dlgTitle);
        this.doLayoutPane(infoMsg, titles, img, width, height);
        this.initListenter();
        this.toFront();
        this.setCompName();
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setResizable(true);
        SwingUtil.setCloseWhenEscKeyPressed(this);
        this.setIconImage(ResourceManager.DEFAULT_ICON.getImage());
        this.getRootPane().setDefaultButton(this.cancelBtn);
        this.cancelBtn.requestFocus();
        this.pack();
        SwingUtil.putParentCenter(this, parent);
    }

    private void initListenter() {
        this.continueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiErrorYesOrNoDialog.this.dialogValue = 0;
                MultiErrorYesOrNoDialog.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiErrorYesOrNoDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MultiErrorYesOrNoDialog.this.dispose();
            }
        });
    }

    private void doLayoutPane(String errMsg, String[] titles, String img, int width, int height) {
        IsmTextArea contentArea = new IsmTextArea();
        contentArea.setText(errMsg);
        JLabel imgLabel = new JLabel();
        imgLabel.setIcon(ResourceManager.getImage(img));
        this.errorTableModel = new DefaultTableModel(titles, new int[0]);
        IsmTable errTable = new IsmTable(this.errorTableModel);
        TableScrollPane scrollPane = new TableScrollPane(errTable);
        if (width != 0 && height != 0) {
            scrollPane.setPreferredSize(new Dimension(width, height));
        } else if (ApplicationContext.getInstance().isEnglishEnv()) {
            scrollPane.setPreferredSize(new Dimension(320, 230));
        } else {
            scrollPane.setPreferredSize(new Dimension(350, 230));
        }
        JComponent imgBox = UCD.buildVerticalBox(null, imgLabel, Box.createVerticalGlue());
        JComponent descBox = UCD.buildVerticalBox(null, contentArea, Box.createVerticalGlue());
        JComponent topBox = UCD.buildHorizotalBox(null, imgBox, descBox);
        JPanel contentPane = new JPanel(new BorderLayout(10, 10));
        contentPane.add((Component)topBox, "North");
        contentPane.add((Component)scrollPane, "Center");
        contentPane.setBorder(new EmptyBorder(8, 8, 0, 8));
        this.getDialogContentPane().add(contentPane);
        this.cancelBtn = UCD.createButton(ResourceManager.getString("COMMON.TXT.CANCEL"), 'C');
        this.continueBtn = UCD.createButton(ResourceManager.getString("CONTINUE"), 'O');
        this.getSouthBox().add(this.continueBtn);
        this.getSouthBox().add(Box.createHorizontalStrut(10));
        this.getSouthBox().add(this.cancelBtn);
    }

    public int getValue() {
        return this.dialogValue;
    }

    public DefaultTableModel getTableModel() {
        return this.errorTableModel;
    }

    private void setCompName() {
        this.cancelBtn.setName("_Button_confirmButton");
    }

    public void switchContinueToConfirm() {
        this.continueBtn.setText(ResourceManager.getString("CONFIRM"));
        UCD.formatMnemonicDisplay(this.continueBtn);
    }
}

