/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class IsmMenuItemUI
extends BasicMenuItemUI {
    private static final int DEFAULT_TEXT_ICON_GAP = 8;

    public static ComponentUI createUI(JComponent c) {
        return new IsmMenuItemUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.menuItem.setOpaque(false);
        this.defaultTextIconGap = 8;
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.menuItem.setOpaque(true);
    }

    @Override
    protected void paintBackground(Graphics graphics, JMenuItem menuItem1, Color bgColor) {
        int menuWidth = menuItem1.getWidth();
        int menuHeight = menuItem1.getHeight();
        ButtonModel model = menuItem1.getModel();
        Insets margin1 = menuItem1.getMargin();
        if (model.isArmed() || menuItem1 instanceof JMenu && model.isSelected()) {
            IsmPlafUtils.fillSelectionBG(menuItem1, graphics, margin1.left, margin1.top, menuWidth - margin1.left - margin1.right, menuHeight - margin1.top - margin1.bottom, true);
            IsmPlafUtils.fillSelectionCover(menuItem1, graphics, margin1.left, margin1.top, menuWidth - margin1.left - margin1.right, menuHeight - margin1.top - margin1.bottom, true);
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new Handler();
    }

    private class Handler
    implements MouseInputListener {
        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!IsmMenuItemUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            Point point = mouseEvent.getPoint();
            if ((int)point.getX() >= 0 && (int)point.getX() < IsmMenuItemUI.this.menuItem.getWidth() && (int)point.getY() >= 0 && (int)point.getY() < IsmMenuItemUI.this.menuItem.getHeight()) {
                IsmMenuItemUI.this.doClick(manager);
            } else {
                manager.processMouseEvent(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = mouseEvent.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                manager.setSelectedPath(IsmMenuItemUI.this.getPath());
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!IsmMenuItemUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = mouseEvent.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
            } else {
                MenuElement[] path = manager.getSelectedPath();
                if (path.length > 1 && path[path.length - 1] == IsmMenuItemUI.this.menuItem) {
                    MenuElement[] newPath = new MenuElement[path.length - 1];
                    int cc = path.length - 1;
                    for (int ii = 0; ii < cc; ++ii) {
                        newPath[ii] = path[ii];
                    }
                    manager.setSelectedPath(newPath);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

