/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class IsmTableHeaderCellRenderer
extends DefaultTableCellRenderer
implements UIResource {
    private static final long serialVersionUID = -466364326409311619L;
    private int column;

    public IsmTableHeaderCellRenderer() {
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(2);
        this.setIconTextGap(4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int columnValue) {
        JTableHeader header = table.getTableHeader();
        if (header != null) {
            this.setFont(header.getFont());
        }
        this.column = columnValue;
        this.setText(value == null ? "" : value.toString());
        this.setArrowIcon(table);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setToolTip(table, value, columnValue);
        return this;
    }

    private void setToolTip(JTable table, Object value, int columnValue) {
        int availableWidth = table.getColumnModel().getColumn(columnValue).getWidth();
        availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
        if (this.getBorder() != null) {
            Insets borderInsets = this.getBorder().getBorderInsets(this);
            availableWidth -= borderInsets.left + borderInsets.right;
        }
        if (this.getIcon() != null) {
            availableWidth -= this.getIcon().getIconWidth();
            availableWidth -= this.getIconTextGap();
        }
        String cellText = value == null ? "" : value.toString();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm.stringWidth(cellText) > availableWidth) {
            this.setToolTipText(cellText);
        } else {
            this.setToolTipText(null);
        }
    }

    private void setArrowIcon(JTable table) {
        RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
        if (null == rowSorter) {
            this.setIcon(null);
            return;
        }
        List<RowSorter.SortKey> list = rowSorter.getSortKeys();
        if (null == list || list.isEmpty()) {
            this.setIcon(null);
            return;
        }
        RowSorter.SortKey sortKey = list.get(0);
        int curColumn = sortKey.getColumn();
        SortOrder sortOrder = sortKey.getSortOrder();
        if (sortOrder != SortOrder.UNSORTED && table.convertColumnIndexToModel(this.column) == curColumn) {
            if (sortOrder == SortOrder.ASCENDING) {
                Icon upwardsSortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                this.setIcon(upwardsSortIcon);
            } else {
                Icon downwardsSortIcon = UIManager.getIcon("Table.descendingSortIcon");
                this.setIcon(downwardsSortIcon);
            }
        } else {
            this.setIcon(null);
        }
    }
}

