/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmIconFactory;
import com.huawei.ism.ui.swing.plaf.IsmNormTheme;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.IsmRGBButtonStyle;
import com.huawei.ism.ui.swing.plaf.armor.ArmorBorders;
import com.huawei.ism.ui.swing.plaf.armor.ArmorIconFactory;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public class ArmorTheme
extends IsmNormTheme {
    @Override
    public void addCustomEntriesToTable(UIDefaults table) {
        super.addCustomEntriesToTable(table);
        this.addCustomEntriesToTable1(table);
        this.addCustomEntriesToTable2(table);
        this.addCalendarToTable(table);
        this.customArmorUIStyle(table);
        IsmPlafUtils.OEMVender vendor = IsmPlafUtils.getOEMVender();
        if (vendor.equals((Object)IsmPlafUtils.OEMVender.Huawei)) {
            this.customHWStype(table);
        } else {
            this.customHSStype(table);
        }
    }

    private void addCalendarToTable(UIDefaults table) {
        table.put("DatePicker.LeftMonthArraw", this.makeArmorIcon("datepicker.left.month.arrow.png"));
        table.put("DatePicker.RightMonthArraw", this.makeArmorIcon("datepicker.right.month.arrow.png"));
        table.put("DatePicker.LeftYearArraw", this.makeArmorIcon("datepicker.left.year.arrow.png"));
        table.put("DatePicker.RightYearArraw", this.makeArmorIcon("datepicker.right.year.arrow.png"));
        table.put("DatePicker.LeftMonthArrawOver", this.makeArmorIcon("datepicker.left.month.arrow.over.png"));
        table.put("DatePicker.RightMonthArrawOver", this.makeArmorIcon("datepicker.right.month.arrow.over.png"));
        table.put("DatePicker.LeftYearArrawOver", this.makeArmorIcon("datepicker.left.year.arrow.over.png"));
        table.put("DatePicker.RightYearArrawOver", this.makeArmorIcon("datepicker.right.year.arrow.over.png"));
        table.put("DatePicker.LeftMonthArrawGray", this.makeArmorIcon("datepicker.left.month.arrow.gray.png"));
        table.put("DatePicker.RightMonthArrawGray", this.makeArmorIcon("datepicker.right.month.arrow.gray.png"));
        table.put("DatePicker.LeftYearArrawGray", this.makeArmorIcon("datepicker.left.year.arrow.gray.png"));
        table.put("DatePicker.RightYearArrawGray", this.makeArmorIcon("datepicker.right.year.arrow.gray.png"));
        table.put("TitleBorder.rightBG", this.makeArmorIcon("TitleBorder.rightBG.png"));
        table.put("TitleBorder.centerBG", this.makeArmorIcon("TitleBorder.centerBG.png"));
        table.put("TitleBorder.leftBG", this.makeArmorIcon("TitleBorder.leftBG.png"));
        table.put("Control.borderColor", this.getContrlBorderColor());
        table.put("BoldFont.color", new ColorUIResource(0x464646));
        table.put("PlainFont.color", new ColorUIResource(0x333333));
    }

    private void addCustomEntriesToTable1(UIDefaults table) {
        table.put("Panel.background", new ColorUIResource(0xF1F1F1));
        table.put("SplitPane.borderColor", new ColorUIResource(9474453));
        table.put("SplitPane.borderGapColor", new ColorUIResource(9474453));
        table.put("Menu.selectionForeground", this.getWhite());
        table.put("Menu.font", this.getMenuTextFont());
        table.put("MenuItem.font", this.getMenuTextFont());
        table.put("MenuItem.acceleratorFont", this.getMenuTextFont());
        table.put("PopupMenu.font", this.getMenuTextFont());
        table.put("MenuItem.foreground", this.getSystemTextColor());
        table.put("MenuItem.background", this.getWhite());
        table.put("MenuItem.selectionForeground", this.getWhite());
        table.put("MenuItem.acceleratorForeground", this.getSystemTextColor());
        table.put("MenuItem.acceleratorSelectionForeground", this.getWhite());
        table.put("IsmPopMenuItem.inserts", new InsetsUIResource(5, 4, 4, 4));
        table.put("RadioButtonMenuItem.foreground", this.getSystemTextColor());
        table.put("RadioButtonMenuItem.background", this.getWhite());
        table.put("RadioButtonMenuItem.selectionForeground", this.getWhite());
        table.put("RadioButtonMenuItem.acceleratorForeground", this.getSystemTextColor());
        table.put("RadioButtonMenuItem.acceleratorSelectionForeground", this.getWhite());
        table.put("RadioButtonMenuItem.acceleratorSelectionForeground", this.getWhite());
        List<Object> statusBarGradient = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), new ColorUIResource(0x575759), null, new ColorUIResource(0x49494C));
        table.put("IsmStatusPane.gradient", statusBarGradient);
        Object expandedIcon = this.makeArmorIcon("tree_expanded.png");
        Object collapsedIcon = this.makeArmorIcon("tree_collapsed.png");
        table.put("Tree.expandedIcon", expandedIcon);
        table.put("Tree.collapsedIcon", collapsedIcon);
        table.put("Tree.rowHeight", (Object)25);
        table.put("Table.disabledBackgound", new ColorUIResource(0xF2F2F2));
        table.put("Table.backgound", new ColorUIResource(0xF7F7F7));
        table.put("Table.alternateRowColor", new ColorUIResource(0xEFEFEF));
        table.put("Table.rolloverColor", new ColorUIResource(0xD6D6D8));
        table.put("Table.gridColor", new ColorUIResource(0xE2E2E2));
        table.put("Table.selectionBackground", new ColorUIResource(9672088));
        table.put("Table.selectionForeground", Color.WHITE);
        table.put("TableHeader.background", new ColorUIResource(0xD0D0D0));
        table.put("TableHeader.foreground", this.getSystemTextColor());
        table.put("TableHeader.font", IsmFontFactory.getBold12Font());
        InsetsUIResource tabbedPaneTabInsets = new InsetsUIResource(0, 10, 0, 10);
        InsetsUIResource tabbedPaneTabPadInsets = new InsetsUIResource(0, 0, 0, 0);
        InsetsUIResource tabbedPaneTabAreaInsets = new InsetsUIResource(1, 1, 1, 1);
        InsetsUIResource tabbedPaneContentBorderInsets = new InsetsUIResource(1, 1, 1, 1);
        table.put("TabbedPane.tabInsets", tabbedPaneTabInsets);
        table.put("TabbedPane.selectedTabPadInsets", tabbedPaneTabPadInsets);
        table.put("TabbedPane.tabAreaInsets", tabbedPaneTabAreaInsets);
        table.put("TabbedPane.contentBorderInsets", tabbedPaneContentBorderInsets);
        table.put("TabbedPane.selectedBackground", new ColorUIResource(0xE7E8E8));
        table.put("TabbedPane.background", new ColorUIResource(0xE7E8E8));
        table.put("TabbedPane.contentOpaque", Boolean.TRUE);
        table.put("TabbedPane.contentAreaColor", new ColorUIResource(0xFFFFFF));
        table.put("TabbedPane.unselectedBackground", new ColorUIResource(0xE7E8E8));
        table.put("TabbedPane.foreground", this.getSystemTextColor());
        table.put("TabbedPane.font", this.getControlTextFont());
        table.put("TabbedPane.highlight", this.getContrlBorderColor());
    }

    private void addCustomEntriesToTable2(UIDefaults defaults) {
        Object northButtonIconImage = this.makeArmorIcon("ScrollBarNorthButtonIconImage.png");
        Object southButtonIconImage = this.makeArmorIcon("ScrollBarSouthButtonIconImage.png");
        Object eastButtonIconImage = this.makeArmorIcon("ScrollBarEastButtonIconImage.png");
        Object westButtonIconImage = this.makeArmorIcon("ScrollBarWestButtonIconImage.png");
        Object northButtonDisabledIconImage = this.makeArmorIcon("ScrollBarNorthButtonIconImage_disable.png");
        Object southButtonDisabledIconImage = this.makeArmorIcon("ScrollBarSouthButtonIconImage_disable.png");
        Object eastButtonDisabledIconImage = this.makeArmorIcon("ScrollBarEastButtonIconImage_disable.png");
        Object westButtonDisabledIconImage = this.makeArmorIcon("ScrollBarWestButtonIconImage_disable.png");
        defaults.put("ScrollBar.northButtonIconImage", northButtonIconImage);
        defaults.put("ScrollBar.southButtonIconImage", southButtonIconImage);
        defaults.put("ScrollBar.eastButtonIconImage", eastButtonIconImage);
        defaults.put("ScrollBar.westButtonIconImage", westButtonIconImage);
        defaults.put("ScrollBar.northButtonIconImageDisabled", northButtonDisabledIconImage);
        defaults.put("ScrollBar.southButtonIconImageDisabled", southButtonDisabledIconImage);
        defaults.put("ScrollBar.eastButtonIconImageDisabled", eastButtonDisabledIconImage);
        defaults.put("ScrollBar.westButtonIconImageDisabled", westButtonDisabledIconImage);
        defaults.put("ScrollBar.width", (Object)18);
        defaults.put("ScrollBar.thumbHighlight", new ColorUIResource(Color.WHITE));
        defaults.put("ScrollBar.thumbShadow", new ColorUIResource(0xA8A8A9));
        defaults.put("ScrollBar.thumb", new ColorUIResource(0xDBDDDE));
        defaults.put("ScrollPane.borderColor_disable", new ColorUIResource(0xD5D5D5));
        defaults.put("ScrollPane.borderColor", this.getContrlBorderColor());
        defaults.put("FileChooser.homeFolderIcon", this.makeArmorIcon("homeFolder.png"));
        defaults.put("FileChooser.newFolderIcon", this.makeArmorIcon("newFolder.png"));
        defaults.put("FileChooser.upFolderIcon", this.makeArmorIcon("upFolder.png"));
        defaults.put("FileView.computerIcon", this.makeArmorIcon("computer.png"));
        defaults.put("FileView.directoryIcon", this.makeArmorIcon("directory.png"));
        defaults.put("FileView.hardDriveIcon", this.makeArmorIcon("hardDrive.png"));
        defaults.put("FileView.fileIcon", this.makeArmorIcon("file.png"));
        defaults.put("FileView.floppyDriveIcon", this.makeArmorIcon("floppy.png"));
        defaults.put("FileChooser.detailsViewIcon", this.makeArmorIcon("filechooser_details.png"));
        defaults.put("FileChooser.listViewIcon", this.makeArmorIcon("filechoose_list.png"));
        defaults.put("TextField.font", this.getControlTextFont());
        defaults.put("TextField.foreground", this.getSystemTextColor());
        defaults.put("TextField.background", this.getWhite());
        defaults.put("TextField.disabledBackground", this.getDisableBackground());
        defaults.put("TextField.inactiveBackground", this.getDisableBackground());
        defaults.put("PasswordField.disabledBackground", this.getDisableBackground());
        defaults.put("PasswordField.background", this.getWhite());
        defaults.put("PasswordField.inactiveBackground", this.getDisableBackground());
        defaults.put("TextField.luInnerColor", new ColorUIResource(Color.WHITE));
        defaults.put("TextField.luNormalOuterColor", this.getContrlBorderColor());
        defaults.put("TextField.rdNormalOuterColor", this.getContrlBorderColor());
        defaults.put("TextField.disabledBorderColor", new ColorUIResource(0xD5D5D5));
        defaults.put("TextField.inactiveBorderColor", new ColorUIResource(0xD5D5D5));
        defaults.put("TitledBorder.border", new BorderUIResource.LineBorderUIResource(this.getContrlBorderColor()));
        defaults.put("List.selectionBackground", new ColorUIResource(9672088));
        defaults.put("List.selectionForeground", this.getWhite());
        defaults.put("List.font", this.getControlTextFont());
        defaults.put("List.rolloverbackground", new ColorUIResource(0xD6D6D8));
        defaults.put("List.rolloverForeground", this.getWhite());
        defaults.put("TextPane.selectionForeground", this.getWhite());
        defaults.put("TextPane.font", this.getControlTextFont());
        defaults.put("JSlider.pumbHIcon", this.makeArmorIcon("slider_pumb_H.png"));
        defaults.put("JSlider.pumbVIcon", this.makeArmorIcon("slider_pumb_V.png"));
        List<Object> sliderPumbRolloverGradient = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), new ColorUIResource(0xF8F8F8), null, new ColorUIResource(0xDBDBDB));
        defaults.put("JSlider.pumbNormalHighlight", new ColorUIResource(14672097));
        defaults.put("JSlider.pumbNormalBackground", new ColorUIResource(13553617));
        defaults.put("JSlider.pumbNormalBorderColor", new ColorUIResource(10001314));
        defaults.put("JSlider.pumbRolloverHighlight", new ColorUIResource(0xFDFDFD));
        defaults.put("JSlider.pumbRolloverGrient", sliderPumbRolloverGradient);
        defaults.put("JSlider.pumbRolloverBorderColor", new ColorUIResource(0xA7A8AA));
        defaults.put("Slider.horizontalThumbIcon", ArmorIconFactory.getSliderHIcon());
        defaults.put("Slider.verticalThumbIcon", ArmorIconFactory.getSliderVIcon());
        defaults.put("Slider.trackBorderColor", this.getContrlBorderColor());
        defaults.put("Slider.trackDisableBorderColor", this.getContrlBorderColor());
        defaults.put("Slider.trackInnerUnFillColor", new ColorUIResource(0xF8F8F8));
        defaults.put("LINE_MARGIN_PIXEL", (Object)10);
    }

    protected void customArmorUIStyle(UIDefaults table) {
        this.customArmorUIStyle1(table);
        this.customArmorUIStyle2(table);
    }

    private void customArmorUIStyle1(UIDefaults defaults) {
        defaults.put("IsmDialog.buttonBarBackground", new ColorUIResource(0xF1F1F1));
        defaults.put("IsmArmorStyle.BaseColor", new ColorUIResource(0x49494C));
        defaults.put("IsmTreeUI.HVLineColor", new ColorUIResource(12237760));
        defaults.put("IsmTreeUI.arrowIcon", this.makeOEMIcon("tree_arrow.png"));
        defaults.put("IsmMenuBar.Insets", new InsetsUIResource(0, 10, 0, 10));
        Object menuBarBGimg = this.makeArmorIcon("menubar_background.png");
        defaults.put("IsmMenuBar.BackGroundImageIcon", menuBarBGimg);
        defaults.put("MenuBarUI", "com.huawei.ism.ui.swing.plaf.armor.ArmorMenuBarUI");
        defaults.put("IsmMenuBar.BorderPainted", Boolean.FALSE);
        defaults.put("IsmMenu.SelectedInsets", new InsetsUIResource(4, 0, 0, 0));
        defaults.put("IsmTopMenu.rolloverInset", new InsetsUIResource(4, 0, 4, 0));
        defaults.put("IsmTopMenu.rolloverBackground", new ColorUIResource(0x79797A));
        Object toolBarBGimg = this.makeArmorIcon("toolbar_background.png");
        defaults.put("IsmToolBar.BackGroundImageIcon", toolBarBGimg);
        defaults.put("IsmToolBar.Insets", new InsetsUIResource(2, 10, 0, 10));
        defaults.put("IsmToolBar.BorderHeight", (Object)2);
        defaults.put("IsmStatusPane.BackgroudImage", this.makeArmorIcon("statusbar_background.png"));
        defaults.put("IsmSplitPane.BorderInsets", new InsetsUIResource(0, 0, 0, 0));
        defaults.put("SplitPaneDivider.BorderCutted", Boolean.TRUE);
        defaults.put("SplitPane.dividerSize", (Object)5);
        defaults.put("SplitPane.bumpIconV", this.makeArmorIcon("splitPaneBump_v.png"));
        defaults.put("SplitPane.bumpIconH", this.makeArmorIcon("splitPaneBump_h.png"));
        defaults.put("SplitPane.backgound", new ColorUIResource(9474453));
        defaults.put("IsmStatusPane.separator", this.makeArmorIcon("statusbar_separator.png"));
        defaults.put("IsmTable.rowHeight", (Object)29);
        defaults.put("IsmTableHeader.rowHeight", (Object)26);
        defaults.put("IsmTableRowHeader.backgroud", new ColorUIResource(0xDDDDDD));
        defaults.put("IsmTableRowHeader.cellBorder", ArmorBorders.getSequenceTableHeaderBorder());
        Object selectedEnabledIcon = this.makeOEMIcon("checkbox_selected_pressed.png");
        Object selectedDisabledIcon = this.makeArmorIcon("checkbox_selected_disabled.png");
        Object unselectedEnabledIcon = this.makeArmorIcon("checkbox_normal.png");
        Object unselectedDisabledIcon = this.makeArmorIcon("checkbox_normal_disabled.png");
        Object unselectedRolloverIcon = this.makeArmorIcon("checkbox_normal_rollover.png");
        Object selectedRolloverIcon = this.makeOEMIcon("checkbox_selected_rollover.png");
        Object unselectedPressedIcon = this.makeArmorIcon("checkbox_normal.png");
        Object selectedPressedIcon = this.makeOEMIcon("checkbox_selected_pressed.png");
        Object partialEnabledIcon = this.makeArmorIcon("checkbox_patial.png");
        Object partialDisabledIcon = this.makeArmorIcon("checkbox_patial_disabled.png");
        Object partialRolloverIcon = this.makeArmorIcon("checkbox_patial_rollover.png");
        Object partialPressedIcon = this.makeArmorIcon("checkbox_patial_pressed.png");
        defaults.put("CheckBox.partialEnabledIcon", partialEnabledIcon);
        defaults.put("CheckBox.partialDisabledIcon", partialDisabledIcon);
        defaults.put("CheckBox.partialRolloverIcon", partialRolloverIcon);
        defaults.put("CheckBox.partialPressedIcon", partialPressedIcon);
        defaults.put("CheckBox.icon", unselectedEnabledIcon);
        defaults.put("CheckBox.selectedEnabledIcon", selectedEnabledIcon);
        defaults.put("CheckBox.selectedDisabledIcon", selectedDisabledIcon);
        defaults.put("CheckBox.unselectedEnabledIcon", unselectedEnabledIcon);
        defaults.put("CheckBox.unselectedDisabledIcon", unselectedDisabledIcon);
        defaults.put("CheckBox.unselectedRolloverIcon", unselectedRolloverIcon);
        defaults.put("CheckBox.selectedRolloverIcon", selectedRolloverIcon);
        defaults.put("CheckBox.unselectedPressedIcon", unselectedPressedIcon);
        defaults.put("CheckBox.selectedPressedIcon", selectedPressedIcon);
        defaults.put("CheckBox.rollover", Boolean.TRUE);
        selectedEnabledIcon = this.makeOEMIcon("radiobutton_normal_pressed.png");
        selectedDisabledIcon = this.makeArmorIcon("radiobutton_selected_disabled.png");
        unselectedEnabledIcon = this.makeArmorIcon("radiobutton_normal.png");
        unselectedDisabledIcon = this.makeArmorIcon("radiobutton_normal_disabled.png");
        unselectedRolloverIcon = this.makeArmorIcon("radiobutton_normal_rollover.png");
        selectedRolloverIcon = this.makeOEMIcon("radiobutton_selected_rollover.png");
        unselectedPressedIcon = this.makeArmorIcon("radiobutton_normal.png");
        selectedPressedIcon = this.makeOEMIcon("radiobutton_normal_pressed.png");
        defaults.put("RadioButton.icon", unselectedEnabledIcon);
        defaults.put("RadioButton.selectedEnabledIcon", selectedEnabledIcon);
        defaults.put("RadioButton.selectedDisabledIcon", selectedDisabledIcon);
        defaults.put("RadioButton.unselectedEnabledIcon", unselectedEnabledIcon);
        defaults.put("RadioButton.unselectedDisabledIcon", unselectedDisabledIcon);
        defaults.put("RadioButton.unselectedRolloverIcon", unselectedRolloverIcon);
        defaults.put("RadioButton.selectedRolloverIcon", selectedRolloverIcon);
        defaults.put("RadioButton.unselectedPressedIcon", unselectedPressedIcon);
        defaults.put("RadioButton.selectedPressedIcon", selectedPressedIcon);
        defaults.put("RadioButton.rollover", Boolean.TRUE);
        defaults.put("TabbedPaneUI.tabBottomIcon", this.makeArmorIcon("tabbedPane_tab_bottom_default.png"));
        defaults.put("TabbedPaneUI.selectedArrowIcon", this.makeArmorIcon("tabbedPane_tab_bottom_arrow.png"));
        defaults.put("TabbedPane.selectedFont", IsmFontFactory.getBold12Font());
        defaults.put("FirstFloorPane.titleBackGroudImage", this.makeArmorIcon("firstfloor_titlepane.png"));
        List<Object> scrollBarRolloverGradient = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), new ColorUIResource(0xF4F4F4), null, new ColorUIResource(0xD3D1D1));
        defaults.put("IsmScrollBar.rolloverGradient", scrollBarRolloverGradient);
        List<Object> scrollBarSelectedGradient = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), new ColorUIResource(0xD3D1D1), null, new ColorUIResource(0xF4F4F4));
        defaults.put("IsmScrollBar.selectedGradient", scrollBarSelectedGradient);
        defaults.put("IsmScrollBar.thumbDisableColor", new ColorUIResource(0xEDEEEF));
        defaults.put("IsmScrollBar.thumbBorderDisableColor", new ColorUIResource(0xC1C1C3));
        defaults.put("IsmScrollBarArrowButton.highlight", Color.WHITE);
        defaults.put("IsmScrollBarArrowButton.shadow", new ColorUIResource(0xA8A8A9));
    }

    private void customArmorUIStyle2(UIDefaults table) {
        table.put("IsmButton.normalFillBackground", new ColorUIResource(0xDBDBDB));
        table.put("IsmToolBarButton.normalFillBackground", new ColorUIResource(0x79797A));
        List<Object> btnRolloverGradient = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), new ColorUIResource(0xEFEFEF), null, new ColorUIResource(0xDEDEDE));
        List<Object> btnPressGradient = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), new ColorUIResource(0xDEDEDE), null, new ColorUIResource(0xEFEFEF));
        table.put("IsmButton.gradientRollover", btnRolloverGradient);
        table.put("IsmButton.gradientPress", btnPressGradient);
        table.put("IsmButton.normalHighlight", new ColorUIResource(0xE9E9E9));
        table.put("IsmButton.rolloverHighlight", new ColorUIResource(0xFCFCFC));
        table.put("IsmButton.pressHighlight", new ColorUIResource(0xFCFCFC));
        table.put("IsmButton.normalBorderColor", new ColorUIResource(0xFCFCFC));
        table.put("IsmButton.rolloverAndPressBorderColor", new ColorUIResource(0xFCFCFC));
        table.put("Button.foreground", this.getSystemTextColor());
        table.put("Button.font", this.getControlTextFont());
        table.put("Button.rollover", Boolean.TRUE);
        table.put("ArmorButton.style", this.createButtonStyle());
        table.put("ArmorToolBarButton.style", this.createToolBarButtonStyle());
        table.put("ArmorTextField.normalBorderColor", this.getContrlBorderColor());
        table.put("ArmorTextField.diableBorderColor", new ColorUIResource(0xD5D5D5));
        table.put("ComboBoxButton.normalHighlight", new ColorUIResource(14869476));
        table.put("ComboBoxButton.normalFillBackground", new ColorUIResource(13882582));
        table.put("ComboBoxButton.rolloverHighlight", new ColorUIResource(0xFDFDFD));
        table.put("ComboBoxButton.gradientRollover", btnRolloverGradient);
        table.put("ComboBoxButton.pressHighlight", new ColorUIResource(11448242));
        table.put("ComboBoxButton.gradientPress", btnPressGradient);
        table.put("ComboBoxButton.disableHighlight", new ColorUIResource(0xD5D5D5));
        table.put("ComboBoxButton.disableFillBackground", new ColorUIResource(0xF2F2F2));
        table.put("ArmorComboBoxButton.style", this.createComboBoxButtonStyle());
        table.put("IsmComboBox.height", (Object)21);
        table.put("ComboBox.background", this.getWhite());
        table.put("ComboBox.foreground", this.getBlack());
        table.put("ComboBox.selectionForeground", this.getWhite());
        table.put("ComboBox.disabledBackground", new ColorUIResource(0xF2F2F2));
        table.put("ComboBox.disabledForeground", new ColorUIResource(10790310));
        Object comboBoxArrowImage = this.makeArmorIcon("combobox_arrow.png");
        Object comboBoxArrowImageDisable = this.makeArmorIcon("combobox_arrow_disable.png");
        table.put("ComboBox.arrowImage", comboBoxArrowImage);
        table.put("ComboBox.arrowImageDisable", comboBoxArrowImageDisable);
        table.put("ComboBox.arrowIcon", IsmIconFactory.getComboBoxIcon());
        table.put("Popup.borderColor", this.getContrlBorderColor());
        table.put("ProgressBar.selectionGradient", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), new ColorUIResource(12451204), null, new ColorUIResource(5944643)));
        table.put("ProgressBar.backgroundGradient", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), new ColorUIResource(5987421), null, new ColorUIResource(6776937)));
        table.put("ProgressBar.selectionForeground", this.getBlack());
        table.put("ProgressBar.selectionBackground", this.getWhite());
        table.put("ProgressBar.border", new BorderUIResource.LineBorderUIResource(new ColorUIResource(5724249)));
        table.put("IsmList.cellRowHeight", (Object)21);
        table.put("IsmList.diableBackgroud", this.getDisableBackground());
        table.put("PopupMenu.alpha", (Object)220);
        table.put("PopupMenu.borderAlpha", (Object)220);
        table.put("TitleBar.close_normal", this.makeArmorIcon("titleBar_close_normal.png"));
        table.put("TitleBar.close_selected", this.makeOEMIcon("titleBar_close_selected.png"));
        table.put("TitleBar.close_rollover", this.makeOEMIcon("titleBar_close_rollover.png"));
        table.put("TitleBar.minimize_normal", this.makeArmorIcon("titleBar_minimize_normal.png"));
        table.put("TitleBar.minimize_selected", this.makeArmorIcon("titleBar_minimize_selected.png"));
        table.put("TitleBar.minimize_rollover", this.makeArmorIcon("titleBar_minimize_rollover.png"));
        table.put("TitleBar.maximize_normal", this.makeArmorIcon("titleBar_maximize_normal.png"));
        table.put("TitleBar.maximize_selected", this.makeArmorIcon("titleBar_maximize_selected.png"));
        table.put("TitleBar.maximize_rollover", this.makeArmorIcon("titleBar_maximize_rollover.png"));
        table.put("TitleBar.restore_normal", this.makeArmorIcon("titleBar_restore_normal.png"));
        table.put("TitleBar.restore_selected", this.makeArmorIcon("titleBar_restore_selected.png"));
        table.put("TitleBar.restore_rollover", this.makeArmorIcon("titleBar_restore_rollover.png"));
        table.put("TitleBar.leftBackground", this.makeArmorIcon("titleBar_left_background.png"));
        table.put("TitleBar.rightBackground", this.makeArmorIcon("titleBar_right_background.png"));
        table.put("TitleBar.dialogBorderColor", new ColorUIResource(0x202122));
        table.put("TitleBar.dialog_background", this.makeArmorIcon("titleBar_dialog_background.png"));
        table.put("TitleBar.dialog_close_normal", this.makeArmorIcon("titleBar_dialog_close_normal.png"));
        table.put("TitleBar.dialog_close_selected", this.makeArmorIcon("titleBar_dialog_close_selected.png"));
        table.put("TitleBar.dialog_close_rollover", this.makeOEMIcon("titleBar_dialog_close_rollover.png"));
        table.put("IsmFrame.TitleBarHeight", (Object)29);
        table.put("IsmDialog.TitleBarHeight", (Object)42);
        table.put("FlexPane.UpNormal", this.makeArmorIcon("FlexPane.UpNormal.png"));
        table.put("FlexPane.DownNormal", this.makeArmorIcon("FlexPane.DownNormal.png"));
        table.put("FlexPane.RightNormal", this.makeArmorIcon("FlexPane.RightNormal.png"));
        table.put("OEMIcon.orientSouth", this.makeOEMIcon("OEMIcon.orientSouth.png"));
        table.put("IsmButton.height", (Object)21);
    }

    protected void customHSStype(UIDefaults table) {
        ColorUIResource hsRenderColor1 = this.getHSBaseColor();
        table.put("IsmOEMTheme.renderColor", hsRenderColor1);
        table.put("IsmOEMTheme.dateGridSelectColor", hsRenderColor1);
        table.put("IsmTheme.selectionBGGradientBG", hsRenderColor1);
        table.put("IsmTheme.selectionBGGradientStart", hsRenderColor1);
        table.put("IsmTheme.selectionBGGradientEnd", hsRenderColor1);
        table.put("TabbedPane.selectedForeground", new ColorUIResource(16542473));
        table.put("TextField.luFocusOuterColor", hsRenderColor1);
        table.put("TextField.rdFocusOuterColor", hsRenderColor1);
        table.put("ComboBox.selectionBackground", hsRenderColor1);
        table.put("TextField.focusColor", hsRenderColor1);
        table.put("TextField.selectionBackground", hsRenderColor1);
        table.put("PasswordField.selectionBackground", hsRenderColor1);
        table.put("TextArea.selectionBackground", this.getHSBaseColor());
        table.put("IsmTopMenu.selectedColor", hsRenderColor1);
        table.put("IsmToolBar.BorderColor", hsRenderColor1);
        table.put("IsmToolBar.TopBorderColor", hsRenderColor1);
        table.put("IsmToolBar.bottomBorderColor", hsRenderColor1);
        table.put("TextPane.selectionBackground", hsRenderColor1);
        table.put("Button.defaultOutterBorderColor", hsRenderColor1);
        table.put("Button.defaultInnerBorderColor", hsRenderColor1);
        table.put("JSlider.trackInnerFillColor", hsRenderColor1);
        table.put("FlexPane.DownRollover", this.makeOEMIcon("FlexPane.DownRollover.png"));
        table.put("FlexPane.UpRollover", this.makeOEMIcon("FlexPane.UpRollover.png"));
        table.put("FlexPane.RightRollover", this.makeOEMIcon("FlexPane.RightRollover.png"));
    }

    protected void customSYStype(UIDefaults table) {
        ColorUIResource hsRenderColor = this.getSYBaseColor();
        table.put("IsmOEMTheme.renderColor", hsRenderColor);
        table.put("IsmTheme.selectionBGGradientBG", hsRenderColor);
        table.put("IsmTheme.selectionBGGradientStart", hsRenderColor);
        table.put("IsmTheme.selectionBGGradientEnd", hsRenderColor);
        table.put("TabbedPane.selectedForeground", new ColorUIResource(16542473));
        table.put("TextField.luFocusOuterColor", hsRenderColor);
        table.put("TextField.rdFocusOuterColor", hsRenderColor);
        table.put("ComboBox.selectionBackground", hsRenderColor);
        table.put("TextField.focusColor", hsRenderColor);
        table.put("TextField.selectionBackground", hsRenderColor);
        table.put("PasswordField.selectionBackground", hsRenderColor);
        table.put("TextArea.selectionBackground", this.getHSBaseColor());
        table.put("IsmTopMenu.selectedColor", hsRenderColor);
        table.put("IsmToolBar.BorderColor", hsRenderColor);
        table.put("IsmToolBar.TopBorderColor", hsRenderColor);
        table.put("IsmToolBar.bottomBorderColor", hsRenderColor);
        table.put("TextPane.selectionBackground", hsRenderColor);
        table.put("Button.defaultOutterBorderColor", hsRenderColor);
        table.put("Button.defaultInnerBorderColor", hsRenderColor);
        table.put("JSlider.trackInnerFillColor", hsRenderColor);
        table.put("IsmOEMTheme.dateGridSelectColor", hsRenderColor);
        table.put("FlexPane.DownRollover", this.makeOEMIcon("FlexPane.DownRollover.png"));
        table.put("FlexPane.UpRollover", this.makeOEMIcon("FlexPane.UpRollover.png"));
        table.put("FlexPane.RightRollover", this.makeOEMIcon("FlexPane.RightRollover.png"));
    }

    protected void customHWStype(UIDefaults table) {
        ColorUIResource hwRenderColor = this.getHWBaseColor();
        table.put("IsmOEMTheme.renderColor", hwRenderColor);
        table.put("IsmTheme.selectionBGGradientBG", hwRenderColor);
        table.put("IsmTheme.selectionBGGradientStart", hwRenderColor);
        table.put("IsmTheme.selectionBGGradientEnd", hwRenderColor);
        table.put("TabbedPane.selectedForeground", hwRenderColor);
        table.put("TextField.luFocusOuterColor", hwRenderColor);
        table.put("TextField.rdFocusOuterColor", hwRenderColor);
        table.put("ComboBox.selectionBackground", hwRenderColor);
        table.put("TextField.focusColor", hwRenderColor);
        table.put("TextField.selectionBackground", hwRenderColor);
        table.put("IsmTopMenu.selectedColor", hwRenderColor);
        table.put("IsmToolBar.TopBorderColor", new ColorUIResource(12603986));
        table.put("IsmToolBar.bottomBorderColor", hwRenderColor);
        table.put("TextPane.selectionBackground", hwRenderColor);
        table.put("Button.defaultOutterBorderColor", hwRenderColor);
        table.put("Button.defaultInnerBorderColor", hwRenderColor);
        table.put("JSlider.trackInnerFillColor", hwRenderColor);
        table.put("IsmOEMTheme.dateGridSelectColor", hwRenderColor);
        table.put("PasswordField.selectionBackground", hwRenderColor);
        table.put("TextArea.selectionBackground", hwRenderColor);
        table.put("FlexPane.DownRollover", this.makeOEMIcon("FlexPane.DownRollover.png"));
        table.put("FlexPane.UpRollover", this.makeOEMIcon("FlexPane.UpRollover.png"));
        table.put("FlexPane.RightRollover", this.makeOEMIcon("FlexPane.RightRollover.png"));
    }

    public ColorUIResource getHSBaseColor() {
        return new ColorUIResource(15761920);
    }

    public ColorUIResource getHWBaseColor() {
        return new ColorUIResource(0x990000);
    }

    public ColorUIResource getSYBaseColor() {
        return new ColorUIResource(16431653);
    }

    @Override
    public String getName() {
        return "Armor";
    }

    @Override
    public ColorUIResource getMenuForeground() {
        return this.getWhite();
    }

    protected Object makeOEMIcon(String iconName) {
        IsmPlafUtils.OEMVender vender = IsmPlafUtils.getOEMVender();
        String iconPackage = "icons/" + vender.name().toLowerCase(IsmPlafUtils.getLocale());
        return LookAndFeel.makeIcon(ArmorTheme.class, iconPackage + '/' + iconName);
    }

    protected Object makeArmorIcon(String iconName) {
        String iconPackage = "icons/";
        return LookAndFeel.makeIcon(ArmorTheme.class, iconPackage + iconName);
    }

    @Override
    public ColorUIResource getSystemTextColor() {
        return this.getBlack();
    }

    public ColorUIResource getContrlBorderColor() {
        return new ColorUIResource(0xBCBCC2);
    }

    public ColorUIResource getDisableBackground() {
        return new ColorUIResource(0xF3F3F3);
    }

    private IsmButtonStyle createButtonStyle() {
        IsmRGBButtonStyle buttonStyle = new IsmRGBButtonStyle();
        buttonStyle.setBorderColor(IsmButtonStyle.ButtonState.NORMAL, new ColorUIResource(11053486));
        buttonStyle.setBorderCornerColor(IsmButtonStyle.ButtonState.NORMAL, new ColorUIResource(11053486));
        buttonStyle.setBorderColor(IsmButtonStyle.ButtonState.ROLLOVER, new ColorUIResource(0xA7A8AA));
        buttonStyle.setBorderCornerColor(IsmButtonStyle.ButtonState.ROLLOVER, new ColorUIResource(0xA7A8AA));
        return buttonStyle;
    }

    private IsmButtonStyle createToolBarButtonStyle() {
        IsmRGBButtonStyle buttonStyle = new IsmRGBButtonStyle();
        ColorUIResource colorUIResource = new ColorUIResource(0x8D8D8E);
        buttonStyle.setBorderColor(IsmButtonStyle.ButtonState.NORMAL, colorUIResource);
        buttonStyle.setBorderCornerColor(IsmButtonStyle.ButtonState.NORMAL, colorUIResource);
        buttonStyle.setBorderColor(IsmButtonStyle.ButtonState.ROLLOVER, colorUIResource);
        buttonStyle.setBorderCornerColor(IsmButtonStyle.ButtonState.ROLLOVER, colorUIResource);
        return buttonStyle;
    }

    private IsmButtonStyle createComboBoxButtonStyle() {
        ColorUIResource borderColor = new ColorUIResource(10659243);
        IsmRGBButtonStyle buttonStyle = (IsmRGBButtonStyle)this.createButtonStyle();
        buttonStyle.setBorderColor(IsmButtonStyle.ButtonState.NORMAL, borderColor);
        buttonStyle.setBorderCornerColor(IsmButtonStyle.ButtonState.NORMAL, borderColor);
        borderColor = new ColorUIResource(0xA7A8AA);
        buttonStyle.setBorderColor(IsmButtonStyle.ButtonState.ROLLOVER, borderColor);
        buttonStyle.setBorderCornerColor(IsmButtonStyle.ButtonState.ROLLOVER, borderColor);
        borderColor = new ColorUIResource(11448242);
        buttonStyle.setBorderColor(IsmButtonStyle.ButtonState.PRESSED, borderColor);
        buttonStyle.setBorderCornerColor(IsmButtonStyle.ButtonState.PRESSED, borderColor);
        borderColor = new ColorUIResource(0xD5D5D5);
        buttonStyle.setBorderColor(IsmButtonStyle.ButtonState.DISABLED, borderColor);
        buttonStyle.setBorderCornerColor(IsmButtonStyle.ButtonState.DISABLED, borderColor);
        return buttonStyle;
    }

    @Override
    public ColorUIResource getWindowTitleBackground() {
        return new ColorUIResource(0x49494C);
    }

    @Override
    public ColorUIResource getWindowTitleForeground() {
        return new ColorUIResource(Color.WHITE);
    }

    @Override
    public ColorUIResource getWindowTitleInactiveBackground() {
        return new ColorUIResource(0x49494C);
    }

    @Override
    public ColorUIResource getWindowTitleInactiveForeground() {
        return new ColorUIResource(Color.WHITE);
    }

    @Override
    public FontUIResource getControlTextFont() {
        return IsmFontFactory.getPlaint12Font();
    }

    @Override
    public FontUIResource getSystemTextFont() {
        return IsmFontFactory.getPlaint12Font();
    }

    @Override
    public FontUIResource getUserTextFont() {
        return IsmFontFactory.getPlaint12Font();
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return IsmFontFactory.getPlaint12Font();
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return IsmFontFactory.getBold13Font();
    }

    @Override
    public FontUIResource getSubTextFont() {
        return this.getMenuTextFont();
    }
}

