/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.util.SwingUIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class UnifyTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final int MIN_TABHEADER_WIDTH = 50;
    private static final int TABHEADER_HEIGHT = 33;
    private static Set<KeyStroke> managingFocusForwardTraversalKeys;
    private static Set<KeyStroke> managingFocusBackwardTraversalKeys;

    public UnifyTabbedPaneUI() {
        this.maxTabHeight = 33;
    }

    public static ComponentUI createUI(JComponent c) {
        return new UnifyTabbedPaneUI();
    }

    @Override
    protected void uninstallDefaults() {
        this.tabPane.setFocusTraversalKeys(0, null);
        this.tabPane.setFocusTraversalKeys(1, null);
        super.uninstallDefaults();
    }

    public void setContentBorderInsets(Insets contentBorderInstes) {
        this.contentBorderInsets = contentBorderInstes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void installDefaults() {
        super.installDefaults();
        Class<UnifyTabbedPaneUI> clazz = UnifyTabbedPaneUI.class;
        synchronized (UnifyTabbedPaneUI.class) {
            if (managingFocusForwardTraversalKeys == null) {
                managingFocusForwardTraversalKeys = new HashSet<KeyStroke>(0);
                managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
            }
            if (managingFocusBackwardTraversalKeys == null) {
                managingFocusBackwardTraversalKeys = new HashSet<KeyStroke>(0);
                managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
            }
            this.tabPane.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys);
            this.tabPane.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        return 33;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return 33;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int calculateTabWidth = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        return Math.max(calculateTabWidth, 50);
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return -2;
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        return 1;
    }

    @Override
    protected void setRolloverTab(int index) {
        int oldRolloverTab = this.getRolloverTab();
        super.setRolloverTab(index);
        Rectangle r1 = null;
        Rectangle r2 = null;
        if (oldRolloverTab >= 0 && oldRolloverTab < this.tabPane.getTabCount()) {
            r1 = this.getTabBounds(this.tabPane, oldRolloverTab);
        }
        if (index >= 0) {
            r2 = this.getTabBounds(this.tabPane, index);
        }
        if (null != r1) {
            if (null != r2) {
                this.tabPane.repaint(r1.union(r2));
            } else {
                this.tabPane.repaint(r1);
            }
        } else if (null != r2) {
            this.tabPane.repaint(r2);
        }
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int left = insets.left;
        int top = insets.top;
        int widht = width - insets.right - insets.left;
        int htight = height - insets.top - insets.bottom;
        if (this.tabPane.getTabCount() == 0) {
            Color color = UIManager.getColor("TabbedPane.contentAreaColor");
            graphics.setColor(color);
            graphics.fillRect(left, top, widht, htight);
        }
        super.paintContentBorder(graphics, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTabArea(Graphics graphics, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        Insets insets = this.tabPane.getInsets();
        int left = insets.left;
        int top = insets.top;
        int wwidth = width - insets.right - insets.left;
        this.paintBackground(graphics, "TabbedPane.tabAreaLeftBG", "TabbedPane.tabAreaRightBG", "TabbedPane.tabAreaCenterBG", left, top, wwidth);
        super.paintTabArea(graphics, tabPlacement, selectedIndex);
    }

    private void paintBackground(Graphics graphics, String leftImgKey, String rightImgKey, String centerImgKey, int xx, int yy, int ww) {
        ImageIcon leftUPIcon = (ImageIcon)UIManager.getIcon(leftImgKey);
        ImageIcon rightDownIcon = (ImageIcon)UIManager.getIcon(rightImgKey);
        ImageIcon centerIcon = (ImageIcon)UIManager.getIcon(centerImgKey);
        graphics.drawImage(leftUPIcon.getImage(), xx, yy, leftUPIcon.getIconWidth(), leftUPIcon.getIconHeight(), this.tabPane);
        graphics.drawImage(rightDownIcon.getImage(), ww - rightDownIcon.getIconWidth(), yy, rightDownIcon.getIconWidth(), rightDownIcon.getIconHeight(), this.tabPane);
        graphics.drawImage(centerIcon.getImage(), leftUPIcon.getIconWidth(), yy, ww - leftUPIcon.getIconWidth() - rightDownIcon.getIconWidth(), centerIcon.getIconHeight(), this.tabPane);
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int tabPlacement, int tabIndex, int xx, int yy, int ww, int hh, boolean isSelected) {
        if (1 != tabPlacement || -1 == tabIndex) {
            return;
        }
        if (isSelected || this.getRolloverTab() == tabIndex) {
            graphics.translate(xx, yy);
            this.paintBackground(graphics, "TabbedPane.tabSelectedAreaLeftBG", "TabbedPane.tabSelectedAreaRightBG", "TabbedPane.tabSelectedAreaCenterBG", 0, 0, ww);
            graphics.translate(-xx, -yy);
        }
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int tabPlacement, int tabIndex, int xx, int yy, int ww, int hh, boolean isSelected) {
        if (tabPlacement != 1) {
            super.paintTabBorder(graphics, tabPlacement, tabIndex, xx, yy, ww, hh, isSelected);
        }
    }

    @Override
    protected void paintText(Graphics graphics, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        boolean isRolloverTab = tabIndex == this.getRolloverTab();
        FontMetrics validMetrics = metrics;
        Font validFont = font;
        if (isSelected || isRolloverTab) {
            validFont = UIManager.getFont("TabbedPane.selectedFont");
            validMetrics = SwingUIUtil.getFontMetrics(this.tabPane, graphics, validFont);
        }
        graphics.setFont(validFont);
        View textViewForTab = this.getTextViewForTab(tabIndex);
        if (textViewForTab != null) {
            textViewForTab.paint(graphics, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                Color selectedFG;
                Color fg = this.tabPane.getForegroundAt(tabIndex);
                if ((isSelected || isRolloverTab) && fg instanceof UIResource && (selectedFG = UIManager.getColor("TabbedPane.selectedForeground")) != null) {
                    fg = selectedFG;
                }
                graphics.setColor(fg);
                SwingUIUtil.drawStringUnderlineCharAt(this.tabPane, graphics, title, mnemIndex, (int)textRect.getX(), (int)textRect.getY() + validMetrics.getAscent());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                SwingUIUtil.drawStringUnderlineCharAt(this.tabPane, graphics, title, mnemIndex, (int)textRect.getX(), (int)textRect.getY() + validMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                SwingUIUtil.drawStringUnderlineCharAt(this.tabPane, graphics, title, mnemIndex, (int)textRect.getX() - 1, (int)textRect.getY() + validMetrics.getAscent() - 1);
            }
        }
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        FontMetrics validMetrics = metrics;
        if (isSelected || tabIndex == this.getRolloverTab()) {
            Font font = UIManager.getFont("TabbedPane.selectedFont");
            validMetrics = SwingUIUtil.getFontMetrics(this.tabPane, this.tabPane.getGraphics(), font);
        }
        super.layoutLabel(tabPlacement, validMetrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
    }
}

