/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.ui.swing.table.IsmAbstractTableModel;
import com.huawei.ism.ui.swing.table.TableRow;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultTableModel
extends IsmAbstractTableModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTableModel.class);
    private static final long serialVersionUID = -7057504085278764412L;

    public DefaultTableModel(String[] columnNames, int ... visibleColumnIds) {
        super(columnNames, visibleColumnIds);
    }

    public DefaultTableModel(String[] columnNames, int[] fiexedVisibleColumnIds, int ... visibleColumnIds) {
        super(columnNames, fiexedVisibleColumnIds, visibleColumnIds);
    }

    @Override
    public void removeAll() {
        if (this.getRowList().isEmpty()) {
            return;
        }
        this.getRowList().clear();
        this.fireTableDataChanged();
    }

    @Override
    public void removeRow(TableRow ... targetRows) {
        if (null == targetRows || targetRows.length == 0 || this.getRowList().isEmpty()) {
            return;
        }
        LinkedList<TableRow> validRows = new LinkedList<TableRow>();
        HashSet removeIdentifiers = new HashSet(0);
        int firstRow = -1;
        int lastRow = -1;
        int currentRow = 0;
        for (TableRow targetRow : targetRows) {
            if (!this.getRowList().contains(targetRow) || -1 == (currentRow = this.getRowList().indexOf(targetRow))) continue;
            if (firstRow < 0 || lastRow < 0) {
                lastRow = firstRow = currentRow;
            } else {
                firstRow = Math.min(firstRow, currentRow);
                lastRow = Math.max(lastRow, currentRow);
            }
            validRows.add(targetRow);
            removeIdentifiers.add(targetRow.getIdentifier());
        }
        this.removeRowFor(validRows, firstRow, lastRow);
    }

    private void removeRowFor(List<TableRow> validRows, int firstRow, int lastRow) {
        if (firstRow >= 0 && lastRow >= 0) {
            this.fireTableRowsDeleted(firstRow, lastRow);
        }
        if (!validRows.isEmpty()) {
            this.getRowList().removeAll(validRows);
            this.fireTableDataChanged();
        }
    }

    @Override
    public void addRow(TableRow ... rows) {
        if (null == rows || rows.length == 0) {
            return;
        }
        int firstRow = this.getRowList().size();
        int removeItems = 0;
        ArrayList<TableRow> updateList = new ArrayList<TableRow>(0);
        for (TableRow row : rows) {
            if (this.getRowList().contains(row)) {
                this.getRowList().remove(row);
                ++removeItems;
                LOGGER.error("Override the reduplicate the TableRow: " + row.getIdentifier());
            }
            this.getRowList().add(row);
            updateList.add(row);
        }
        if (rows.length == removeItems && rows.length > 0) {
            super.updateRow(updateList);
            return;
        }
        int endRow = firstRow + rows.length - removeItems - 1;
        if (firstRow <= endRow) {
            this.fireTableRowsInserted(firstRow, endRow);
        }
    }

    public void addRows(List<TableRow> rows) {
        for (TableRow row : rows) {
            this.addRow(row);
        }
    }
}

