/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text;

import com.huawei.ism.ui.swing.text.RegexDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CallCenterDocument
extends RegexDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallCenterDocument.class);
    private static final String SPECIAL_CHAR = "+";
    private static final int LOCATION = 0;
    private static final long serialVersionUID = 4484807512382654464L;
    private int lengthLimit;

    public CallCenterDocument(String regex, int inputNumberLimit) {
        super(regex);
        this.lengthLimit = inputNumberLimit;
    }

    @Override
    public void insertString(int offs, String newContent, AttributeSet attr) {
        try {
            String proposedInsert;
            try {
                proposedInsert = this.getText(0, offs) + newContent + this.getText(offs, this.getLength() - offs);
            }
            catch (BadLocationException e) {
                LOGGER.error("", (Throwable)e);
                return;
            }
            if (this.lengthLimit < proposedInsert.length()) {
                return;
            }
            if (0 < offs && SPECIAL_CHAR.equals(newContent)) {
                return;
            }
            super.insertString(offs, newContent, attr);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

