/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.PropertyPaneAction;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

class ButtonPane
extends JPanel {
    private static final long serialVersionUID = -8733501109278820368L;
    private static final int BUTTON_MARGIN = 5;
    private JPanel customePane = null;
    private List<PropertyPaneAction> btnActionList = new ArrayList<PropertyPaneAction>(0);
    private List<PropertyPaneAction> menuActions = new LinkedList<PropertyPaneAction>();

    public ButtonPane() {
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.customePane = UCD.createBoxLayoutPane(0);
        this.add(this.customePane);
    }

    public final void addCustomPane(JComponent component) {
        Assert.notNull(component);
        this.customePane.add(component);
        this.customePane.add(Box.createHorizontalStrut(5));
    }

    public final void addButton(String deviceID, PropertyPaneAction ... actions) {
        Assert.notNull(deviceID);
        Assert.notNullArray(actions);
        JButton button = null;
        Dimension size = null;
        for (PropertyPaneAction action : actions) {
            action.setDeviceID(deviceID);
            this.btnActionList.add(action);
            button = new JButton(action);
            size = UCD.computeButtonPreferredSize(button, true);
            UCD.setJComponentSize(button, size);
            button.setFocusable(false);
            SwingUtil.setName(button);
            this.add(button);
            this.add(Box.createHorizontalStrut(5));
        }
    }

    public final void addGroupButton(String deviceID, PropertyPaneAction ... actions) {
        Assert.notNull(deviceID);
        Assert.notNullArray(actions);
        if (!this.btnActionList.isEmpty()) {
            this.add(Box.createHorizontalStrut(7));
        }
        this.addButton(deviceID, actions);
    }

    public final void addMenus(PropertyPaneAction ... actions) {
        Assert.notNullArray(actions);
        for (PropertyPaneAction action : actions) {
            if (null == action || this.menuActions.contains(action)) continue;
            this.menuActions.add(action);
        }
    }

    public void updateActions(String deviceID, IsmTable table, TableRow<?, ?> associatedRow) {
        int[] selectedRowIndics = table.getSelectedRows();
        ArrayList<Object> rowData = new ArrayList<Object>(0);
        DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
        TableRow row = null;
        for (int selectedRowIndic : selectedRowIndics) {
            row = tableModel.getRow(table.convertRowIndexToModel(selectedRowIndic));
            rowData.add(row.getUserObject());
        }
        Object object = this.btnActionList.iterator();
        while (object.hasNext()) {
            PropertyPaneAction action = (PropertyPaneAction)object.next();
            this.updateAction(deviceID, associatedRow, rowData, action);
        }
        for (PropertyPaneAction action : this.menuActions) {
            this.updateAction(deviceID, associatedRow, rowData, action);
        }
    }

    private void updateAction(String deviceID, TableRow<?, ?> associatedRow, List<Object> rowData, PropertyPaneAction action) {
        action.setUserObject(rowData);
        action.setAssocitedData("AssotiatedRow", associatedRow);
        action.setDeviceID(deviceID);
        action.update();
    }

    public Collection<PropertyPaneAction> getMenuActions() {
        return this.menuActions;
    }
}

