/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets.settingpane;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class SettingsRightPane<T extends JComponent, M>
extends JPanel {
    private static final int MARGIN = 4;
    private JPanel buttonPane;
    private T rightView;
    private String deviceIdentifer;
    private Window parent;
    private JComboBox selectedDeviceCombBox = null;
    private M rightPaneMemo;

    public SettingsRightPane() {
        this.doLayoutUI();
        this.addHandler();
    }

    public SettingsRightPane(String deviceID) {
        this.deviceIdentifer = deviceID;
        this.doLayoutUI();
        this.addHandler();
        if (this.needShowMultDevice() && this.showMultDevice()) {
            this.initSelectDeviceData();
            this.addSelectDeviceHandler();
        }
    }

    protected abstract T createView();

    protected abstract M createMemo();

    protected abstract void doResumeTask(M var1);

    protected abstract String getItemTitle();

    protected abstract boolean doInitTask() throws IsmException;

    protected abstract void addHandler();

    protected abstract String getDescription();

    protected abstract String getHelpKey();

    protected T getView() {
        return this.rightView;
    }

    protected final void refreshMemo(M memo) {
        this.rightPaneMemo = memo;
    }

    boolean onInitCommand() {
        boolean initResult = this.doInitTask();
        if (initResult) {
            this.refreshMemo(this.createMemo());
        }
        return initResult;
    }

    protected void afterShow() {
    }

    protected void doTaskBeforeHiding() {
    }

    protected final void doCancelTask() {
        if (null == this.rightPaneMemo) {
            return;
        }
        this.doResumeTask(this.rightPaneMemo);
    }

    protected boolean isChanged() {
        return false;
    }

    protected void addButton(JButton ... buttons) {
        Assert.notNullArray(buttons);
        for (JButton button : buttons) {
            this.buttonPane.add(button);
            this.buttonPane.add(Box.createHorizontalStrut(8));
        }
    }

    protected final Window getParentWindow() {
        return this.parent;
    }

    void setParentWindow(Window parentTemp) {
        this.parent = parentTemp;
    }

    protected final String getDeviceID() {
        return this.deviceIdentifer;
    }

    protected void setDeviceID(String deviceID) {
        this.deviceIdentifer = deviceID;
    }

    private void doLayoutUI() {
        this.buttonPane = UCD.createBoxLayoutPane(0);
        Box southBox = Box.createHorizontalBox();
        southBox.add(this.buttonPane);
        southBox.add(Box.createHorizontalStrut(10));
        southBox.add(Box.createHorizontalGlue());
        this.setOpaque(false);
        this.setLayout(new BorderLayout(4, 4));
        this.rightView = this.createView();
        String description = this.getDescription();
        if (null != description && !"".equals(description.trim())) {
            JPanel infoPane = this.newInformationPanel(description, ResourceManager.getImage("bulb.png"));
            if (this.needShowMultDevice() && this.showMultDevice()) {
                Box topPane = UCD.buildVBoxTop(12, infoPane, this.getSelectedDevicePanel());
                topPane.setBorder(new EmptyBorder(0, 0, 8, 0));
                this.add((Component)topPane, "North");
            } else {
                infoPane.setBorder(new EmptyBorder(0, 0, 8, 0));
                this.add((Component)infoPane, "North");
            }
        }
        this.add((Component)this.rightView, "Center");
        this.add((Component)southBox, "South");
    }

    private JPanel newInformationPanel(String description, ImageIcon imageIcon) {
        IsmTextArea infoArea = UCD.createTextArea(description);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BorderLayout());
        if (null != imageIcon) {
            JLabel info = new JLabel(imageIcon);
            info.setName("ISMV1R2_framework_newInformationPanel_info");
            JPanel imagePanel = UCD.createBoxLayoutPane(0);
            imagePanel.add(info);
            imagePanel.add(Box.createHorizontalStrut(15));
            infoPanel.add((Component)imagePanel, "West");
        }
        infoPanel.add((Component)infoArea, "Center");
        infoPanel.setOpaque(false);
        return infoPanel;
    }

    private JComponent getSelectedDevicePanel() {
        this.selectedDeviceCombBox = new JComboBox();
        UCD.setJComponentSize(this.selectedDeviceCombBox, new Dimension(320, 23));
        JLabel selectedDeviceLable = new JLabel(ResourceManager.getString("LOGICALARRAYSPROPERTYPANE.ARRAYNAME") + ":");
        selectedDeviceLable.setFont(IsmFontFactory.getBold12Font());
        Box box = UCD.buildHBoxLeft(selectedDeviceLable, this.selectedDeviceCombBox);
        box.setBorder(new EmptyBorder(0, 8, 0, 0));
        return box;
    }

    protected boolean showMultDevice() {
        if (null == this.getDeviceID()) {
            return false;
        }
        Launcher launcher = CommonUtil.getLauncher(this.getDeviceID());
        if (null != launcher) {
            List<String> deviceIDs = launcher.getSubDeviceIDs();
            return !Utils.isNullList(deviceIDs);
        }
        return false;
    }

    protected boolean needShowMultDevice() {
        return false;
    }

    protected void initSelectDeviceData() {
        if (null == this.deviceIdentifer) {
            return;
        }
        int selectedIndex = this.selectedDeviceCombBox.getSelectedIndex();
        this.selectedDeviceCombBox.removeAllItems();
        Launcher launcher = CommonUtil.getLauncher(this.deviceIdentifer);
        Pair<String, String> devicePair = new Pair<String, String>(this.deviceIdentifer, CommonUtil.getDeviceName(this.deviceIdentifer));
        this.selectedDeviceCombBox.addItem(devicePair);
        if (null != launcher) {
            List<String> deviceIDs = launcher.getSubDeviceIDs();
            for (String deviceID : deviceIDs) {
                devicePair = new Pair<String, String>(deviceID, CommonUtil.getDeviceName(deviceID));
                this.selectedDeviceCombBox.addItem(devicePair);
            }
        }
        if (-1 != selectedIndex) {
            this.selectedDeviceCombBox.setSelectedIndex(selectedIndex);
        }
    }

    private void addSelectDeviceHandler() {
        this.selectedDeviceCombBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SettingsRightPane.this.selectedDeviceHandler();
                }
            }
        });
    }

    protected void selectedDeviceHandler() {
        String deviceID = this.getSelectedDeviceID();
        if (this.getDeviceID().equals(deviceID)) {
            return;
        }
        if (null != deviceID) {
            this.setDeviceID(deviceID);
        }
    }

    protected String getSelectedDeviceID() {
        Pair selectedPair = (Pair)this.selectedDeviceCombBox.getSelectedItem();
        if (null != selectedPair) {
            return (String)selectedPair.getKey();
        }
        return null;
    }

    protected boolean isShowErrorInfor() {
        return false;
    }

    protected String getErrorInfor() {
        return null;
    }

    protected String getButtonText() {
        return null;
    }
}

