/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets.wizard;

import com.huawei.ism.ui.forms.help.HelpManager;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.templets.wizard.Card;
import com.huawei.ism.ui.templets.wizard.Wizard;
import com.huawei.ism.ui.templets.wizard.WizardModel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WizardHandler
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardHandler.class);
    private Wizard wizard;

    public WizardHandler(Wizard wizard) {
        this.wizard = wizard;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Wizard.EWizardButton buttonE = Wizard.EWizardButton.getEWizardButtonBy(actionEvent.getActionCommand());
            if (buttonE == null) {
                return;
            }
            switch (buttonE) {
                case Previous: {
                    this.doPreviousTask();
                    break;
                }
                case Next: {
                    this.doNextTask();
                    break;
                }
                case Cancel: 
                case CLOSE: {
                    this.doCancelTask();
                    break;
                }
                case Complete: {
                    this.doFinishTask();
                    break;
                }
                case Help: {
                    this.doHelpTask();
                    break;
                }
            }
        }
        catch (RuntimeException exception) {
            DialogUtils.showErrorDialog((Window)this.wizard, (Throwable)exception);
            LOGGER.error("", (Throwable)exception);
        }
    }

    private void doNextTask() {
        Card card = this.getCurrentCard();
        if (!card.onNextCommand()) {
            return;
        }
        Card.StepID nextStepID = card.getCurrentStep().getNextStepID();
        WizardModel model = this.wizard.getModel();
        Card nextCard = model.getCardBy(nextStepID);
        if (!nextCard.onInitCommand()) {
            return;
        }
        this.wizard.setCurrentCard(nextStepID);
    }

    private void doPreviousTask() {
        Card card = this.getCurrentCard();
        if (!card.onPreviousCommand()) {
            return;
        }
        this.wizard.setCurrentCard(card.getCurrentStep().getPrevStepID());
    }

    private void doCancelTask() {
        this.wizard.dispose();
    }

    private void doFinishTask() {
        Card card = this.getCurrentCard();
        if (!card.onFinishCommand()) {
            return;
        }
        WizardModel model = this.wizard.getModel();
        Card nextCard = model.getCardBy(Card.StepID.FinishedCard);
        if (!nextCard.onInitCommand()) {
            return;
        }
        this.wizard.setCurrentCard(Card.StepID.FinishedCard);
    }

    private void doHelpTask() {
        Card card = this.getCurrentCard();
        String helpKey = card.getHelpKey();
        HelpManager.getInstance().displayHelp(helpKey);
    }

    private Card getCurrentCard() {
        WizardModel model = this.wizard.getModel();
        Card card = model.getCurrentCard();
        return card;
    }
}

