/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets.wizard;

import com.huawei.ism.ui.templets.wizard.Card;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class WizardModel {
    public static final String CURRENT_CARD_IDENTIFIER_PROPERTY = "currentCardIdentifierProperty";
    public static final String REARRANGE_CARD_BUTTON_PROPERTY = "rearrangeCardButtonProperty";
    private PropertyChangeSupport propertyChangeSupport;
    private Map<Card.StepID, Card> cardMap;
    private Card currentCard;
    private Object summaryContext;
    private Map<String, Object> mutualDataMap = new HashMap<String, Object>(0);

    public WizardModel() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.cardMap = new EnumMap<Card.StepID, Card>(Card.StepID.class);
    }

    public final void addCard(Card.StepID stepID, Card card) {
        this.cardMap.put(stepID, card);
    }

    public final void removeCard(Card.StepID stepID) {
        this.cardMap.remove((Object)stepID);
    }

    final Card getCardBy(Card.StepID stepID) {
        return this.cardMap.get((Object)stepID);
    }

    public void setSummaryContext(Object summaryContext) {
        this.summaryContext = summaryContext;
    }

    public Object getSummaryContext() {
        return this.summaryContext;
    }

    public void addMutualData(String key, Object mutualData) {
        this.mutualDataMap.put(key, mutualData);
    }

    public void removeMutalData(String key) {
        if (this.mutualDataMap.containsKey(key)) {
            this.mutualDataMap.remove(key);
        }
    }

    public Object getMutualData(String key) {
        return this.mutualDataMap.get(key);
    }

    Card getCurrentCard() {
        return this.currentCard;
    }

    void setCurrentCard(Card.StepID stepID) {
        Card toBeOperatedCard = this.getCardBy(stepID);
        if (toBeOperatedCard == null) {
            throw new IllegalArgumentException();
        }
        Card oldCard = this.currentCard;
        this.currentCard = toBeOperatedCard;
        if (oldCard != this.currentCard) {
            this.firePropertyChange(CURRENT_CARD_IDENTIFIER_PROPERTY, oldCard, this.currentCard);
        }
    }

    boolean arrivedFirstCard() {
        return this.getCurrentCard().getCurrentStepID() == Card.StepID.FirstCard;
    }

    boolean arraivedSummaryCard() {
        Card.Step step = null;
        step = null == this.getCurrentCard().getCurrentCardStep() ? this.getCurrentCard().getStep() : this.getCurrentCard().getCurrentCardStep();
        int currentStep = step.getCurrentStep();
        int totalStep = step.getTotalStep();
        return currentStep == totalStep;
    }

    boolean arrivedFinishCard() {
        Card.Step step = null;
        step = null == this.getCurrentCard().getCurrentCardStep() ? this.getCurrentCard().getStep() : this.getCurrentCard().getCurrentCardStep();
        return Card.FINISH_STEP == step;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

