/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.widgets.action;

import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.ui.widgets.action.BaseAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class ActionFactory {
    private static ActionFactory instance;
    private static Map<String, ActionFactory> actionFactoryMap;
    private Map<String, BaseAction<?>> actionMapFor = new Hashtable(0);

    private ActionFactory() {
    }

    public static ActionFactory getInstance() {
        if (null == instance) {
            instance = new ActionFactory();
        }
        return instance;
    }

    public BaseAction<?> getAction(String deviceType, String actionID) {
        if (null == deviceType || null == actionID) {
            throw new IllegalArgumentException("The params is illeagal!");
        }
        ActionFactory factory = actionFactoryMap.get(deviceType);
        if (null == factory) {
            factory = actionFactoryMap.get(DeviceType.OCEAN_STOR.name());
        }
        BaseAction<?> action = factory.getAction(actionID);
        return action;
    }

    private BaseAction<?> getAction(String actionID) {
        BaseAction<?> action = this.actionMapFor.get(actionID);
        return action;
    }

    public void registerAction(String deviceType, Map<String, BaseAction<?>> actions) {
        ActionFactory factory = this.getActionFactory(deviceType);
        factory.registerAction(actions);
    }

    public synchronized void registerAction(String deviceType, String actionID, BaseAction<?> action) {
        ActionFactory factory = this.getActionFactory(deviceType);
        HashMap proxyMap = new HashMap(0);
        this.actionMapFor.put(actionID, action);
        factory.registerAction(proxyMap);
    }

    private void registerAction(Map<String, BaseAction<?>> actionMap) {
        this.actionMapFor.putAll(actionMap);
    }

    private ActionFactory getActionFactory(String deviceType) {
        if (null == deviceType || "".equals(deviceType)) {
            throw new IllegalArgumentException("The params deviceType is illegal!");
        }
        ActionFactory factory = actionFactoryMap.get(deviceType);
        if (null == factory) {
            factory = new ActionFactory();
            actionFactoryMap.put(deviceType, factory);
        }
        return factory;
    }

    static {
        actionFactoryMap = new HashMap<String, ActionFactory>(0);
    }
}

