/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.widgets.propertypane;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.ui.swing.dialog.ErrorDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.templets.PropertyPaneAction;
import com.huawei.ism.ui.templets.WizardDialog;
import com.huawei.ism.ui.widgets.dialog.DevicesCard;
import com.huawei.ism.util.SwingUtil;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncPerformanceAction
extends PropertyPaneAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncPerformanceAction.class);
    private static final long serialVersionUID = 1L;

    @Override
    public void actionPerformed(List<Object> rowUserObject) {
        if (rowUserObject.size() < 1) {
            return;
        }
        String deviceID = (String)rowUserObject.get(0);
        Frame parent = Framework.getInstance().getMainFrame();
        ArrayList<String> stepNames = new ArrayList<String>(0);
        stepNames.add(ResourceManager.getString("COMMON_TXT_SELECT_CONFIG_DATA"));
        stepNames.add(ResourceManager.getString("COMMON_TXT_SELECT_TAEGET_DEVICE"));
        Launcher launcher = LauncherManager.getInstance().getLauncher(deviceID);
        HashMap<String, Object> outArgs = new HashMap<String, Object>(0);
        try {
            launcher.invokeMethod("QueryConfigData", new HashMap<String, Object>(0), outArgs);
        }
        catch (IsmException e) {
            LOGGER.error("", (Throwable)e);
            ErrorDialog errorDialog = new ErrorDialog(parent, e.getErrorMessage());
            errorDialog.setVisible(true);
            return;
        }
        WizardDialog configSynWizard = new WizardDialog(parent, stepNames, new String[0]);
        SelectedConfigDataCard firstCard = new SelectedConfigDataCard(deviceID, outArgs);
        configSynWizard.setFirstCard(firstCard);
        SwingUtil.putParentCenter(configSynWizard, Framework.getInstance().getMainFrame());
        configSynWizard.setVisible(true);
    }

    @Override
    protected boolean isAvailable() {
        List rowUserObject = (List)this.getUserObject();
        if (rowUserObject != null && rowUserObject.size() == 1) {
            String deviceID = (String)rowUserObject.get(0);
            Launcher launcher = LauncherManager.getInstance().getLauncher(deviceID);
            if (null != launcher && null != launcher.getAction("syncPerformace")) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected PropertyPaneAction.MenuInfo getMenuInfo() {
        return new PropertyPaneAction.MenuInfo(null, "device");
    }

    @Override
    public String getReason(List<Object> rowUserObject) {
        String reasonStr = super.getReason(rowUserObject);
        if (reasonStr != null) {
            return reasonStr;
        }
        if (null == rowUserObject || rowUserObject.isEmpty()) {
            return ResourceManager.getString("NO_SELECT_OBJECT");
        }
        if (rowUserObject.size() > 1) {
            return ResourceManager.getString("SELECT_ONE_OBJECT_AT_MOST");
        }
        return null;
    }

    private static class DeviceCompletedCard
    extends DevicesCard {
        private static final long serialVersionUID = 6511026556320151862L;
        private Map<String, Object> configDataMap;

        public DeviceCompletedCard(WizardDialog.Card prevCard, Map<String, Object> configDataMap, String deviceID) {
            super(new String[]{deviceID}, prevCard, WizardDialog.Navigation.Previous, WizardDialog.Navigation.Complete);
            this.configDataMap = configDataMap;
        }

        @Override
        protected boolean process(WizardDialog.Navigation navigation) {
            if (navigation == WizardDialog.Navigation.Complete) {
                this.processCompleteEvent();
                return true;
            }
            if (navigation == WizardDialog.Navigation.Previous) {
                return true;
            }
            return navigation == WizardDialog.Navigation.Cancel;
        }

        private void processCompleteEvent() {
            ArrayList<Callable> calls = new ArrayList<Callable>(0);
            Callable call = null;
            for (final String selectedDeviceID : this.getSelectedDeviceIDs()) {
                call = new Callable(){

                    public Object call() throws Exception {
                        Launcher launcher = LauncherManager.getInstance().getLauncher(selectedDeviceID);
                        launcher.invokeMethod("SyncConfigData", configDataMap, new HashMap<String, Object>(0));
                        return null;
                    }
                };
                calls.add(call);
            }
            AsyncExcutor.batchExecute(this.getSelectedDeviceIDs(), calls);
        }

        @Override
        protected boolean isValid(WizardDialog.Navigation navigation) {
            if (navigation == WizardDialog.Navigation.Cancel) {
                return true;
            }
            if (navigation == WizardDialog.Navigation.Complete) {
                return this.getSelectedDeviceIDs().size() > 0;
            }
            return navigation == WizardDialog.Navigation.Previous;
        }

        @Override
        public String getTitle() {
            return ResourceManager.getString("COMMON_TXT_SYNC_CONFIG_DATA");
        }

        @Override
        public int getStep() {
            return 1;
        }

        @Override
        protected WizardDialog.Card getNextCard() {
            return null;
        }

        @Override
        protected String getHelpID() {
            return "sync_config";
        }
    }

    class SelectedConfigDataCard
    extends WizardDialog.Card {
        private static final long serialVersionUID = 1L;
        private String deviceID;
        private Map<String, Object> configDataMap;
        private Map<String, Object> selectedConfigDataMap;
        private String[] cns;

        public SelectedConfigDataCard(String devcieID, Map<String, Object> configDataMap) {
            super(null, WizardDialog.Navigation.Next);
            this.selectedConfigDataMap = new HashMap<String, Object>(0);
            this.cns = new String[]{ResourceManager.getString("COMMON_TXT_CONFIG_ITEM"), ResourceManager.getString("COMMON_TXT_DETAIL")};
            this.deviceID = devcieID;
            this.configDataMap = configDataMap;
            DefaultTableModel tableModel = new DefaultTableModel(this.cns, 0, 1);
            List<TableRow> tableRows = this.getTableRows();
            TableRow[] rows = tableRows.toArray(new TableRow[0]);
            tableModel.setTableData(rows);
            final IsmTable table = new IsmTable(tableModel);
            table.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    List<TableRow> markedRows = table.getMarkedRows();
                    SelectedConfigDataCard.this.selectedConfigDataMap.clear();
                    for (TableRow row : markedRows) {
                        SelectedConfigDataCard.this.selectedConfigDataMap.put((String)row.getIdentifier(), row.getUserObject());
                    }
                    SelectedConfigDataCard.this.updateNavigationBar();
                }
            });
            TableScrollPane tablePanel = new TableScrollPane(table, false, true);
            this.add(tablePanel);
        }

        private List<TableRow> getTableRows() {
            ArrayList<TableRow> tableData = new ArrayList<TableRow>(0);
            DefaultTableRow<Object, String> rowData = null;
            for (Map.Entry<String, Object> entry : this.configDataMap.entrySet()) {
                rowData = new DefaultTableRow<Object, String>(2, entry.getValue(), entry.getKey());
                rowData.setValueAt(0, entry.getKey());
                rowData.setValueAt(1, entry.getValue());
                tableData.add(rowData);
            }
            return tableData;
        }

        @Override
        protected String getHelpID() {
            return "sync_config";
        }

        @Override
        protected WizardDialog.Card getNextCard() {
            return new DeviceCompletedCard((WizardDialog.Card)this, this.getSelectedConfigDataMap(), this.deviceID);
        }

        @Override
        public int getStep() {
            return 0;
        }

        @Override
        public String getTitle() {
            return ResourceManager.getString("COMMON_TXT_SYNC_CONFIG_DATA");
        }

        protected Map<String, Object> getSelectedConfigDataMap() {
            if (this.selectedConfigDataMap == null) {
                this.selectedConfigDataMap = new HashMap<String, Object>(0);
            }
            return this.selectedConfigDataMap;
        }

        @Override
        protected boolean isValid(WizardDialog.Navigation navigation) {
            if (navigation == WizardDialog.Navigation.Cancel) {
                return true;
            }
            return this.getSelectedConfigDataMap().size() > 0;
        }

        @Override
        protected boolean process(WizardDialog.Navigation navigation) {
            return true;
        }
    }
}

