/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.mainframe.device;

import com.huawei.ism.FrameworkCommon;
import com.huawei.ism.common.Framework;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.forms.lockui.RefreshUIThread;
import com.huawei.ism.ui.module.event.EventBuzzHandle;
import com.huawei.ism.ui.module.event.EventManager;
import com.huawei.ism.ui.module.task.BackgroundTask;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui2.mainframe.device.DevicePane;
import com.huawei.ism.ui2.mainframe.device.ErrorPane;
import com.huawei.ism.ui2.mainframe.device.LoginLoadingPane;
import com.huawei.ism.ui2.mainframe.device.NewLoginPane;
import com.huawei.ism.ui2.mainframe.device.ResourceLoadingPane;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.NetUtil;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceApplet
extends JApplet {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceApplet.class);
    private static final long serialVersionUID = -6149901249621898234L;
    private NewLoginPane loginPane;
    private ErrorPane errorPane;
    private Dimension minDimension = new Dimension(1024, 768);
    private ResourceLoadingPane resourceLoadingPane;
    private LoginLoadingPane loginLoadingPane;
    private boolean alreadyClosedClient = false;
    private boolean isCloseWeb = false;
    private boolean isResourceLoadSucceded = false;

    public DeviceApplet(NewLoginPane loginPane) throws HeadlessException {
        this.loginPane = loginPane;
    }

    @Override
    public void init() {
        super.init();
        String ismArg = this.getParameter("ISM_ARGS");
        FrameworkCommon.getInstance().init(ismArg);
        this.logEnvInfo();
        this.resourceLoadingPane = new ResourceLoadingPane(ismArg);
        this.setLayout(new BorderLayout());
        this.add((Component)this.resourceLoadingPane, "Center");
        ResouceLoadListener resouceLoadListener = new ResouceLoadListener(this.resourceLoadingPane);
        ThreadPoolManager.getInstance().execute(resouceLoadListener);
        LoadingResourceThread loadingResourceThread = new LoadingResourceThread(this);
        ThreadPoolManager.getInstance().execute(loadingResourceThread);
        ResourceLoadObserver resourceLoadObserver = new ResourceLoadObserver(this);
        ThreadPoolManager.getInstance().execute(resourceLoadObserver);
    }

    private void addHandler() {
        JButton button = this.loginPane.getLoginButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceApplet.this.startMainFrame();
            }
        });
    }

    private static String checkInputIp(String ip) {
        String actualIp = ip;
        if (null == actualIp || actualIp.length() < 1) {
            actualIp = "127.0.0.1";
        } else {
            int start = actualIp.indexOf("[");
            int end = actualIp.indexOf("]");
            if (start >= 0 && end > 0) {
                actualIp = actualIp.substring(start + 1, end);
            } else {
                if (NetUtil.isValidIPV6(actualIp)) {
                    return actualIp;
                }
                String[] ipString = actualIp.split(":");
                if (ipString.length > 0) {
                    actualIp = ipString[0];
                }
            }
        }
        return actualIp;
    }

    private void startMainFrame() {
        if (!this.loginPane.validateInput()) {
            return;
        }
        this.loginLoadingPane = new LoginLoadingPane();
        this.getContentPane().removeAll();
        this.add((Component)this.loginLoadingPane, "Center");
        this.validate();
        this.repaint();
        RefreshUIThread refreshUIThread = new RefreshUIThread(this);
        refreshUIThread.start();
        Framework.getInstance().setRefreshUIThread(refreshUIThread);
        LoginingListener loginingListener = new LoginingListener(this);
        ThreadPoolManager.getInstance().execute(loginingListener);
    }

    public void logout() {
        this.closeLaunchersByApplet();
    }

    public void closeLaunchersByApplet() {
        this.isCloseWeb = true;
        this.closeApplet();
    }

    public void closeLaunchers() {
        this.isCloseWeb = false;
        Window parentWindow = SwingUtilities.windowForComponent(this);
        SwingUtil.runInEventDispatchThread(new MyCustLanguageTask(parentWindow));
    }

    public void closeApplet() {
        if (this.alreadyClosedClient) {
            return;
        }
        final ProgressDialog progressDialog = new ProgressDialog((Window)Framework.getInstance().getMainFrame());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    LauncherManager.getInstance().deleteDeives();
                }
                catch (Exception e) {
                    LOGGER.error("", (Throwable)e);
                }
                finally {
                    DeviceApplet.this.closeProgressDialog(progressDialog);
                }
            }
        };
        ThreadPoolManager.getInstance().executeAndLogException(runnable);
        progressDialog.setVisible(true);
    }

    private void closeProgressDialog(final JDialog progressDialog) {
        SwingUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (progressDialog != null) {
                    progressDialog.setVisible(false);
                    progressDialog.dispose();
                }
                DeviceApplet.this.closeClient();
            }
        });
    }

    private void closeClient() {
        this.alreadyClosedClient = true;
        try {
            LOGGER.info("logout.");
            if (this.isCloseWeb) {
                this.getAppletContext().showDocument(new URL("javascript:window.close();"));
            }
        }
        catch (RuntimeException e) {
            Runtime.getRuntime().exit(0);
        }
        catch (Exception e) {
            Runtime.getRuntime().exit(0);
        }
    }

    private void showErrorPane(JApplet jApplet) {
        this.errorPane = new ErrorPane(this.getParameter("ISM_ARGS"));
        jApplet.remove(this.resourceLoadingPane);
        jApplet.add((Component)this.errorPane, "Center");
        jApplet.validate();
        jApplet.repaint();
        jApplet.requestFocus();
    }

    private void logEnvInfo() {
        try {
            StringBuffer bs = new StringBuffer();
            bs.append("#JAVA:java.version " + System.getProperty("java.version"));
            bs.append("/java.home " + System.getProperty("java.home"));
            bs.append("/java.vm.version " + System.getProperty("java.vm.version"));
            bs.append("#OS:os.name " + System.getProperty("os.name"));
            bs.append("/os.arch " + System.getProperty("os.arch"));
            bs.append("/os.version " + System.getProperty("os.version"));
            bs.append("#ISM:ism.home " + System.getProperty("user.home"));
            bs.append("/ism.dir " + System.getProperty("user.dir"));
            LOGGER.info(StringUtils.getCleanMessage(bs.toString()));
        }
        catch (Exception e) {
            LOGGER.error("get enviroment log infomation error " + e);
        }
    }

    private class LoginingListener
    implements Runnable {
        private DeviceApplet jApplet;

        public LoginingListener(DeviceApplet jApplet) {
            this.jApplet = jApplet;
        }

        @Override
        public void run() {
            String ip = Framework.getInstance().getStrProperty("-ip");
            ip = DeviceApplet.checkInputIp(ip);
            String useSSL = Framework.getInstance().getStrProperty("-useSSL");
            if (null == useSSL) {
                useSSL = String.valueOf(1);
            }
            DeviceType deviceType = DeviceType.valueOf(Framework.getInstance().getStrProperty("-devicetype"));
            DeviceContext context = new DeviceContext(DeviceApplet.this.loginPane.getUserName(), DeviceApplet.this.loginPane.getPassword(), new String[]{ip}, DeviceApplet.this.loginPane.getUserScope());
            context.setDeviceType(deviceType);
            context.setProtocalType(DeviceContext.ProtocalType.HTTP);
            context.setUseSSL(useSSL);
            BackgroundTask task = CommonUtil.createDiscoveryBGTask("0:" + context.getPreferedIP(), context.getPreferedIP());
            try {
                LauncherManager.getInstance().discovery(context, task);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                this.doException(e);
                return;
            }
            DeviceApplet.this.loginPane.add2History(DeviceApplet.this.loginPane.getUserName());
            List<DeviceContext> contexts = LauncherManager.getInstance().getDeviceContexts();
            if (contexts.isEmpty()) {
                this.doException(null);
                return;
            }
            context = contexts.get(0);
            EventManager.getInstance().addEventManagerListener(EventBuzzHandle.getInstance());
            DevicePane devicePane = new DevicePane(context, this.jApplet);
            this.jApplet.getContentPane().removeAll();
            this.jApplet.add((Component)devicePane, "Center");
            this.jApplet.validate();
            this.jApplet.repaint();
        }

        private void doException(Exception e) {
            this.jApplet.getContentPane().removeAll();
            this.jApplet.add((Component)DeviceApplet.this.loginPane, "Center");
            this.jApplet.getRootPane().setDefaultButton(DeviceApplet.this.loginPane.getLoginButton());
            this.jApplet.validate();
            this.jApplet.repaint();
            this.jApplet.requestFocus();
            Window parent = SwingUtilities.getWindowAncestor(this.jApplet);
            if (null == e) {
                DialogUtils.showErrorDialog(parent, ResourceManager.getString("SERVER_INNER_ERROR"));
            } else {
                DialogUtils.showErrorDialog(parent, (Throwable)e);
            }
            LauncherManager.getInstance().clearMapOfDeviceInfo();
        }
    }

    private static class ResouceLoadListener
    implements Runnable {
        private int cPer = 0;
        private int cIndex = 0;
        private int resouceCount = 27104;
        private ResourceLoadingPane loadingPane = null;

        public ResouceLoadListener(ResourceLoadingPane loadingPane) {
            this.loadingPane = loadingPane;
        }

        @Override
        public void run() {
            do {
                this.compProgress();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("", (Throwable)e);
                }
            } while (this.cPer < 100);
            LOGGER.info("Load progress is: 100%");
        }

        private void compProgress() {
            int countSize = ResourceManager.getResourceSize();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Resource CountSize is: " + countSize);
            }
            if (countSize == 0) {
                ++this.cIndex;
                if (this.cIndex == 20) {
                    ++this.cPer;
                    this.cIndex = 0;
                }
                this.cPer = this.cPer >= 20 ? 20 : this.cPer;
            } else {
                this.cPer = countSize * 100 / this.resouceCount;
                this.cPer = this.cPer == 0 ? 1 : this.cPer;
                this.cPer = this.cPer > 100 ? 100 : this.cPer;
            }
            this.cPer = countSize >= this.resouceCount ? 100 : this.cPer;
            this.loadingPane.setProgress(this.cPer);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Load progress:" + this.cPer);
            }
        }
    }

    private class ResourceLoadObserver
    implements Runnable {
        private static final int MINUTE = 1;
        private static final int SECOND_PER_MINUTE = 60;
        private static final int MILLI_SECOND = 1000;
        private int checkTimes = 3;
        private JApplet jApplet;

        public ResourceLoadObserver(JApplet jApplet) {
            this.jApplet = jApplet;
        }

        @Override
        public void run() {
            for (int tag = 0; tag < this.checkTimes; ++tag) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("CheckLoad success times :" + (tag + 1));
                }
                if (DeviceApplet.this.isResourceLoadSucceded) break;
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
            if (!DeviceApplet.this.isResourceLoadSucceded) {
                DeviceApplet.this.showErrorPane(this.jApplet);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Check load End,load result is " + DeviceApplet.this.isResourceLoadSucceded);
            }
        }
    }

    private class LoadingResourceThread
    implements Runnable {
        private JApplet jApplet;

        public LoadingResourceThread(JApplet jApplet) {
            this.jApplet = jApplet;
        }

        @Override
        public void run() {
            try {
                String ismArg = DeviceApplet.this.getParameter("ISM_ARGS");
                Framework.getInstance().init(ismArg);
                Locale locale = Framework.getInstance().getAvailableLocale();
                if (null == locale) {
                    locale = ResourceManager.getLocale();
                }
                IsmPlafUtils.setLocale(locale);
                JComponent.setDefaultLocale(locale);
                ResourceManager.setLocale(locale);
                FrameworkCommon.getInstance().loadVender();
                Framework.getInstance().loadLAF();
                DeviceApplet.this.loginPane = new NewLoginPane(this.jApplet);
                DeviceApplet.this.loginLoadingPane = new LoginLoadingPane();
                this.jApplet.remove(DeviceApplet.this.resourceLoadingPane);
                this.jApplet.setLayout(new BorderLayout());
                this.jApplet.add((Component)DeviceApplet.this.loginPane, "Center");
                this.jApplet.getRootPane().setDefaultButton(DeviceApplet.this.loginPane.getLoginButton());
                SwingUtil.initMainFrameSize(this.jApplet, DeviceApplet.this.minDimension);
                DeviceApplet.this.addHandler();
                Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.jApplet);
                Framework.getInstance().setMainFrame(frame);
                this.jApplet.validate();
                this.jApplet.repaint();
                this.jApplet.requestFocus();
                DeviceApplet.this.isResourceLoadSucceded = true;
                LOGGER.info("Load login pane success.");
            }
            catch (Exception e1) {
                DeviceApplet.this.showErrorPane(this.jApplet);
                LOGGER.error("Sorry,IsmSystem exit.\ncause:", (Throwable)e1);
            }
        }
    }

    private static final class MyCustLanguageTask
    implements Runnable {
        private final Window parentWindow;

        private MyCustLanguageTask(Window parentWindow) {
            this.parentWindow = parentWindow;
        }

        @Override
        public void run() {
            int size = LauncherManager.getInstance().getAllLauncherSize();
            if (size != 0) {
                try {
                    LOGGER.error("deleteDeives start");
                    LauncherManager.getInstance().deleteDeives();
                    LOGGER.error("deleteDeives end");
                }
                catch (Exception e) {
                    LOGGER.error("delete devices error " + e);
                }
            }
            if (null != this.parentWindow && this.parentWindow.isShowing()) {
                this.parentWindow.setVisible(false);
                this.parentWindow.dispose();
            }
        }
    }
}

