/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.module.event;

import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui2.module.event.EventDetail;
import com.huawei.ism.ui2.module.event.EventManagerPanel;
import com.huawei.ism.ui2.module.event.EventTabLayout;
import com.huawei.ism.ui2.module.event.FaultTabLayout;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

final class EventManagerLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel basePanel;
    private FaultTabLayout faultLayout = null;
    private EventTabLayout eventLayout = null;
    private EventDetail currentEventDetail;
    private EventDetail allEventDetail;
    private DefaultTableModel faultTableModel;
    private DefaultTableModel eventTableModel;
    private IsmTable faultTable;
    private IsmTable eventTable;
    private JTabbedPane eventTabbedPane = new JTabbedPane();

    public EventManagerLayout() {
        this.setLayout(new BorderLayout());
        this.init();
    }

    private void doLayoutUI() {
        JSplitPane currentSplitPanel = this.createSplitPane();
        JSplitPane allSplitPanel = this.createSplitPane();
        this.currentEventDetail = new EventDetail(true);
        this.allEventDetail = new EventDetail(false);
        this.eventLayout = new EventTabLayout(this.eventTable);
        this.faultLayout = new FaultTabLayout(this.faultTable);
        this.eventLayout.setMinimumSize(new Dimension(0, 0));
        this.faultLayout.setMinimumSize(new Dimension(0, 0));
        currentSplitPanel.setLeftComponent(this.faultLayout);
        currentSplitPanel.setRightComponent(this.currentEventDetail);
        allSplitPanel.setLeftComponent(this.eventLayout);
        allSplitPanel.setRightComponent(this.allEventDetail);
        this.eventTabbedPane = new JTabbedPane();
        this.eventTabbedPane.setModel(new MyCustSelectionModel());
        this.eventTabbedPane.add(ResourceManager.getString("event.current.tab.title"), currentSplitPanel);
        this.eventTabbedPane.add(ResourceManager.getString("event.all.tab.title"), allSplitPanel);
        this.eventTabbedPane.setToolTipTextAt(1, ResourceManager.getString("event.all.tab.tooltip"));
    }

    private JSplitPane createSplitPane() {
        final JSplitPane splitPane = new JSplitPane();
        double locationScale = 0.7;
        splitPane.setOpaque(false);
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.3);
        splitPane.setDividerLocation(0.7);
        splitPane.setBorder(null);
        splitPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                splitPane.setDividerLocation(0.7);
                JSplitPane splitPane2 = (JSplitPane)EventManagerLayout.this.eventTabbedPane.getSelectedComponent();
                EventDetail eventDetail = (EventDetail)splitPane2.getRightComponent();
                eventDetail.showMainPanel(true, "", true);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                splitPane.setDividerLocation(0.7);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                splitPane.setDividerLocation(0.7);
            }
        });
        return splitPane;
    }

    private void init() {
        this.initTable();
        this.doLayoutUI();
        this.basePanel = new JPanel(new BorderLayout());
        this.basePanel.add((Component)this.eventTabbedPane, "Center");
        this.basePanel.setOpaque(false);
        EventLevelListCellRenderer render = new EventLevelListCellRenderer();
        this.eventLayout.getLevelComboBox().setRenderer(render);
        this.faultLayout.getLevelComboBox().setRenderer(render);
        this.add(this.basePanel);
    }

    private void initTable() {
        this.faultTableModel = new DefaultTableModel(EventManagerLayout.getFaultColumnName(), 0, 1, 3, 4);
        this.eventTableModel = new DefaultTableModel(EventManagerLayout.getEventColumnName(), 0, 1, 3, 4, 5);
        this.faultTable = new IsmTable(this.faultTableModel);
        this.eventTable = new IsmTable(this.eventTableModel);
        TableColumnModel faultColumnModel = this.faultTable.getColumnModel();
        TableColumn columnLevel = faultColumnModel.getColumn(0);
        columnLevel.setMinWidth(80);
        columnLevel.setMaxWidth(80);
        TableColumnModel eventColumnModel = this.eventTable.getColumnModel();
        TableColumn columnEventLevel = eventColumnModel.getColumn(0);
        columnEventLevel.setMinWidth(80);
        columnEventLevel.setMaxWidth(80);
    }

    public static String[] getFaultColumnName() {
        return new String[]{ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_LEVEL"), ResourceManager.getString("ALL_ARRAYS_NAME"), ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_ID"), ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_DESC"), ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_START_TIME")};
    }

    public static String[] getEventColumnName() {
        return new String[]{ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_LEVEL"), ResourceManager.getString("ALL_ARRAYS_NAME"), ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_ID"), ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_DESC"), ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_START_TIME"), ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_RECOVER_TIME")};
    }

    public FaultTabLayout getFaultLayout() {
        return this.faultLayout;
    }

    public void setFaultLayout(FaultTabLayout faultLayout) {
        this.faultLayout = faultLayout;
    }

    public EventTabLayout getEventLayout() {
        return this.eventLayout;
    }

    public void setEventLayout(EventTabLayout eventLayout) {
        this.eventLayout = eventLayout;
    }

    public EventDetail getCurrentEventDetail() {
        return this.currentEventDetail;
    }

    public void setCurrentEventDetail(EventDetail currentEventDetail) {
        this.currentEventDetail = currentEventDetail;
    }

    public DefaultTableModel getFaultTableModel() {
        return this.faultTableModel;
    }

    public void setFaultTableModel(DefaultTableModel faultTableModel) {
        this.faultTableModel = faultTableModel;
    }

    public DefaultTableModel getEventTableModel() {
        return this.eventTableModel;
    }

    public void setEventTableModel(DefaultTableModel eventTableModel) {
        this.eventTableModel = eventTableModel;
    }

    public IsmTable getFaultTable() {
        return this.faultTable;
    }

    public void setFaultTable(IsmTable faultTable) {
        this.faultTable = faultTable;
    }

    public IsmTable getEventTable() {
        return this.eventTable;
    }

    public void setEventTable(IsmTable eventTable) {
        this.eventTable = eventTable;
    }

    public JTabbedPane getEventTabbedPane() {
        return this.eventTabbedPane;
    }

    public void setEventTabbedPane(JTabbedPane eventTabbedPane) {
        this.eventTabbedPane = eventTabbedPane;
    }

    public EventDetail getAllEventDetail() {
        return this.allEventDetail;
    }

    public void setAllEventDetail(EventDetail allEventDetail) {
        this.allEventDetail = allEventDetail;
    }

    private static class EventLevelListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private EventLevelListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (comp instanceof JLabel) {
                this.setLebelText(value, comp);
            }
            return comp;
        }

        private void setLebelText(Object value, Component comp) {
            JLabel label = (JLabel)comp;
            if (value instanceof Pair) {
                Pair item = (Pair)value;
                if (item == EventManagerPanel.COMBOBOX_ITEM_ALL_LEVEL) {
                    label.setText(item.toString());
                } else if (item.getValue() instanceof Event.Level) {
                    this.setLabelIcon(label, item);
                }
            }
        }

        private void setLabelIcon(JLabel label, Pair<?, ?> item) {
            Event.Level alarmLevel = (Event.Level)((Object)item.getValue());
            label.setIcon(SwingUtil.getLevelIcon(alarmLevel));
            label.setText(alarmLevel.toString());
        }
    }

    private static final class MyCustSelectionModel
    extends DefaultSingleSelectionModel {
        private static final long serialVersionUID = -3624441089145696782L;
        private int index = -1;

        private MyCustSelectionModel() {
        }

        @Override
        public int getSelectedIndex() {
            return this.index;
        }

        @Override
        public void setSelectedIndex(int idx) {
            if (this.getSelectedIndex() != idx) {
                this.fireStateChanged();
                this.index = idx;
            }
        }
    }
}

