/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat;

import com.huawei.ism.common.bean.impl.IPerfStatObject;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui2.perfstat.PerfStatNormalPanel;
import com.huawei.ism.util.CommonUtil;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.data.xy.XYDataset;

public class NormalPerfStatXYToolTipGenerator
extends StandardXYToolTipGenerator {
    private static final long serialVersionUID = 3370718389430964799L;
    private static final String TOOLTIP_FORMAT = "<html>{0}: {1}<br> {2}: {3} {4}<br> {5}: {6} </html>";
    private static final String THRESHOLD_TOOLTIP_FORMAT = "<html>{0}: {1}<br> {2}: {3}<br> {4}: {5} {6} </html>";
    private PerfStatNormalPanel normalPanel;

    public NormalPerfStatXYToolTipGenerator(PerfStatNormalPanel normalPanel, DateFormat xFormat, NumberFormat yFormat) {
        super(TOOLTIP_FORMAT, xFormat, yFormat);
        this.normalPanel = normalPanel;
    }

    public String generateLabelString(XYDataset dataset, int series, int item) {
        String result = null;
        Object[] items = this.createItemArray(dataset, series, item);
        String key = this.getSeriesKey(dataset, series);
        IPerfStatObject obj = this.normalPanel.getPerfStatObjectByKey(key);
        if (obj == null) {
            return super.generateLabelString(dataset, series, item);
        }
        Object[] infos = this.getPerfStatItemInfos(obj);
        Object[] allItems = new Object[7];
        if (!ResourceManager.getString("perf.threshold.ui.threshold").equals(key)) {
            allItems[0] = infos[0];
            allItems[1] = infos[1];
            allItems[2] = infos[2];
            allItems[3] = Double.valueOf(items[2].toString().replaceAll(",", ""));
            allItems[4] = infos[3];
            allItems[5] = ResourceManager.getString("TIME_TITLE");
            allItems[6] = items[1];
            result = MessageFormat.format(TOOLTIP_FORMAT, allItems);
        } else {
            allItems[0] = CommonUtil.removeColon(ResourceManager.getString("PERFORMANCE_STATISTIC_OBJECT_PANEL_STYLE"));
            allItems[1] = infos[0];
            allItems[2] = CommonUtil.removeColon(ResourceManager.getString("PERFORMANCE_STATISTIC_PARAMETERS_PANEL_DATA_TYPE"));
            allItems[3] = infos[2];
            allItems[4] = ResourceManager.getString("perf.threshold.ui.threshold");
            allItems[5] = Double.valueOf(items[2].toString().replaceAll(",", ""));
            allItems[6] = infos[3];
            result = MessageFormat.format(THRESHOLD_TOOLTIP_FORMAT, allItems);
        }
        return result;
    }

    private Object[] getPerfStatItemInfos(IPerfStatObject obj) {
        Object[] infos = new Object[]{obj.getObjectType().getDescription(), obj.getText(), obj.getDataType().getDescription(), obj.getDataType().getUnitDesc()};
        return infos;
    }

    private String getSeriesKey(XYDataset dataset, int series) {
        return dataset.getSeriesKey(series).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NormalPerfStatXYToolTipGenerator)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

