/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat;

import com.huawei.ism.common.bean.impl.IDataTypeEnum;
import com.huawei.ism.common.bean.impl.IObjectTypeEnum;
import com.huawei.ism.common.bean.impl.IPerfStatObject;
import com.huawei.ism.ui.module.perfhis.XYTimeSeriesData;
import com.huawei.ism.ui2.perfstat.ChartKey;
import com.huawei.ism.ui2.perfstat.NormalPerfStatXYToolTipGenerator;
import com.huawei.ism.ui2.perfstat.util.TimeSeriesChartWithMagnifier;
import com.huawei.ism.util.SwingUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ObjectInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class PerfStatNormalPanel
extends JPanel {
    private static final long serialVersionUID = 2254062177000167651L;
    private static List<ChartKey> chartKeyList = new ArrayList<ChartKey>();
    private transient Map<ChartKey, TimeSeriesChartWithMagnifier> chartMap;
    private Map<String, IPerfStatObject> perfStatObjectMap;
    private long autoRange = -1L;
    private SimpleDateFormat dateFormat;
    private TimeZone timeZone;
    private JPanel mainPanel;
    private JScrollPane scrollPane;
    private JPanel panel;
    private NormalPerfStatXYToolTipGenerator generator;
    private int maxWidth;
    private Frame frame;
    private String fromPane;

    public PerfStatNormalPanel(Frame frame, String fromPaneValue) {
        this.frame = frame;
        this.fromPane = fromPaneValue;
        this.chartMap = new HashMap<ChartKey, TimeSeriesChartWithMagnifier>();
        this.perfStatObjectMap = new HashMap<String, IPerfStatObject>();
        this.scrollPane = new JScrollPane();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridLayout(0, 2, 2, 2));
        this.add(this.scrollPane);
        this.panel = new JPanel();
        this.panel.setLayout(new FlowLayout());
        this.panel.add(this.mainPanel);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setViewportView(this.panel);
        this.initLisenter();
    }

    private void initLisenter() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PerfStatNormalPanel.this.refreshPanel();
                PerfStatNormalPanel.this.setTitleMaxWidth();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                PerfStatNormalPanel.this.refreshPanel();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                PerfStatNormalPanel.this.refreshPanel();
            }
        });
    }

    public synchronized void addData(IPerfStatObject statObject, Collection<XYTimeSeriesData> datas) {
        TimeSeriesChartWithMagnifier currentChart = this.createChart(statObject);
        currentChart.addData(this.getKey(statObject), statObject.getColor(), datas);
        this.refreshPanel();
    }

    public void setAutoRange(long range) {
        this.autoRange = range;
        for (TimeSeriesChartWithMagnifier temp : this.chartMap.values()) {
            temp.setAutoRange(range);
        }
    }

    public void setToolTipGenerator(NormalPerfStatXYToolTipGenerator value) {
        this.generator = value;
        for (TimeSeriesChartWithMagnifier temp : this.chartMap.values()) {
            temp.setToolTipGenerator(value);
        }
    }

    public void setDateAxisFormat(SimpleDateFormat value) {
        if (!value.equals(this.dateFormat)) {
            this.dateFormat = value;
            for (TimeSeriesChartWithMagnifier temp : this.chartMap.values()) {
                temp.setDateAxisFormat(this.dateFormat);
            }
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone != null) {
            this.timeZone = timeZone;
            for (TimeSeriesChartWithMagnifier temp : this.chartMap.values()) {
                temp.setTimeZone(timeZone);
            }
        }
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            return TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public synchronized void removeSeriesByKey(IPerfStatObject obj, boolean isRemoveable) {
        TimeSeriesChartWithMagnifier currentChart = this.getCurrentChart(obj);
        if (currentChart == null) {
            return;
        }
        currentChart.removeSeriesByKey(this.getKey(obj));
        if (isRemoveable) {
            ChartKey chartKey = PerfStatNormalPanel.getChartKey(obj.getObjectType(), obj.getDataType());
            TimeSeriesChartWithMagnifier chartMagnifier = this.chartMap.get(chartKey);
            this.mainPanel.remove(chartMagnifier);
            this.chartMap.remove(chartKey);
        }
    }

    public synchronized void removeAllChart() {
        for (Map.Entry<ChartKey, TimeSeriesChartWithMagnifier> entry : this.chartMap.entrySet()) {
            entry.getValue().removeAllSeries();
            this.mainPanel.remove(entry.getValue());
        }
        this.chartMap.clear();
        this.refreshPanel();
    }

    public synchronized void addOrUpdateData(IPerfStatObject statObject, List<XYTimeSeriesData> datas) {
        TimeSeriesChartWithMagnifier temp = this.getCurrentChart(statObject);
        if (temp == null) {
            return;
        }
        TimeSeries tmpSeries = new TimeSeries((Comparable)((Object)"timeSeriesNametmp"));
        for (XYTimeSeriesData data : datas) {
            Double valueY = data.getValueY();
            RegularTimePeriod period = RegularTimePeriod.createInstance(Millisecond.class, (Date)new Date(data.getValueX()), (TimeZone)this.getTimeZone(), (Locale)Locale.getDefault());
            tmpSeries.addOrUpdate(period, (Number)valueY);
        }
        TimeSeries timeSeries = temp.getOrCreate(this.getKey(statObject), statObject.getColor());
        timeSeries.addAndOrUpdate(tmpSeries);
    }

    public synchronized void addOrUpdateData(IPerfStatObject statObject, XYTimeSeriesData data) {
        TimeSeriesChartWithMagnifier temp = this.getCurrentChart(statObject);
        if (temp == null) {
            return;
        }
        TimeSeries timeSeries = temp.getOrCreate(this.getKey(statObject), statObject.getColor());
        RegularTimePeriod period = RegularTimePeriod.createInstance(Millisecond.class, (Date)new Date(data.getValueX()), (TimeZone)this.timeZone, (Locale)Locale.getDefault());
        double yValue = data.getValueY();
        timeSeries.addOrUpdate(period, yValue);
        Date maxDate = temp.getAxisX().getMaximumDate();
        maxDate.setTime(maxDate.getTime() + 1L);
        temp.getAxisX().setMaximumDate(maxDate);
    }

    private String getKey(IPerfStatObject statObject) {
        String key = statObject.getObjectType().getDescription() + "_" + statObject.getText() + "_" + statObject.getDataType().getDescription();
        if (!this.perfStatObjectMap.containsKey(key)) {
            this.perfStatObjectMap.put(key, statObject);
        }
        return key;
    }

    private static ChartKey getChartKey(IObjectTypeEnum objectType, IDataTypeEnum dataType) {
        for (ChartKey key : chartKeyList) {
            if (!key.getDataType().equals(dataType) || !key.getObjectType().equals(objectType)) continue;
            return key;
        }
        ChartKey result = new ChartKey(objectType, dataType);
        chartKeyList.add(result);
        return result;
    }

    private TimeSeriesChartWithMagnifier getCurrentChart(IPerfStatObject obj) {
        ChartKey key = PerfStatNormalPanel.getChartKey(obj.getObjectType(), obj.getDataType());
        return this.chartMap.get(key);
    }

    public TimeSeriesChartWithMagnifier createChart(IPerfStatObject obj) {
        ChartKey key = PerfStatNormalPanel.getChartKey(obj.getObjectType(), obj.getDataType());
        if (!this.chartMap.containsKey(key)) {
            String title = obj.getObjectType().getDescription() + " - " + obj.getDataType().getDescription();
            String unit = obj.getDataType().getUnitDesc();
            if (!"--".equals(unit) && !"".equals(unit)) {
                title = title + "(" + unit + ")";
            }
            TimeSeriesChartWithMagnifier temp = new TimeSeriesChartWithMagnifier(this.frame, false, true, false, false, true, false, true, true, this.fromPane);
            temp.setTitle(title);
            if (this.autoRange != -1L) {
                temp.setAutoRange(this.autoRange);
            }
            if (this.dateFormat != null) {
                temp.setDateAxisFormat(this.dateFormat);
            }
            if (this.timeZone != null) {
                temp.setTimeZone(this.timeZone);
            }
            if (this.generator != null) {
                temp.setToolTipGenerator(this.generator);
            }
            temp.setTitleMaxWidth(this.maxWidth);
            this.mainPanel.add(temp);
            this.chartMap.put(key, temp);
        }
        return this.chartMap.get(key);
    }

    public void refreshPanel() {
        SwingUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                int maxWidthTemp = PerfStatNormalPanel.this.getWidth() - 26;
                int maxHeight = PerfStatNormalPanel.this.getHeight() - 16;
                int cHeight = maxHeight / 2;
                int height = (PerfStatNormalPanel.this.chartMap.size() + 1) / 2 * cHeight;
                PerfStatNormalPanel.this.mainPanel.setPreferredSize(new Dimension(maxWidthTemp, height));
                int minHeight = PerfStatNormalPanel.this.getHeight() - 10;
                if (height < minHeight) {
                    PerfStatNormalPanel.this.panel.setPreferredSize(new Dimension(PerfStatNormalPanel.this.getWidth() - 10, minHeight));
                } else {
                    PerfStatNormalPanel.this.panel.setPreferredSize(new Dimension(maxWidthTemp, height));
                }
                PerfStatNormalPanel.this.scrollPane.setPreferredSize(new Dimension(PerfStatNormalPanel.this.getWidth() - 6, PerfStatNormalPanel.this.getHeight() - 6));
                PerfStatNormalPanel.this.revalidate();
                PerfStatNormalPanel.this.repaint();
            }
        });
    }

    private void setTitleMaxWidth() {
        this.maxWidth = (int)(this.mainPanel.getPreferredSize().getWidth() / 2.0 - 25.0);
        for (TimeSeriesChartWithMagnifier chart : this.chartMap.values()) {
            chart.setTitleMaxWidth(this.maxWidth);
        }
    }

    public IPerfStatObject getPerfStatObjectByKey(String key) {
        return this.perfStatObjectMap.get(key);
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void readObject(ObjectInputStream in) {
    }
}

