/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.entity.Type;
import com.huawei.ism.common.license.License;
import com.huawei.ism.common.license.LicenseFunction;
import com.huawei.ism.common.license.LicenseResource;
import com.huawei.ism.common.license.LicenseUsageInfo;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class LicenseUtils {
    public static String notExistedOrOverdue(String deviceID, Type.LicenseFuncFeatureType type) {
        String reason = LicenseUtils.notExisted(deviceID, type);
        if (null == reason) {
            ArrayList<Type.LicenseFuncFeatureType> types = new ArrayList<Type.LicenseFuncFeatureType>(0);
            types.add(type);
            reason = LicenseUtils.overdue(deviceID, types);
        }
        return reason;
    }

    public static String toBeOverdue(String deviceID, List<Type.LicenseFuncFeatureType> typeGroup) {
        if (null == typeGroup || typeGroup.isEmpty()) {
            return null;
        }
        ArrayList<String> msgs = new ArrayList<String>(0);
        License.State state = null;
        String msg = null;
        for (Type.LicenseFuncFeatureType type : typeGroup) {
            state = LicenseUtils.getLicenseState(deviceID, type);
            if (License.State.TO_BE_OVERDUE != state) continue;
            msg = ResourceManager.getStringWithParams("LICENSE_TO_BE_OVERDUE", type.toString());
            msgs.add(msg);
        }
        if (msgs.isEmpty()) {
            return null;
        }
        String result = (String)msgs.get(0);
        return result;
    }

    public static String notExisted(String deviceID, Type.LicenseFuncFeatureType type) {
        String reason = null;
        License.State state = LicenseUtils.getLicenseState(deviceID, type);
        if (License.State.NOT_EXISTED == state) {
            reason = ResourceManager.getStringWithParams("LICENSE_NOT_EXIST", type.toString());
        }
        return reason;
    }

    public static String overdue(String deviceID, List<Type.LicenseFuncFeatureType> typeGroup) {
        if (null == typeGroup || typeGroup.isEmpty()) {
            return null;
        }
        ArrayList<String> msgs = new ArrayList<String>(0);
        String msg = null;
        License.State state = null;
        for (Type.LicenseFuncFeatureType type : typeGroup) {
            state = LicenseUtils.getLicenseState(deviceID, type);
            if (License.State.OVERDUE != state) continue;
            msg = ResourceManager.getStringWithParams("LICENSE_OVERDUE", type.toString());
            msgs.add(msg);
        }
        if (msgs.size() != typeGroup.size()) {
            return null;
        }
        String result = (String)msgs.get(0);
        return result;
    }

    public static String partialExisted(String deviceID, List<Type.LicenseFuncFeatureType> typeGroup) {
        if (null == typeGroup || typeGroup.isEmpty()) {
            return null;
        }
        String msg = null;
        for (Type.LicenseFuncFeatureType type : typeGroup) {
            msg = LicenseUtils.notExisted(deviceID, type);
            if (null != msg) continue;
            return msg;
        }
        return msg;
    }

    public static License.State getLicenseState(String deviceID, Type.LicenseFuncFeatureType type) {
        License.State state = License.State.NOT_EXISTED;
        DeviceContext context = LauncherManager.getInstance().getDeviceContext(deviceID);
        if (null == context) {
            return state;
        }
        License license = context.getLicense();
        if (null == license) {
            return state;
        }
        Collection<LicenseFunction> licenseFuncs = license.getLicenseFuncList();
        boolean isExistLicenseFunction = false;
        String featherID = "";
        Type.LicenseFuncFeatureType funcType = null;
        for (LicenseFunction function : licenseFuncs) {
            funcType = function.getFeatureName();
            if (!type.equals((Object)funcType)) continue;
            isExistLicenseFunction = true;
            featherID = String.valueOf(function.getFeatureID());
            break;
        }
        return LicenseUtils.getLicenseState(isExistLicenseFunction, license, type, featherID, state);
    }

    public static License.State getLicenseState(boolean isExistLicenseFunction, License license, Type.LicenseFuncFeatureType type, String featherID, License.State state) {
        boolean isExistLicenseResource = true;
        String actualFeatherID = featherID;
        if (!isExistLicenseFunction) {
            Map<String, LicenseResource> licenseResourceMap = license.getLicenseResourceMap();
            if (licenseResourceMap.isEmpty() || null == licenseResourceMap.get(type.toString())) {
                isExistLicenseResource = false;
            } else {
                actualFeatherID = String.valueOf(licenseResourceMap.get(type.toString()).getFeatureID());
            }
        }
        if (!isExistLicenseFunction && !isExistLicenseResource) {
            return state;
        }
        Map<String, LicenseUsageInfo> licenseUsageInfoMap = license.getLicenseUsageInfoMap();
        if (licenseUsageInfoMap.isEmpty() || null == licenseUsageInfoMap.get(String.valueOf(actualFeatherID))) {
            return state;
        }
        LicenseUsageInfo licenseUsageInfo = licenseUsageInfoMap.get(actualFeatherID);
        return licenseUsageInfo.getLicenseState();
    }
}

