/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.SecurityConfig;
import java.awt.Desktop;
import java.io.IOException;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtil.class);
    public static final int CONN_SOCKECT = 0;
    public static final int CONN_SSL_SOCKECT = 1;
    public static final String MASK_A = "255.0.0.0";
    public static final String MASK_B = "255.255.0.0";
    public static final String MASK_C = "255.255.255.0";
    public static final String CONST_IP = "IP";
    public static final String CONST_MASK = "MASK";
    public static final Map<String, String> LOCAL_IP_MAP = new HashMap<String, String>(0);
    public static final String LOOPBACK_ADDRESS = "127.0.0.1";
    public static final String IPV6_DEFAULT_ADDRESS = "0::0";
    public static final String NUMBER_REGREX = "[0-9]*";
    public static final String HTTPPORT = "5988";
    private static Map<String, String> ipSubMaskMap = new HashMap<String, String>(0);
    private static final String[] DEFAULT_CIPHER_SUITES = new String[]{"TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"};
    private static final String[] INSECURE_CIPHER_SUITES = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA"};
    private static final String REREX_IPV6_ADDRESS = "^\\s*((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})))(%.+)?\\s*$";

    public static void checkIPV4(String ip) {
        block4: {
            Pattern pattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
            Matcher mat = pattern.matcher(ip);
            if (mat.matches()) {
                try {
                    InetAddress val = InetAddress.getByName(ip);
                    if (null == val) {
                        return;
                    }
                    break block4;
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("wrong IP scope:" + ip, e);
                }
            }
            throw new IllegalArgumentException("wrong IP format\uff1a" + ip);
        }
    }

    public static long ipv4Str2Long(String ip) {
        NetUtil.checkIPV4(ip);
        String[] str = ip.split("\\.");
        long ipValue = 0L;
        for (int i = str.length - 1; i >= 0; --i) {
            int tmp = Integer.valueOf(str[i]);
            long longNumber = 0L;
            longNumber = (longNumber | (long)tmp) << 8 * (str.length - i - 1);
            ipValue |= longNumber;
        }
        return ipValue;
    }

    public static boolean isSubnetMaskV4(String mask) {
        int ipvalue;
        if (mask == null) {
            throw new NullPointerException();
        }
        if (mask.indexOf(" ") > -1 || mask.indexOf("..") > -1) {
            return false;
        }
        try {
            ipvalue = NetUtil.ipv4Str2Int(mask);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return false;
        }
        return Integer.bitCount(ipvalue) + Integer.numberOfTrailingZeros(ipvalue) >= 32;
    }

    public static boolean isSameSubnet(String subnetIP, String mask, String testIP) {
        int testIPValue;
        if (subnetIP == null || mask == null) {
            throw new NullPointerException();
        }
        if (null == testIP) {
            return false;
        }
        try {
            NetUtil.checkIPV4(subnetIP);
            NetUtil.checkIPV4(testIP);
        }
        catch (RuntimeException e) {
            return false;
        }
        NetUtil.checkIPV4(mask);
        if (!NetUtil.isSubnetMaskV4(mask)) {
            throw new IllegalArgumentException(mask + " is not a subnet mask");
        }
        int subnetIPValue = NetUtil.ipv4Str2Int(subnetIP);
        int maskValue = NetUtil.ipv4Str2Int(mask);
        return (maskValue & subnetIPValue) == (maskValue & (testIPValue = NetUtil.ipv4Str2Int(testIP)));
    }

    public static int ipv4Str2Int(String ip) {
        NetUtil.checkIPV4(ip);
        String[] str = ip.split("\\.");
        int ipValue = 0;
        for (int i = 0; i < 4; ++i) {
            int tmp = Integer.valueOf(str[i]);
            ipValue |= tmp;
            if (i == 3) continue;
            ipValue <<= 8;
        }
        return ipValue;
    }

    public static BigInteger ipv6Str2Int(String ip) {
        try {
            InetAddress add = InetAddress.getByName(ip);
            BigInteger bi = new BigInteger(add.getAddress());
            return bi;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static NetworkInterface[] availableInterface() {
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            LOGGER.warn("Error on acquiring host net interfacing card", (Throwable)e);
            return new NetworkInterface[0];
        }
        ArrayList<NetworkInterface> netWorkInterfaces = new ArrayList<NetworkInterface>(0);
        NetworkInterface networkInfterface = null;
        boolean available = false;
        Enumeration<InetAddress> iNetAddress = null;
        if (null == networkInterfaces) {
            LOGGER.warn("The networkInterfaces is null.");
            throw new NullPointerException("The networkInterfaces is null.");
        }
        while (networkInterfaces.hasMoreElements()) {
            networkInfterface = networkInterfaces.nextElement();
            available = false;
            iNetAddress = networkInfterface.getInetAddresses();
            while (iNetAddress.hasMoreElements()) {
                InetAddress element = iNetAddress.nextElement();
                if (element.isLoopbackAddress()) continue;
                available = true;
                break;
            }
            if (!available) continue;
            netWorkInterfaces.add(networkInfterface);
        }
        return netWorkInterfaces.toArray(new NetworkInterface[netWorkInterfaces.size()]);
    }

    public static String getLocalIP(String ip, int port) {
        boolean bool;
        ArrayList ips = (ArrayList)NetUtil.queryAllLocalIP();
        String localIp = LOCAL_IP_MAP.get(ip);
        if (null != localIp && (bool = ips.contains(localIp))) {
            return localIp;
        }
        return NetUtil.queryLocalIP(ip, port);
    }

    public static String getLocalIP(String ip) {
        return NetUtil.getLocalIP(ip, 8080);
    }

    private static List<String> queryAllLocalIP() {
        NetworkInterface[] networkInterfaces;
        ArrayList<String> ips = new ArrayList<String>(0);
        for (NetworkInterface networkInterface : networkInterfaces = NetUtil.availableInterface()) {
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            InetAddress address = null;
            while (addresses.hasMoreElements()) {
                address = addresses.nextElement();
                ips.add(address.getHostAddress());
            }
        }
        return ips;
    }

    public static synchronized String queryLocalIP(String ip) {
        return NetUtil.getLocalIP(ip, Integer.valueOf(HTTPPORT));
    }

    public static synchronized String queryLocalIP(final String ip, final int port) {
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() {
                if (NetUtil.isValidIPV4(ip)) {
                    return NetUtil.getLocakIPv4Address(ip, port);
                }
                if (NetUtil.isValidIPV6(ip)) {
                    return NetUtil.getLocalIPv6Address(ip, port);
                }
                return null;
            }
        };
        Future<String> futuer = ThreadPoolManager.getInstance().submit(task);
        String localIp = NetUtil.processIPAddress(ip);
        try {
            String tmp = futuer.get(10L, TimeUnit.SECONDS);
            if (null != tmp && !"".equalsIgnoreCase(tmp) && !"0.0.0.0".equals(tmp)) {
                LOCAL_IP_MAP.put(ip, tmp);
                localIp = tmp;
            }
        }
        catch (Throwable e1) {
            LOGGER.warn("Getting local ip by socket error.");
        }
        return localIp;
    }

    private static String processIPAddress(String ip) {
        String localIp = LOOPBACK_ADDRESS;
        try {
            ArrayList ips = (ArrayList)NetUtil.queryAllLocalIP();
            Collections.sort(ips);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("local ips:" + ips);
            }
            String tmpIp = ip;
            if (NetUtil.isValidIPV4(ip)) {
                localIp = NetUtil.processIPv4Address(ips, tmpIp);
            } else if (NetUtil.isValidIPV6(ip)) {
                localIp = NetUtil.processIPv6Address(ips, tmpIp);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Get local IPAddress error", e);
        }
        return localIp;
    }

    private static String processIPv6Address(ArrayList<String> ips, String tmpIp) {
        int ind = 0;
        String localIp = IPV6_DEFAULT_ADDRESS;
        String iterTmpIp = tmpIp;
        block0: while (IPV6_DEFAULT_ADDRESS.equals(localIp) && null != iterTmpIp && -1 != (ind = iterTmpIp.lastIndexOf(58))) {
            iterTmpIp = iterTmpIp.substring(0, ind);
            for (String string : ips) {
                if (!string.contains(iterTmpIp)) continue;
                localIp = string;
                continue block0;
            }
        }
        if (IPV6_DEFAULT_ADDRESS.equals(localIp) && !ips.isEmpty()) {
            localIp = NetUtil.getIPv6Address(ips);
        }
        return localIp;
    }

    private static String processIPv4Address(ArrayList<String> ips, String tmpIp) {
        String localIp = LOOPBACK_ADDRESS;
        int ind = 0;
        String iterTmpIp = tmpIp;
        block0: while (null != iterTmpIp && -1 != (ind = iterTmpIp.lastIndexOf(46))) {
            iterTmpIp = iterTmpIp.substring(0, ind);
            for (String string : ips) {
                if (!string.contains(iterTmpIp)) continue;
                localIp = string;
                continue block0;
            }
        }
        if (LOOPBACK_ADDRESS.equals(localIp) && !ips.isEmpty()) {
            localIp = NetUtil.getIPv4Address(ips);
        }
        return localIp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLocakIPv4Address(String ip, int port) {
        Socket sock = null;
        try {
            sock = SocketFactory.getDefault().createSocket(ip, port);
            String localIp = sock.getLocalAddress().getHostAddress();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("get local ip by socket:" + localIp);
            }
            String string = localIp;
            return string;
        }
        catch (RuntimeException e) {
            LOGGER.error("Getting local ip  by socket error.", (Throwable)e);
            String string = null;
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Getting local ip by socket error.", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (null != sock) {
                try {
                    sock.close();
                }
                catch (IOException e) {
                    LOGGER.error("close socket error!", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLocalIPv6Address(String ip, int port) {
        Socket sock = null;
        String localIp = "0.0.0.0";
        ArrayList ips = (ArrayList)NetUtil.queryAllLocalIP();
        for (String local : ips) {
            if (!NetUtil.isValidIPV6(local)) continue;
            try {
                int localPort = NetUtil.getFreeLocalPort();
                sock = SocketFactory.getDefault().createSocket(ip, port, InetAddress.getByName(local), localPort);
                localIp = local;
                if (!LOGGER.isInfoEnabled()) break;
                LOGGER.info("Local ipv6 address:" + localIp + ",LocalPort:" + localPort);
                break;
            }
            catch (RuntimeException e) {
                LOGGER.error("get local ipver6 by socket error:" + local);
            }
            catch (Exception e) {
                LOGGER.error("get local ipv6 by socket error:" + local);
            }
            finally {
                if (null == sock) continue;
                try {
                    sock.close();
                }
                catch (IOException e) {
                    LOGGER.error("close socket error!", (Throwable)e);
                }
            }
        }
        return localIp;
    }

    private static String getIPv4Address(List<String> ips) {
        for (String ip : ips) {
            if (!NetUtil.isValidIPV4(ip)) continue;
            return ip;
        }
        return LOOPBACK_ADDRESS;
    }

    private static String getIPv6Address(List<String> ips) {
        for (String ip : ips) {
            if (!NetUtil.isValidIPV6(ip)) continue;
            return ip;
        }
        return IPV6_DEFAULT_ADDRESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getFreeLocalPort() {
        SecureRandom random = new SecureRandom();
        int testPort = 0;
        ServerSocket testSocket = null;
        while (true) {
            testPort = random.nextInt(5000);
            testSocket = null;
            try {
                testSocket = new ServerSocket(testPort);
                int n = testPort;
                return n;
            }
            catch (IOException e) {
                LOGGER.error("Local port is in use:" + testPort);
                continue;
            }
            finally {
                try {
                    if (null == testSocket) continue;
                    testSocket.close();
                }
                catch (IOException e) {
                    LOGGER.error("Close socket error.");
                }
                continue;
            }
            break;
        }
    }

    public static boolean isValidSubNetMask(String ipAddress, String subNetMask) {
        int tmp1 = ~NetUtil.ipv4Str2Int(subNetMask);
        int tmp2 = tmp1 & NetUtil.ipv4Str2Int(ipAddress);
        if (0 == tmp2) {
            return false;
        }
        int tmp3 = tmp1 ^ tmp2;
        return 0 != tmp3;
    }

    public static boolean isValidIP(String ip) {
        return NetUtil.isValidIPV4(ip) || NetUtil.isValidIPV6(ip);
    }

    public static boolean isValidIPV4(String ip) {
        try {
            NetUtil.checkIPV4(ip);
            String[] str = ip.split("\\.");
            int ipField1 = Integer.parseInt(str[0]);
            int ipField2 = Integer.parseInt(str[1]);
            int ipField3 = Integer.parseInt(str[2]);
            int ipField4 = Integer.parseInt(str[3]);
            boolean isValidField1 = 1 <= ipField1 && 223 >= ipField1 && 127 != ipField1;
            boolean isValidField2 = 0 <= ipField2 && 255 >= ipField2;
            boolean isValidField3 = 0 <= ipField3 && 255 >= ipField3;
            boolean isValidField4 = 0 <= ipField4 && 255 >= ipField4;
            return isValidField1 && isValidField2 && isValidField3 && isValidField4;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isValidIPV4ForDiscover(String ip) {
        return NetUtil.isValidIPV4(ip);
    }

    public static String getSubNetMaskByIP(String ipAddr) {
        return ipSubMaskMap.get(ipAddr);
    }

    public static int getLocalPort() {
        int port = 0;
        Set<Integer> ports = NetUtil.readPortCfgFile();
        for (Integer tmp : ports) {
            try {
                port = NetUtil.getValidPort(tmp);
            }
            catch (Throwable t) {
                port = 0;
            }
            if (0 == port) continue;
            break;
        }
        if (0 == port) {
            try {
                port = NetUtil.getValidPort(0);
            }
            catch (Exception e) {
                LOGGER.error("can not find available free port" + e);
            }
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getValidPort(int portParam) throws Exception {
        int port = 0;
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(portParam);
            port = socket.getLocalPort();
        }
        finally {
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
        return port;
    }

    private static Set<Integer> readPortCfgFile() {
        String[] tmpArray;
        HashSet<Integer> ports = new HashSet<Integer>();
        String portRangeStr = CustomResourceManager.getInstance().getString("custom.portrange");
        for (String str : tmpArray = portRangeStr.split(";")) {
            if (str.matches("([0-9]+-[0-9]+)")) {
                Set<Integer> result = NetUtil.parsePortCfg(str);
                ports.addAll(result);
                continue;
            }
            NetUtil.parsePortCfg(str, ports);
        }
        return ports;
    }

    private static Set<Integer> parsePortCfg(String strPorts) {
        String[] strArray = strPorts.split("-");
        int startValue = -1;
        int endValue = -1;
        startValue = Integer.valueOf(strArray[0]);
        endValue = Integer.valueOf(strArray[1]);
        HashSet<Integer> ports = new HashSet<Integer>();
        ports.add(startValue);
        ports.add(endValue);
        while (++startValue != endValue) {
            ports.add(startValue);
        }
        return ports;
    }

    private static void parsePortCfg(String strPorts, Set<Integer> portList) {
        String[] strArray;
        for (String str : strArray = strPorts.split(",")) {
            Integer tmp = Integer.valueOf(str);
            if (null == tmp || 0 == tmp) continue;
            portList.add(tmp);
        }
    }

    public static boolean isValidIPV6(String ipv6) {
        if (null == ipv6) {
            return false;
        }
        Pattern pattern = Pattern.compile(REREX_IPV6_ADDRESS);
        Matcher mat = pattern.matcher(ipv6);
        if (mat.matches()) {
            try {
                InetAddress address = InetAddress.getByName(ipv6);
                if (address instanceof Inet4Address && ipv6.equals(address.getHostAddress())) {
                    return false;
                }
                if (null != address) {
                    return !address.isMulticastAddress() && !address.isLoopbackAddress() && !address.isAnyLocalAddress();
                }
                return false;
            }
            catch (UnknownHostException e) {
                return false;
            }
            catch (Exception e1) {
                return false;
            }
        }
        return false;
    }

    public static boolean isCommonAddress(String ip) {
        try {
            InetAddress address = InetAddress.getByName(ip);
            if (null != address) {
                return !address.isMulticastAddress() && !address.isLoopbackAddress();
            }
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Socket connect(String ip, int port, int connType, Proxy proxy) throws IOException {
        return NetUtil.connect(ip, port, connType, proxy, 0);
    }

    public static Socket connect(String ip, int port, int connType, int retryTimes, Proxy proxy) throws IOException {
        return NetUtil.connectWithRetryTimes(ip, port, connType, retryTimes, proxy);
    }

    public static Socket connect(String ip, int port, int connType, Proxy proxy, int timeout) throws IOException {
        Socket socket = null;
        if (connType == 1) {
            try {
                socket = NetUtil.getSslSocket(ip, port, timeout, "TLSv1.2");
            }
            catch (Exception e) {
                if (SecurityConfig.isOnlySecurityAlgorithm()) {
                    throw e;
                }
                LOGGER.error("Use TLSv1.2 connect failed: ", (Throwable)e);
                socket = NetUtil.getSslSocket(ip, port, timeout, "SSLv3");
            }
        } else if (connType == 0) {
            socket = proxy == null ? new Socket() : new Socket(proxy);
            InetSocketAddress address = new InetSocketAddress(ip, port);
            socket.connect(address, timeout);
        } else {
            throw new IllegalArgumentException();
        }
        if (null != socket) {
            socket.setReuseAddress(true);
        }
        return socket;
    }

    private static Socket connectWithRetryTimes(String ip, int port, int connType, int retryTimes, Proxy proxy) throws IOException {
        Socket socket = null;
        if (connType == 1) {
            socket = NetUtil.getSslSocketWithRetryTimes(ip, port, retryTimes);
            if (null == socket) {
                throw new IOException("get ssl socket failed.");
            }
        } else if (connType == 0) {
            socket = proxy == null ? new Socket() : new Socket(proxy);
            InetSocketAddress address = new InetSocketAddress(ip, port);
            socket.connect(address, 0);
        } else {
            throw new IllegalArgumentException();
        }
        socket.setReuseAddress(true);
        return socket;
    }

    private static Socket getSslSocketWithRetryTimes(String ip, int port, int retryTimes) {
        if (retryTimes <= 0) {
            LOGGER.error("retryTimes is invalid:" + retryTimes);
            return null;
        }
        Socket socket = null;
        for (int i = 0; i <= retryTimes; ++i) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("try to connect with ssl socket ,time:" + i);
            }
            try {
                socket = NetUtil.getSslSocket(ip, port, 0, "TLSv1.2");
            }
            catch (Exception e) {
                LOGGER.error("Use TLSv1.2 connect failed: ", (Throwable)e);
                try {
                    socket = NetUtil.getSslSocket(ip, port, 0, "SSLv3");
                }
                catch (IOException e1) {
                    LOGGER.error("Use SSLv3 connect failed: ", (Throwable)e1);
                    continue;
                }
            }
            if (null == socket) continue;
            return socket;
        }
        return socket;
    }

    public static boolean isIPV6(String ipv6) {
        if (null == ipv6) {
            return false;
        }
        Pattern pattern = Pattern.compile(REREX_IPV6_ADDRESS);
        Matcher mat = pattern.matcher(ipv6);
        if (mat.matches()) {
            try {
                Inet6Address address = (Inet6Address)InetAddress.getByName(ipv6);
                return null != address;
            }
            catch (UnknownHostException e) {
                return false;
            }
            catch (Exception e1) {
                return false;
            }
        }
        return false;
    }

    public static boolean isIPv6Prefix(String prefix) {
        if (null == prefix) {
            return false;
        }
        Pattern pattern = Pattern.compile(NUMBER_REGREX);
        Matcher mat = pattern.matcher(prefix);
        return mat.matches() && !"".equals(prefix) && !prefix.startsWith("0") && Integer.parseInt(prefix) <= 128;
    }

    public static void browseURL(String url) {
        if (NetUtil.isWindows()) {
            NetUtil.browseURLForWindows(url);
        } else {
            NetUtil.browseURLForOthers(url);
        }
    }

    private static Socket getSslSocket(String ip, int port, int timeout, String sslVersion) throws IOException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Use ssl version: " + sslVersion);
        }
        SSLSocketFactory ssf = null;
        try {
            TrustManager[] tms = new TrustManager[]{new IsmTrustManager()};
            SSLContext context = SSLContext.getInstance(sslVersion);
            context.init(null, tms, SecureRandom.getInstanceStrong());
            ssf = context.getSocketFactory();
        }
        catch (RuntimeException e) {
            throw new IsmException(-1L, (Throwable)e);
        }
        catch (Exception e) {
            throw new IsmException(-1L, (Throwable)e);
        }
        Socket socket = ssf.createSocket();
        try {
            SSLSocket sskt = CommonUtil.convertObject(socket, SSLSocket.class);
            List<String> enabledCipherSuitesFromDefault = NetUtil.getEnabledCipherSuitesFromDefault(sskt);
            String[] spsArr = new String[enabledCipherSuitesFromDefault.size()];
            sskt.setEnabledCipherSuites(enabledCipherSuitesFromDefault.toArray(spsArr));
            if (sslVersion.equals("SSLv3")) {
                sskt.setEnabledProtocols(new String[]{"SSLv3"});
                LOGGER.info("Success to enable sslv3.");
            }
            InetSocketAddress address = new InetSocketAddress(ip, port);
            sskt.connect(address, timeout);
            sskt.startHandshake();
            return socket;
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            NetUtil.closeSocket(socket);
            return null;
        }
    }

    private static List<String> getEnabledCipherSuitesFromDefault(SSLSocket sslSocket) {
        List<String> enabledCipherSuitesList = Arrays.asList(sslSocket.getEnabledCipherSuites());
        String[] cipherSuites = SecurityConfig.isOnlySecurityAlgorithm() ? DEFAULT_CIPHER_SUITES : (String[])ArrayUtils.addAll((Object[])DEFAULT_CIPHER_SUITES, (Object[])INSECURE_CIPHER_SUITES);
        return Arrays.stream(cipherSuites).filter(enabledCipherSuitesList::contains).collect(Collectors.toList());
    }

    private static void closeSocket(Socket socket) {
        if (socket == null || socket.isClosed()) {
            return;
        }
        try {
            LOGGER.error("close noti socket " + socket.getLocalSocketAddress() + "/" + socket.getRemoteSocketAddress());
            socket.close();
        }
        catch (IOException e) {
            LOGGER.error("close socket for notification fail.", (Throwable)e);
        }
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        String string = osName = osName == null ? null : osName.toLowerCase(Locale.ENGLISH);
        return osName == null || osName.contains("windows") || osName.contains("Windows") || osName.contains("win") || osName.contains("Win");
    }

    private static void browseURLForWindows(String url) {
        String cmdStr = "cmd /c start iexplore " + url;
        try {
            OSCmdUtils.executeCmd(cmdStr);
        }
        catch (Exception e) {
            NetUtil.browseURLForOthers(url);
        }
    }

    private static void browseURLForOthers(String url) {
        if (Desktop.isDesktopSupported()) {
            try {
                URI uri = URI.create(url);
                Desktop dp = Desktop.getDesktop();
                if (dp.isSupported(Desktop.Action.BROWSE)) {
                    dp.browse(uri);
                }
            }
            catch (NullPointerException ex) {
                LOGGER.error("open url" + ex);
            }
            catch (IOException ex) {
                LOGGER.error("open url" + ex);
            }
        }
    }

    public static boolean isCommandIPV6Addr(String ip) {
        if (null == ip) {
            return false;
        }
        String examIp = "";
        examIp = ip.startsWith("https://") ? ip.substring(8) : ip;
        return examIp.contains(":") && examIp.contains("[");
    }

    public static String getIPV6AddrForCmd(String ipv6Addr) {
        return "[" + ipv6Addr + "]";
    }

    public static String getNormalIPV6Addr(String ipv6Addr) {
        return ipv6Addr.replace("[", "").replace("]", "");
    }

    public static class IsmTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

