/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.service.Datacache;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JPasswordField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static BigDecimal bigBad;
    private static BigDecimal smallBad;

    public static boolean isNullStr(String content) {
        return null == content || content.isEmpty();
    }

    public static Locale getOSLocaleDefaultEn() {
        Locale retLocal = Locale.getDefault();
        List<Locale> locales = CustomResourceManager.getInstance().getLanguages();
        if (locales.contains(retLocal)) {
            return retLocal;
        }
        Locale defaultLocale = null;
        for (Locale l : locales) {
            if (!l.getLanguage().equals(Locale.ENGLISH.getLanguage())) continue;
            defaultLocale = l;
            break;
        }
        if (null == defaultLocale) {
            defaultLocale = Locale.US;
        }
        return defaultLocale;
    }

    public static void exitSystem() {
        System.exit(0);
    }

    public static boolean isJunitTest() {
        String obj = System.getProperty("ISM_JUNIT");
        return null != obj && Boolean.parseBoolean(obj);
    }

    public static boolean isNullString(String inStr, boolean needTrim) {
        if (inStr == null || inStr.length() < 1) {
            return true;
        }
        return needTrim && inStr.trim().length() < 1;
    }

    public static boolean isNullList(List<?> fList) {
        return null == fList || fList.isEmpty();
    }

    public static <T> boolean isNullArray(T ... ts) {
        return null == ts || ts.length == 0;
    }

    public static boolean isNullArray(int ... ints) {
        return null == ints || ints.length == 0;
    }

    public static String[] i18n(String[] keys) {
        if (Utils.isNullArray(keys)) {
            return keys;
        }
        String[] result = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            if (null == keys[i]) continue;
            result[i] = ResourceManager.getString(keys[i]);
        }
        return result;
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        String string = osName = osName == null ? null : osName.toLowerCase(Locale.ENGLISH);
        return osName == null || osName.contains("windows") || osName.contains("Windows") || osName.contains("win") || osName.contains("Win");
    }

    public static String matchBlank(String content) {
        String result = content;
        if (result.contains("{")) {
            int begin = result.indexOf("{");
            int paraBegin = Utils.getStartLocation(result, begin);
            String para = result.substring(paraBegin, begin).trim();
            if (result.contains("}")) {
                int end = result.indexOf("}") + 1;
                String replaceMsg = result.substring(paraBegin, end);
                String info = result.substring(begin, end);
                Map<String, String> params = Utils.getParams(info);
                if ((result = params.get(para) == null ? result.replace(info, "") : result.replace(replaceMsg, params.get(para))).contains("{")) {
                    result = Utils.matchBlank(result);
                }
            }
        }
        return result;
    }

    private static Map<String, String> getParams(String info) {
        String[] params;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String tempInfo = info.replaceAll("\uff1b", ";").replaceAll("\uff1a", ":");
        if (tempInfo.startsWith("{")) {
            tempInfo = tempInfo.substring(1);
        }
        if (tempInfo.endsWith("}")) {
            tempInfo = tempInfo.substring(0, tempInfo.length() - 1);
        }
        for (String param : params = tempInfo.split(";")) {
            String[] item = param.split(":");
            if (item.length != 2) continue;
            paramMap.put(item[0].trim(), item[1].trim());
        }
        return paramMap;
    }

    private static int getStartLocation(String content, int index) {
        int none = -1;
        for (int i = index; i > 0; --i) {
            int temp;
            int n = temp = index - 2 >= 0 ? index - 2 : 0;
            if (content.substring(i - 1, i).trim().equals("") || Utils.isInter(Utils.getVirtualValue(content, i).trim()) && content.substring(temp, i).trim().equals("")) continue;
            if (Utils.isInter(Utils.getVirtualValue(content, i).trim())) {
                return i - 2 >= 0 ? i - 2 : 0;
            }
            return i - 1;
        }
        return none;
    }

    private static String getVirtualValue(String content, int index) {
        for (int i = 2; i < index; ++i) {
            String temp = content.substring(index - i, index);
            char fistChar = temp.charAt(0);
            if (fistChar == ' ') continue;
            return content.substring(index - i, index);
        }
        int temp = index - 2 >= 0 ? index - 2 : 0;
        return content.substring(temp, index);
    }

    private static boolean isInter(String str) {
        try {
            Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static List jsonConvertList(JSONArray jsonArray) {
        ArrayList<String> resultOfJson = new ArrayList<String>(0);
        try {
            if (null != jsonArray) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    resultOfJson.add((String)jsonArray.get(i));
                }
            }
        }
        catch (JSONException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return resultOfJson;
    }

    public static String transferStringToLower(String value) {
        return Utils.transferStringToLower(value, null, false);
    }

    public static String transferStringToLower(String value, int[] notNeedTrans) {
        return Utils.transferStringToLower(value, notNeedTrans, false);
    }

    public static String transferStringToUpper(String value) {
        return Utils.transferStringToLower(value, null, true);
    }

    public static String transferStringToUpper(String value, int[] notNeedTrans) {
        return Utils.transferStringToLower(value, notNeedTrans, true);
    }

    private static String transferStringToLower(String valueStr, int[] notNeedTrans, boolean isUpperCase) {
        String validValue;
        Locale locale = ResourceManager.getLocale();
        String string = validValue = null == valueStr ? "--" : valueStr;
        if (locale.equals(Locale.ENGLISH)) {
            String[] words = validValue.split(" ");
            StringBuilder resultStr = new StringBuilder();
            for (int i = 0; i < words.length; ++i) {
                if (0 == i || Utils.isContain(i, notNeedTrans)) {
                    resultStr.append(words[i]);
                } else {
                    resultStr.append(Utils.changeFirstLow(words[i], isUpperCase));
                }
                if (i == words.length - 1) continue;
                resultStr.append(" ");
            }
            return resultStr.toString();
        }
        return validValue;
    }

    private static boolean isContain(int value, int[] arrs) {
        if (null == arrs) {
            return false;
        }
        for (int arr : arrs) {
            if (value != arr) continue;
            return true;
        }
        return false;
    }

    private static String changeFirstLow(String wordStr, boolean isUpperCase) {
        if (isUpperCase) {
            return wordStr.substring(0, 1).toUpperCase(Locale.getDefault()) + wordStr.substring(1);
        }
        return wordStr.substring(0, 1).toLowerCase(Locale.getDefault()) + wordStr.substring(1);
    }

    public static void setDatacacheDirty(String deviceID, MOType moType, String moID) {
        UUID uuid = new UUID(deviceID, moType, moID);
        Datacache.getInstance().setDirtyTag(uuid);
    }

    public static String[] addStringToArray(String[] srcArray, int index, String value) {
        if (null == srcArray) {
            return new String[0];
        }
        ArrayList<String> strList = new ArrayList<String>(Arrays.asList(srcArray));
        strList.add(index, value);
        return strList.toArray(new String[strList.size()]);
    }

    public static String[] removeStringFromArray(String[] srcArray, int index) {
        if (null == srcArray) {
            return new String[0];
        }
        ArrayList<String> strList = new ArrayList<String>(Arrays.asList(srcArray));
        strList.remove(index);
        return strList.toArray(new String[strList.size()]);
    }

    public static String[] removeStringFromArray(String[] srcArray, String value) {
        if (null == srcArray) {
            return new String[0];
        }
        ArrayList<String> strList = new ArrayList<String>(Arrays.asList(srcArray));
        strList.remove(value);
        return strList.toArray(new String[strList.size()]);
    }

    public static void closeSocket(Socket socket) {
        if (null != socket && !socket.isClosed()) {
            try {
                socket.close();
            }
            catch (IOException e) {
                LOGGER.error("socket close faild.");
            }
        }
    }

    public static double safeParseDouble(String str) throws IsmException {
        BigDecimal bd;
        if (null == str || str.isEmpty()) {
            throw new IsmException(851978L);
        }
        String noDot = str.replace(".", "");
        if (!noDot.contains("2225073858507201") && StringUtils.hasMatchStr(str, "^\\d+$")) {
            return Double.parseDouble(str);
        }
        try {
            bd = new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            LOGGER.error("", (Throwable)e);
            throw new IsmException(65540L, (Throwable)e);
        }
        int flagI = bd.compareTo(smallBad);
        int flagJ = bd.compareTo(bigBad);
        if (flagI == 1 || flagJ != -1) {
            return Double.parseDouble(str);
        }
        LOGGER.error("str      : " + bd);
        LOGGER.error("smallBad : " + smallBad);
        LOGGER.error("bigBad   : " + bigBad);
        LOGGER.error("Param str is DOS number.");
        throw new IsmException(65540L);
    }

    public static String getStringValueOfPassordFiled(JPasswordField ismPasswordField) {
        char[] password = ismPasswordField.getPassword();
        String str = String.valueOf(password);
        Arrays.fill(password, ' ');
        return str;
    }

    public static String fixFotifyPathManipulation(String path) {
        HashMap<String, String> map = new HashMap<String, String>();
        Utils.putGeneralCase(map);
        Utils.putUpperCase(map);
        map.put(":", ":");
        map.put("/", "/");
        map.put("\\", "\\");
        String temp = "";
        for (int i = 0; i < path.length(); ++i) {
            temp = map.get(path.charAt(i) + "") != null ? temp + map.get(path.charAt(i) + "") : temp + path.charAt(i);
        }
        return temp;
    }

    private static void putUpperCase(HashMap<String, String> map) {
        map.put("A", "A");
        map.put("B", "B");
        map.put("C", "C");
        map.put("D", "D");
        map.put("E", "E");
        map.put("F", "F");
        map.put("G", "G");
        map.put("H", "H");
        map.put("I", "I");
        map.put("J", "J");
        map.put("K", "K");
        map.put("L", "L");
        map.put("M", "M");
        map.put("N", "N");
        map.put("O", "O");
        map.put("P", "P");
        map.put("Q", "Q");
        map.put("R", "R");
        map.put("S", "S");
        map.put("T", "T");
        map.put("U", "U");
        map.put("V", "V");
        map.put("W", "W");
        map.put("X", "X");
        map.put("Y", "Y");
        map.put("Z", "Z");
    }

    private static void putGeneralCase(HashMap<String, String> map) {
        map.put("a", "a");
        map.put("b", "b");
        map.put("c", "c");
        map.put("d", "d");
        map.put("e", "e");
        map.put("l", "l");
        map.put("m", "m");
        map.put("n", "n");
        map.put("o", "o");
        map.put("f", "f");
        map.put("g", "g");
        map.put("h", "h");
        map.put("i", "i");
        map.put("j", "j");
        map.put("k", "k");
        map.put("p", "p");
        map.put("q", "q");
        map.put("r", "r");
        map.put("s", "s");
        map.put("t", "t");
        map.put("u", "u");
        map.put("v", "v");
        map.put("w", "w");
        map.put("r", "r");
        map.put("s", "s");
        map.put("t", "t");
        map.put("u", "u");
        map.put("x", "x");
        map.put("y", "y");
        map.put("z", "z");
    }

    static {
        BigDecimal two = new BigDecimal(2);
        BigDecimal tiny = BigDecimal.ONE.divide(two.pow(1022));
        bigBad = tiny.subtract(BigDecimal.ONE.divide(two.pow(1076)));
        smallBad = tiny.subtract(BigDecimal.ONE.divide(two.pow(1075)));
    }
}

