/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util.parser;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileParser
extends ResourceBundle {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileParser.class);
    public static final String DEFAULT_NULL_STRING = "--";
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private ResourceBundle bundle = null;
    private Map<String, String> keyWordMap;
    private Map<String, String> thisMap;

    public PropertiesFileParser(ResourceBundle bundle) {
        this.bundle = bundle;
        this.keyWordMap = this.getDefalutKeyMap();
    }

    public PropertiesFileParser(String propertyRelativePath) {
        this(propertyRelativePath, ResourceManager.getLocale());
    }

    public PropertiesFileParser(String propertyRelativePath, Locale locale, Map<String, String> keyWordsMap) {
        this(propertyRelativePath, locale);
        this.keyWordMap = keyWordsMap;
    }

    public PropertiesFileParser(String propertyRelativePath, Locale locale, ClassLoader classLoader) {
        try {
            if (null != classLoader) {
                this.bundle = ResourceBundle.getBundle(propertyRelativePath, locale, classLoader);
                this.setClassLoader(classLoader);
            }
        }
        catch (MissingResourceException e) {
            LOGGER.error("can't find resource.");
        }
        this.init(propertyRelativePath, locale);
    }

    public PropertiesFileParser(String propertyRelativePath, Locale locale, ClassLoader classLoader, Map<String, String> keyWordsMap) {
        this(propertyRelativePath, locale, classLoader);
        this.keyWordMap = keyWordsMap;
    }

    public PropertiesFileParser(String propertyRelativePath, Map<String, String> keyWordsMap) {
        this(propertyRelativePath);
        this.keyWordMap = keyWordsMap;
    }

    public PropertiesFileParser(String propertyRelativePath, Locale locale) {
        try {
            this.bundle = ResourceBundle.getBundle(propertyRelativePath, locale, this.loader);
            this.keyWordMap = this.getDefalutKeyMap();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private void setClassLoader(ClassLoader cl) {
        this.loader = cl;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.bundle.getKeys();
    }

    public Map<String, String> getKeyValueMap() {
        if (null == this.thisMap) {
            this.thisMap = new HashMap<String, String>(0);
            Enumeration<String> enums = this.getKeys();
            while (enums.hasMoreElements()) {
                String key = enums.nextElement();
                this.thisMap.put(key, this.getString(key));
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(this.thisMap);
        return map;
    }

    public String getStringArg(String key, String defaultValue) {
        String arg = this.getString(key);
        return arg.equals(DEFAULT_NULL_STRING) ? defaultValue : arg;
    }

    public int getIntArg(String key, int defaultValue) {
        String arg = this.getString(key);
        try {
            return Integer.parseInt(arg);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public long getLongArg(String key, long defaultValue) {
        String arg = this.getString(key);
        try {
            return Long.parseLong(arg);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    protected Object handleGetObject(String key) {
        String[] obj = null;
        try {
            obj = this.bundle.getObject(key);
        }
        catch (MissingResourceException ex) {
            LOGGER.error("con't find resourse:{}", (Object)key);
            return DEFAULT_NULL_STRING;
        }
        if (obj instanceof String) {
            obj = this.replaceKeyWords((String)obj);
        } else if (obj instanceof String[]) {
            obj = this.replaceKeyWords(obj);
        }
        return obj;
    }

    private void toLog(Throwable throwable) {
        if (Boolean.valueOf(System.getProperty("ENABLE_RESOURCE_LOG", "false")).booleanValue()) {
            LOGGER.warn(throwable.getMessage());
        }
    }

    private String replaceKeyWords(String input) {
        if (null == this.keyWordMap || null == input) {
            return input;
        }
        String output = input;
        for (String key : this.keyWordMap.keySet()) {
            String value = this.keyWordMap.get(key);
            output = output.replaceAll(key, value);
        }
        return output;
    }

    private String[] replaceKeyWords(String[] input) {
        String[] output = new String[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = this.replaceKeyWords(output[i]);
        }
        return output;
    }

    private Map<String, String> getDefalutKeyMap() {
        return new HashMap<String, String>(0);
    }

    private void init(String propertyRelativePath, Locale locale) {
        if (null == this.bundle) {
            this.bundle = ResourceBundle.getBundle(propertyRelativePath, locale, this.loader);
        }
        this.keyWordMap = this.getDefalutKeyMap();
    }
}

