/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util.parser;

import com.huawei.ism.util.parser.XmlDomParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class XmlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlParser.class);

    public static XmlParser getXmlDomParser(InputStream is) throws SAXException, IOException {
        return new XmlDomParser(is);
    }

    public static XmlParser getXmlDomParser(String fileRelativePath) {
        try {
            return new XmlDomParser(fileRelativePath);
        }
        catch (Exception e) {
            LOGGER.error(fileRelativePath + "\nnot found,return null", (Throwable)e);
            return null;
        }
    }

    public static XmlParser getXmlDomParser(String fileRelativePath, ClassLoader cl) {
        try {
            return new XmlDomParser(fileRelativePath, cl);
        }
        catch (Exception e) {
            LOGGER.error(fileRelativePath + "not found,return null", (Throwable)e);
            return null;
        }
    }

    public static XmlParser getXmlDomParser(File file) {
        try {
            return new XmlDomParser(file);
        }
        catch (Exception e) {
            LOGGER.error(file + "not found,return null", (Throwable)e);
            return null;
        }
    }

    public abstract String getAttributeValueOfElementNode(Node var1, String var2);

    public abstract ClassLoader getClassLoader();

    public abstract String getTextContentOfChild(Element var1, String var2);

    public abstract Element treeWalkOfOneElementNode(Element var1, String var2);

    public abstract Element treeWalkOfOneElementNode(Element var1, String var2, String var3, String var4);

    public abstract Element treeWalkOfOneElementNode(String var1);

    public abstract Element treeWalkOfOneElementNode(String var1, String var2, String var3);

    public abstract Collection<Element> getChildren(Element var1, String var2);

    public abstract Collection<Element> getChildren(Element var1);

    public abstract Element getChild(Element var1, String var2);
}

