/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.a800switch;

import com.huawei.ism.tool.a800switch.A800SwitchType;
import com.huawei.ism.tool.a800switch.SwitchMgmtParm;
import com.huawei.ism.tool.a800switch.SwitchNetConfParam;
import com.huawei.ism.tool.a800switch.SwitchParamHandler;
import com.huawei.ism.tool.a800switch.SwitchSTelnetMode;
import com.huawei.ism.tool.a800switch.SwitchSTelnetParam;
import com.huawei.ism.tool.a800switch.SwitchScaleOutParam;
import com.huawei.ism.tool.a800switch.SwitchSnmpParam;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class A800SwitchConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(A800SwitchConfigUtil.class);
    private static final BiFunction<String, String, List<String>> MAKE_SURE_HANDLER = (command, ret) -> {
        if (A800SwitchConfigUtil.checkNeedMakeSure(ret)) {
            return Collections.singletonList("Y");
        }
        return Collections.emptyList();
    };
    private static List<String> switchCliCommandEndStrs = Arrays.asList("]", ">", ":");

    public static void setSwitchCliCommandEndStrs(List<String> switchCliEndStrs) {
        if (CollectionUtils.isNotEmpty(switchCliEndStrs)) {
            switchCliCommandEndStrs = new ArrayList<String>(switchCliEndStrs);
        }
    }

    public static String configMgmtSwitch(ICliConnection cli, SwitchMgmtParm parm) throws ToolException {
        try {
            StringBuilder cliRet = new StringBuilder();
            A800SwitchType switchType = A800SwitchConfigUtil.parseSwitchType(cli, cliRet);
            if (switchType == A800SwitchType.NOT_SUPPORT || CollectionUtils.isEmpty(switchType.getMgmtConfigFiles())) {
                throw new ToolException("switch.not.support");
            }
            A800SwitchConfigUtil.executeSwitchConfig(cli, cliRet, switchType.getMgmtConfigFiles(), parm::buildParams);
            return cliRet.toString();
        }
        catch (IOException e) {
            log.error("config a800 mgmt switch failed.", e);
            throw new ToolException(e.getMessage(), e.getCause());
        }
    }

    public static String configScaleOutL1Switch(ICliConnection cli, SwitchScaleOutParam param) throws ToolException {
        try {
            StringBuilder cliRet = new StringBuilder();
            A800SwitchType switchType = A800SwitchConfigUtil.parseSwitchType(cli, cliRet);
            if (switchType == A800SwitchType.NOT_SUPPORT || CollectionUtils.isEmpty(switchType.getScaleOutL1ConfigFiles())) {
                throw new ToolException("switch.not.support");
            }
            A800SwitchConfigUtil.executeSwitchConfig(cli, cliRet, A800SwitchConfigUtil.getL1ConfigFiles(switchType, param), param::buildParams);
            return cliRet.toString();
        }
        catch (IOException e) {
            log.error("config scale out L1 failed.", e);
            throw new ToolException(e.getMessage(), e.getCause());
        }
    }

    private static List<String> getL1ConfigFiles(A800SwitchType switchType, SwitchScaleOutParam param) {
        return param.isOriginL1Switch() ? Collections.singletonList("/switch_config/scale-out_L1_switch_trunk.cfg") : switchType.getScaleOutL1ConfigFiles();
    }

    public static String configScaleOutL2Switch(ICliConnection cli, SwitchScaleOutParam parm) throws ToolException {
        try {
            StringBuilder cliRet = new StringBuilder();
            A800SwitchType switchType = A800SwitchConfigUtil.parseSwitchType(cli, cliRet);
            if (switchType == A800SwitchType.NOT_SUPPORT || CollectionUtils.isEmpty(switchType.getScaleOutL2ConfigFiles())) {
                throw new ToolException("switch.not.support");
            }
            A800SwitchConfigUtil.executeSwitchConfig(cli, cliRet, switchType.getScaleOutL2ConfigFiles(), parm::buildParams);
            return cliRet.toString();
        }
        catch (IOException e) {
            log.error("config scale out L2 switch failed.", e);
            throw new ToolException(e.getMessage(), e.getCause());
        }
    }

    public static String configSnmpInfo(ICliConnection cli, SwitchSnmpParam switchParam) throws ToolException {
        try {
            StringBuilder cliRet = new StringBuilder();
            A800SwitchType switchType = A800SwitchConfigUtil.parseSwitchType(cli, cliRet);
            if (switchType == A800SwitchType.NOT_SUPPORT || StringUtils.isEmpty((CharSequence)switchType.getSnmpConfigFile())) {
                throw new ToolException("switch.not.support");
            }
            A800SwitchConfigUtil.executeSingleSwitchConfig(cli, cliRet, switchType.getSnmpConfigFile(), (command, ret) -> {
                if (command.contains("authentication-mode")) {
                    return Arrays.asList(switchParam.getAuthPassword(), switchParam.getAuthPassword());
                }
                if (command.contains("privacy-mode")) {
                    return Arrays.asList(switchParam.getEncPassword(), switchParam.getEncPassword());
                }
                return MAKE_SURE_HANDLER.apply((String)command, (String)ret);
            }, switchParam);
            return A800SwitchConfigUtil.handleSensitiveKeys(cliRet.toString(), switchParam);
        }
        catch (IOException e) {
            log.error("config SNMP switch failed.", e);
            throw new ToolException(e.getMessage(), e.getCause());
        }
    }

    public static String configSTelnetInfo(ICliConnection cli, SwitchSTelnetParam switchParam) throws ToolException {
        try {
            StringBuilder cliRet = new StringBuilder();
            A800SwitchType switchType = A800SwitchConfigUtil.parseSwitchType(cli, cliRet);
            SwitchSTelnetMode authMode = switchParam.getAuthMode();
            if (switchType == A800SwitchType.NOT_SUPPORT || !switchType.getSTelnetModes().contains((Object)authMode)) {
                log.error("config sTelnet info, switch type : {}, authMode : {}.", (Object)switchType, (Object)authMode);
                throw new ToolException("switch.not.support");
            }
            A800SwitchConfigUtil.executeSingleSwitchConfig(cli, cliRet, authMode.getConfigFile(), (command, ret) -> {
                if (command.equals("rsa local-key-pair create")) {
                    return Collections.singletonList("N");
                }
                return MAKE_SURE_HANDLER.apply((String)command, (String)ret);
            }, switchParam);
            return A800SwitchConfigUtil.handleSensitiveKeys(cliRet.toString(), switchParam);
        }
        catch (IOException e) {
            log.error("config STelnet failed.", e);
            throw new ToolException(e.getMessage(), e.getCause());
        }
    }

    public static String configNetconfInfo(ICliConnection cli, SwitchNetConfParam switchParam) throws ToolException {
        try {
            StringBuilder cliRet = new StringBuilder();
            A800SwitchType switchType = A800SwitchConfigUtil.parseSwitchType(cli, cliRet);
            if (switchType == A800SwitchType.NOT_SUPPORT || StringUtils.isEmpty((CharSequence)switchType.getNetconfConfigFile())) {
                throw new ToolException("switch.not.support");
            }
            A800SwitchConfigUtil.executeSingleSwitchConfig(cli, cliRet, switchType.getNetconfConfigFile(), MAKE_SURE_HANDLER, switchParam);
            return A800SwitchConfigUtil.handleSensitiveKeys(cliRet.toString(), switchParam);
        }
        catch (IOException e) {
            log.error("config netconf info failed.", e);
            throw new ToolException(e.getMessage(), e.getCause());
        }
    }

    private static A800SwitchType parseSwitchType(ICliConnection cli, StringBuilder cliRet) throws ToolException {
        String displayVersion = cli.execCmd("display version", switchCliCommandEndStrs);
        log.info("current switch version : {}", (Object)displayVersion);
        cliRet.append(displayVersion).append("\n");
        return A800SwitchType.of(displayVersion);
    }

    private static void executeSwitchConfig(ICliConnection cli, StringBuilder cliRet, List<String> switchCfgFiles, Supplier<Map<String, String>> paramSupplier) throws IOException, ToolException {
        cliRet.append(cli.execCmd("screen-length 0 temporary", switchCliCommandEndStrs)).append("\n");
        Map<String, String> params = paramSupplier.get();
        log.info("start to execute switch config, params : {}.", (Object)params);
        for (String switchCfgFile : switchCfgFiles) {
            for (String command : A800SwitchConfigUtil.getSwitchCfgCommand(switchCfgFile, params)) {
                String ret = cli.execCmd(command, switchCliCommandEndStrs);
                cliRet.append(ret).append("\n");
                A800SwitchConfigUtil.handleMakeSureReturn(cli, cliRet, ret);
            }
        }
    }

    private static void handleMakeSureReturn(ICliConnection cli, StringBuilder cliRet, String cmdRet) throws ToolException {
        String ret = cmdRet;
        while (A800SwitchConfigUtil.checkNeedMakeSure(ret)) {
            ret = cli.execCmd("Y", switchCliCommandEndStrs);
            cliRet.append(ret).append("\n");
        }
    }

    private static boolean checkNeedMakeSure(String cmdRet) {
        return cmdRet.endsWith("[Y/N]:") || cmdRet.endsWith("[Y(yes)/N(no)/C(cancel)]:");
    }

    private static void executeSingleSwitchConfig(ICliConnection cli, StringBuilder cliRet, String switchCfgFile, BiFunction<String, String, List<String>> cliRetHandler, SwitchParamHandler handler) throws IOException, ToolException {
        cliRet.append(cli.execCmd("screen-length 0 temporary", switchCliCommandEndStrs)).append("\n");
        Map<String, String> params = handler.buildParams();
        log.info("start to execute switch config, params size : {}.", (Object)params.size());
        for (String command : A800SwitchConfigUtil.getSwitchCfgCommand(switchCfgFile, params)) {
            if (!handler.isNeedExecute(command)) continue;
            String ret = cli.execCmdNoLog(command, switchCliCommandEndStrs);
            cliRet.append(ret).append("\n");
            List<String> handleRets = cliRetHandler.apply(command, ret);
            if (CollectionUtils.isEmpty(handleRets)) continue;
            for (String handleRet : handleRets) {
                ret = cli.execCmdNoLog(handleRet, switchCliCommandEndStrs);
                cliRet.append(ret).append("\n");
            }
        }
    }

    private static List<String> getSwitchCfgCommand(String cfgFileName, Map<String, String> params) throws IOException {
        URL cfgFileUrl = Objects.requireNonNull(A800SwitchConfigUtil.class.getResource(cfgFileName));
        String switchCmd = IOUtils.toString((URL)cfgFileUrl, (Charset)StandardCharsets.UTF_8);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{entry.getKey(), entry.getValue()})) continue;
            switchCmd = switchCmd.replace(entry.getKey(), entry.getValue());
        }
        return A800SwitchConfigUtil.replaceSwitchComment(A800SwitchConfigUtil.handleRepeatPortConfig(switchCmd));
    }

    private static List<String> replaceSwitchComment(String switchCmd) {
        return Stream.of(switchCmd.split("\\R")).filter(StringUtils::isNotEmpty).filter(line -> !line.startsWith("#")).collect(Collectors.toList());
    }

    private static String handleRepeatPortConfig(String switchCmd) {
        if (!switchCmd.startsWith("####REPLEAT;")) {
            return switchCmd;
        }
        StringBuilder sBuilder = new StringBuilder();
        String[] commands = switchCmd.split("\\R");
        String[] repeatParams = commands[0].split(";");
        for (int idx = 1; idx < repeatParams.length; ++idx) {
            String[] singleParams = repeatParams[idx].split("=");
            if (singleParams.length != 2) {
                log.warn("repeat params [{}] split invalid.", (Object)repeatParams[idx]);
                continue;
            }
            Stream.of(singleParams[1].split(",")).forEach(port -> {
                String portName = singleParams[0].replace("{port}", (CharSequence)port);
                sBuilder.append(switchCmd.replace("{portName}", portName)).append("\n");
            });
        }
        return sBuilder.toString();
    }

    private static String handleSensitiveKeys(String orgText, SwitchParamHandler handler) {
        String replaceText = orgText;
        for (String sensitiveKey : handler.getSensitiveKeys()) {
            if (StringUtils.isEmpty((CharSequence)sensitiveKey)) continue;
            replaceText = replaceText.replace(sensitiveKey, "******");
        }
        return replaceText;
    }

    private A800SwitchConfigUtil() {
    }
}

