/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.cert.auth;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.util.CommonUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;

public class CertUtil {
    private static final String CONFIG = "/config";
    private static final String X509 = "X.509";
    public static final String CERT_BEGIN = "-----BEGIN CERTIFICATE-----\n";
    public static final String CERT_END = "-----END CERTIFICATE-----";
    private static Map<String, String> pemCertMap = new HashMap<String, String>();
    public static final String CERT_LOC = "/config/devicecerts/";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CertUtil.class);

    public static void initCertCheckContext() {
        try {
            CertUtil.initContextFromJar();
        }
        catch (RuntimeException e) {
            CertUtil.initInDevelopLoc();
            LOGGER.error("error when read file.", e);
        }
        catch (Exception e) {
            CertUtil.initInDevelopLoc();
            LOGGER.error("error when read file.", e);
        }
    }

    private static void initContextFromJar() throws IOException {
        URL url = CertUtil.class.getResource(CERT_LOC);
        if (url == null) {
            LOGGER.info("url is null.");
            return;
        }
        JarURLConnection jarURLConnection = (JarURLConnection)CommonUtil.convertObject((Object)url.openConnection(), JarURLConnection.class);
        if (jarURLConnection == null) {
            return;
        }
        JarFile jf = jarURLConnection.getJarFile();
        Enumeration<JarEntry> jarEntries = jf.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.endsWith(".pem")) continue;
            CertUtil.readFileToCache("/" + jarEntryName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFileToCache(String pemLoc) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(CertUtil.class.getResourceAsStream(pemLoc), Charset.defaultCharset()));
            StringBuilder content = new StringBuilder();
            String s = null;
            while ((s = br.readLine()) != null) {
                content.append(s);
                content.append('\n');
            }
            pemCertMap.put(pemLoc, content.toString());
            StreamUtils.closeResource(null, (Closeable)br);
        }
        catch (IOException e) {
            LOGGER.error("error when read file.", e);
        }
        finally {
            StreamUtils.closeResource(null, br);
        }
    }

    private static void initInDevelopLoc() {
        URL url = CertUtil.class.getResource(CERT_LOC);
        File file = null;
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            LOGGER.error("url syntax exception.", e);
            return;
        }
        File[] files = file.listFiles();
        if (null == files) {
            LOGGER.error("The path does not exist or is not a directory: {}", (Object)file);
            return;
        }
        for (File pemLoc : files) {
            try (FileInputStream fis = new FileInputStream(pemLoc);
                 InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.defaultCharset());
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                StringBuilder content = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    content.append(line);
                    content.append('\n');
                }
                pemCertMap.put(pemLoc.getName(), content.toString());
            }
            catch (IOException e) {
                LOGGER.error("error when read file.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static X509Certificate getCertificateFromFile(String certFile) {
        X509Certificate x509Certificate;
        InputStream in = null;
        try {
            X509Certificate cert;
            in = certFile.startsWith(CONFIG) ? CertUtil.class.getResourceAsStream(certFile) : new FileInputStream(FilePathUtils.checkFile((String)certFile));
            CertificateFactory cf = CertificateFactory.getInstance(X509);
            x509Certificate = cert = (X509Certificate)cf.generateCertificate(in);
        }
        catch (CertificateException e) {
            LOGGER.error("Certificate ex:", e);
            StreamUtils.closeStream(null, (InputStream)in);
        }
        catch (FileNotFoundException e2) {
            LOGGER.error("Certificate error!");
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, in);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, (InputStream)in);
        }
        StreamUtils.closeStream(null, (InputStream)in);
        return x509Certificate;
        return null;
    }

    public static String readCertFromPemFile(String pemLoc) {
        if (pemLoc == null) {
            return null;
        }
        if (pemCertMap.containsKey(pemLoc)) {
            return pemCertMap.get(pemLoc);
        }
        return CERT_BEGIN;
    }

    public static boolean isValid(X509Certificate cert, X509Certificate trustCert) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        if (cert == null || trustCert == null) {
            LOGGER.warn("cert is null or trust cert is null." + (cert == null) + " " + (trustCert == null));
            return false;
        }
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(cert);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        trustAnchors.add(new TrustAnchor(trustCert, null));
        HashSet<X509Certificate> add2store = new HashSet<X509Certificate>();
        add2store.add(trustCert);
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        pkixParams.setRevocationEnabled(false);
        CertStore intermediateCertStore = CertStore.getInstance("Collection", new CollectionCertStoreParameters(add2store));
        pkixParams.addCertStore(intermediateCertStore);
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
        try {
            builder.build(pkixParams);
        }
        catch (CertPathBuilderException e) {
            LOGGER.error("Not find valid path cert is not valid.");
            return false;
        }
        return true;
    }

    public static boolean isInCrl(X509Certificate cert, X509CRL crl) {
        if (crl == null || cert == null) {
            LOGGER.warn("crt or crl is null.crl:" + (crl == null) + " crt:" + (cert == null));
            return false;
        }
        return crl.isRevoked(cert);
    }

    /*
     * Exception decompiling
     */
    public static X509CRL getCrl(String crlFileAbsPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isValidCert(String pemCertFromDevice) {
        for (Map.Entry<String, String> entry : pemCertMap.entrySet()) {
            String cert = entry.getValue();
            if (!(cert = cert.replaceAll("\r\n", "\n")).contains(pemCertFromDevice = pemCertFromDevice.replaceAll("\r\n", "\n")) && !pemCertFromDevice.contains(cert)) continue;
            LOGGER.info("cert finded!!!!");
            return true;
        }
        return false;
    }

    static {
        CertUtil.initCertCheckContext();
    }
}

